/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExShowScreenMessage
extends L2GameServerPacket {
    private final int _type;
    private final int _sysMessageId;
    private final int _position;
    private final int _unk1;
    private final int _size;
    private final int _unk2;
    private final int _unk3;
    private final boolean _effect;
    private final int _time;
    private final boolean _fade;
    private final String _text;
    private final int _npcString;
    private List<String> _parameters = null;
    public static final byte TOP_LEFT = 1;
    public static final byte TOP_CENTER = 2;
    public static final byte TOP_RIGHT = 3;
    public static final byte MIDDLE_LEFT = 4;
    public static final byte MIDDLE_CENTER = 5;
    public static final byte MIDDLE_RIGHT = 6;
    public static final byte BOTTOM_CENTER = 7;
    public static final byte BOTTOM_RIGHT = 8;
    public static final int SIZE_LARGE = 0;
    public static final int SIZE_SMALL = 1;

    public ExShowScreenMessage(String text, int time) {
        this(text, 2, time);
    }

    public ExShowScreenMessage(NpcStringId npcString, int position, int time, String ... params) {
        this(2, -1, position, 0, 0, 0, 0, false, time, false, null, npcString.getId());
        this.addStringParameter(params);
    }

    public ExShowScreenMessage(int npcString, int position, int time) {
        this(2, -1, position, 0, 0, 0, 0, false, time, false, null, npcString);
    }

    public ExShowScreenMessage(NpcStringId npcString, int position, int time) {
        this(2, -1, position, 0, 0, 0, 0, false, time, false, null, npcString.getId());
    }

    public ExShowScreenMessage(SystemMessageId systemMsg, int position, int time, String ... params) {
        this(2, systemMsg.getId(), position, 0, 0, 0, 0, false, time, false, null, -1);
        this.addStringParameter(params);
    }

    public ExShowScreenMessage(SystemMessageId systemMsg, int position, int time) {
        this(2, systemMsg.getId(), position, 0, 0, 0, 0, false, time, false, null, -1);
    }

    public ExShowScreenMessage(String text, int position, int time) {
        this(1, -1, position, 0, 0, 0, 0, false, time, false, text, -1);
    }

    public ExShowScreenMessage(int type, int messageId, int position, int unk1, int size, int unk2, int unk3, boolean showEffect, int time, boolean fade, String text, int npcString, String ... params) {
        this(type, messageId, position, unk1, size, unk2, unk3, showEffect, time, fade, text, npcString);
        this._parameters = Arrays.asList(params);
    }

    public ExShowScreenMessage(int type, int messageId, int position, int unk1, int size, int unk2, int unk3, boolean showEffect, int time, boolean fade, String text, int npcString) {
        this._type = type;
        this._sysMessageId = messageId;
        this._unk1 = unk1;
        this._unk2 = unk2;
        this._unk3 = unk3;
        this._fade = fade;
        this._position = position;
        this._text = text;
        this._time = time;
        this._size = size;
        this._effect = showEffect;
        this._npcString = npcString;
    }

    public ExShowScreenMessage(int type, int messageId, int position, int unk1, int size, int unk2, int unk3, boolean showEffect, int time, boolean fade, String text, NpcStringId npcString) {
        this(type, messageId, position, unk1, size, unk2, unk3, showEffect, time, fade, text, npcString.getId());
    }

    public void addStringParameter(String ... params) {
        if (params != null) {
            for (String param : params) {
                this.addStringParameter(param);
            }
        }
    }

    public ExShowScreenMessage addStringParameter(String text) {
        if (this._parameters == null) {
            this._parameters = new ArrayList<String>();
        }
        this._parameters.add(text);
        return this;
    }

    public ExShowScreenMessage addString(String text) {
        return this.addStringParameter(text);
    }

    public ExShowScreenMessage addPcName(L2PcInstance pc) {
        return this.addStringParameter(pc.getName());
    }

    public ExShowScreenMessage addNpcName(L2Npc npc) {
        return this.addStringParameter(npc.getName());
    }

    public ExShowScreenMessage addNumber(int number) {
        return this.addStringParameter(String.valueOf(number));
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(57);
        this.writeD(this._type);
        this.writeD(this._sysMessageId);
        this.writeD(this._position);
        this.writeD(this._unk1);
        this.writeD(this._size);
        this.writeD(this._unk2);
        this.writeD(this._unk3);
        this.writeD(this._effect ? 1 : 0);
        this.writeD(this._time);
        this.writeD(this._fade ? 1 : 0);
        this.writeD(this._npcString);
        if (this._npcString == -1) {
            this.writeS(this._text);
        } else if (this._parameters != null) {
            for (String s : this._parameters) {
                this.writeS(s);
            }
        }
    }
}

