/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractItemPacket;

public class ExBuySellList
extends AbstractItemPacket {
    private L2ItemInstance[] _sellList = null;
    private L2ItemInstance[] _refundList = null;
    private final boolean _done;

    public ExBuySellList(L2PcInstance player, boolean done) {
        this._sellList = player.getInventory().getAvailableItems(false, false, false);
        if (player.hasRefund()) {
            this._refundList = player.getRefund().getItems();
        }
        this._done = done;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(254);
        this.writeH(183);
        this.writeD(1);
        if (this._sellList != null) {
            this.writeH(this._sellList.length);
            for (L2ItemInstance item : this._sellList) {
                this.writeItem(item);
                this.writeQ(item.getItem().getReferencePrice() / 2);
            }
        } else {
            this.writeH(0);
        }
        if (this._refundList != null && this._refundList.length > 0) {
            this.writeH(this._refundList.length);
            int i = 0;
            for (L2ItemInstance item : this._refundList) {
                this.writeItem(item);
                this.writeD(i++);
                this.writeQ((long)(item.getItem().getReferencePrice() / 2) * item.getCount());
            }
        } else {
            this.writeH(0);
        }
        this.writeC(this._done ? 1 : 0);
    }
}

