/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.base.AcquireSkillType;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import java.util.List;

public final class AcquireSkillList
extends L2GameServerPacket {
    private final List<Skill> _skills;
    private final AcquireSkillType _skillType;

    public AcquireSkillList(AcquireSkillType type) {
        this._skillType = type;
        this._skills = new ArrayList<Skill>();
    }

    public void addSkill(int id, int nextLevel, int maxLevel, int spCost, int requirements) {
        this._skills.add(new Skill(id, nextLevel, maxLevel, spCost, requirements));
    }

    @Override
    protected void writeImpl() {
        if (this._skills.isEmpty()) {
            return;
        }
        this.writeC(144);
        this.writeD(this._skillType.ordinal());
        this.writeD(this._skills.size());
        for (Skill temp : this._skills) {
            this.writeD(temp.id);
            this.writeD(temp.nextLevel);
            this.writeD(temp.maxLevel);
            this.writeD(temp.spCost);
            this.writeD(temp.requirements);
            if (this._skillType != AcquireSkillType.SUBPLEDGE) continue;
            this.writeD(0);
        }
    }

    private static class Skill {
        public int id;
        public int nextLevel;
        public int maxLevel;
        public int spCost;
        public int requirements;

        public Skill(int pId, int pNextLevel, int pMaxLevel, int pSpCost, int pRequirements) {
            this.id = pId;
            this.nextLevel = pNextLevel;
            this.maxLevel = pMaxLevel;
            this.spCost = pSpCost;
            this.requirements = pRequirements;
        }
    }
}

