/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.PcFreight;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Level;

public class RequestPackageSend
extends L2GameClientPacket {
    private final String _C_A8_REQUESTPACKAGESEND = "[C] A8 RequestPackageSend";
    private static final int BATCH_LENGTH = 12;
    private ItemHolder[] _items = null;
    private int _objectId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 12 != this._buf.remaining()) {
            return;
        }
        this._items = new ItemHolder[count];
        for (int i = 0; i < count; ++i) {
            int objId = this.readD();
            long cnt = this.readQ();
            if (objId < 1 || cnt < 0L) {
                this._items = null;
                return;
            }
            this._items[i] = new ItemHolder(objId, cnt);
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = this.getActiveChar();
        if (this._items == null || player == null || !player.getAccountChars().containsKey(this._objectId)) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("deposit")) {
            player.sendMessage("You depositing items too fast.");
            return;
        }
        L2Npc manager = player.getLastFolkNPC();
        if (manager == null || !player.isInsideRadius(manager, 150, false, false)) {
            return;
        }
        if (player.getActiveEnchantItemId() != -1) {
            Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to use enchant Exploit!", Config.DEFAULT_PUNISH);
            return;
        }
        if (player.getActiveTradeList() != null) {
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_USE_WAREHOUSE && player.getKarma() > 0) {
            return;
        }
        int fee = this._items.length * Config.ALT_FREIGHT_PRICE;
        long currentAdena = player.getAdena();
        int slots = 0;
        PcFreight warehouse = new PcFreight(this._objectId);
        for (ItemHolder i : this._items) {
            L2ItemInstance item = player.checkItemManipulation(i.getId(), i.getCount(), "freight");
            if (item == null) {
                _log.log(Level.WARNING, "Error depositing a warehouse object for char " + player.getName() + " (validity check)");
                warehouse.deleteMe();
                return;
            }
            if (!item.isFreightable()) {
                warehouse.deleteMe();
                return;
            }
            if (item.getId() == 57) {
                currentAdena -= i.getCount();
                continue;
            }
            if (!item.isStackable()) {
                slots = (int)((long)slots + i.getCount());
                continue;
            }
            if (warehouse.getItemByItemId(item.getId()) != null) continue;
            ++slots;
        }
        if (!((ItemContainer)warehouse).validateCapacity(slots)) {
            player.sendPacket(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED);
            warehouse.deleteMe();
            return;
        }
        if (currentAdena < (long)fee || !player.reduceAdena(((ItemContainer)warehouse).getName(), fee, manager, false)) {
            player.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
            warehouse.deleteMe();
            return;
        }
        InventoryUpdate playerIU = Config.FORCE_INVENTORY_UPDATE ? null : new InventoryUpdate();
        for (ItemHolder i : this._items) {
            L2ItemInstance oldItem = player.checkItemManipulation(i.getId(), i.getCount(), "deposit");
            if (oldItem == null) {
                _log.log(Level.WARNING, "Error depositing a warehouse object for char " + player.getName() + " (olditem == null)");
                warehouse.deleteMe();
                return;
            }
            L2ItemInstance newItem = player.getInventory().transferItem("Trade", i.getId(), i.getCount(), warehouse, player, null);
            if (newItem == null) {
                _log.log(Level.WARNING, "Error depositing a warehouse object for char " + player.getName() + " (newitem == null)");
                continue;
            }
            if (playerIU == null) continue;
            if (oldItem.getCount() > 0L && oldItem != newItem) {
                playerIU.addModifiedItem(oldItem);
                continue;
            }
            playerIU.addRemovedItem(oldItem);
        }
        warehouse.deleteMe();
        this.sendPacket(playerIU != null ? playerIU : new ItemList(player, false));
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        this.sendPacket(su);
    }

    @Override
    public String getType() {
        return "[C] A8 RequestPackageSend";
    }
}

