/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.util.Util;

public final class RequestGiveItemToPet
extends L2GameClientPacket {
    private static final String _C__95_REQUESTCIVEITEMTOPET = "[C] 95 RequestGiveItemToPet";
    private int _objectId;
    private long _amount;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._amount = this.readQ();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (this._amount <= 0L || player == null || !player.hasPet()) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("giveitemtopet")) {
            player.sendMessage("You are giving items to pet too fast.");
            return;
        }
        if (player.getActiveEnchantItemId() != -1) {
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_TRADE && player.getKarma() > 0) {
            return;
        }
        if (player.getPrivateStoreType() != PrivateStoreType.NONE) {
            player.sendPacket(SystemMessageId.PRIVATE_STORE_UNDER_WAY);
            return;
        }
        L2ItemInstance item = player.getInventory().getItemByObjectId(this._objectId);
        if (item == null) {
            return;
        }
        if (this._amount > item.getCount()) {
            Util.handleIllegalPlayerAction(player, ((Object)((Object)this)).getClass().getSimpleName() + ": Character " + player.getName() + " of account " + player.getAccountName() + " tried to get item with oid " + this._objectId + " from pet but has invalid count " + this._amount + " item count: " + item.getCount(), Config.DEFAULT_PUNISH);
            return;
        }
        if (item.isAugmented()) {
            return;
        }
        if (item.isHeroItem() || !item.isDropable() || !item.isDestroyable() || !item.isTradeable()) {
            player.sendPacket(SystemMessageId.ITEM_NOT_FOR_PETS);
            return;
        }
        L2PetInstance pet = (L2PetInstance)player.getSummon();
        if (pet.isDead()) {
            player.sendPacket(SystemMessageId.CANNOT_GIVE_ITEMS_TO_DEAD_PET);
            return;
        }
        if (!pet.getInventory().validateCapacity(item)) {
            player.sendPacket(SystemMessageId.YOUR_PET_CANNOT_CARRY_ANY_MORE_ITEMS);
            return;
        }
        if (!pet.getInventory().validateWeight(item, this._amount)) {
            player.sendPacket(SystemMessageId.UNABLE_TO_PLACE_ITEM_YOUR_PET_IS_TOO_ENCUMBERED);
            return;
        }
        if (player.transferItem("Transfer", this._objectId, this._amount, pet.getInventory(), pet) == null) {
            _log.warning("Invalid item transfer request: " + pet.getName() + "(pet) --> " + player.getName());
        }
    }

    @Override
    public String getType() {
        return _C__95_REQUESTCIVEITEMTOPET;
    }
}

