/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.EnchantSkillGroupsData;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2EnchantSkillGroup;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfo;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfoDetail;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillResult;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.util.Rnd;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class RequestExEnchantSkillSafe
extends L2GameClientPacket {
    private static final String _C__D0_32_REQUESTEXENCHANTSKILLSAFE = "[C] D0:32 RequestExEnchantSkillSafe";
    private static final Logger _logEnchant = Logger.getLogger("enchant");
    private int _skillId;
    private int _skillLvl;

    @Override
    protected void readImpl() {
        this._skillId = this.readD();
        this._skillLvl = this.readD();
    }

    @Override
    protected void runImpl() {
        if (this._skillId <= 0 || this._skillLvl <= 0) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (player.getClassId().level() < 3) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_IN_THIS_CLASS);
            return;
        }
        if (player.getLevel() < 76) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_ON_THIS_LEVEL);
            return;
        }
        if (!player.isAllowedToEnchantSkills()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_ATTACKING_TRANSFORMED_BOAT);
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._skillId, this._skillLvl);
        if (skill == null) {
            return;
        }
        int costMultiplier = EnchantSkillGroupsData.SAFE_ENCHANT_COST_MULTIPLIER;
        int reqItemId = 9627;
        L2EnchantSkillLearn s = EnchantSkillGroupsData.getInstance().getSkillEnchantmentBySkillId(this._skillId);
        if (s == null) {
            return;
        }
        L2EnchantSkillGroup.EnchantSkillHolder esd = s.getEnchantSkillHolder(this._skillLvl);
        int beforeEnchantSkillLevel = player.getSkillLevel(this._skillId);
        if (beforeEnchantSkillLevel != s.getMinSkillLevel(this._skillLvl)) {
            return;
        }
        int requiredSp = esd.getSpCost() * costMultiplier;
        int requireditems = esd.getAdenaCost() * costMultiplier;
        byte rate = esd.getRate(player);
        if (player.getSp() >= requiredSp) {
            SystemMessage sm;
            LogRecord record;
            L2ItemInstance spb = player.getInventory().getItemByItemId(reqItemId);
            if (spb == null) {
                player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
                return;
            }
            if (player.getInventory().getAdena() < (long)requireditems) {
                player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
                return;
            }
            boolean check = player.getStat().removeExpAndSp(0L, requiredSp, false);
            check &= player.destroyItem("Consume", spb.getObjectId(), 1L, (L2Object)player, true);
            if (!(check &= player.destroyItemByItemId("Consume", 57, requireditems, player, true))) {
                player.sendPacket(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL);
                return;
            }
            if (Rnd.get(100) <= rate) {
                if (Config.LOG_SKILL_ENCHANTS) {
                    record = new LogRecord(Level.INFO, "Safe Success");
                    record.setParameters(new Object[]{player, skill, spb, (int)rate});
                    record.setLoggerName("skill");
                    _logEnchant.log(record);
                }
                player.addSkill(skill, true);
                if (Config.DEBUG) {
                    _log.fine("Learned skill ID: " + this._skillId + " Level: " + this._skillLvl + " for " + requiredSp + " SP, " + requireditems + " Adena.");
                }
                player.sendPacket(ExEnchantSkillResult.valueOf(true));
                sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_SUCCEEDED_IN_ENCHANTING_THE_SKILL_S1);
                sm.addSkillName(this._skillId);
                player.sendPacket(sm);
            } else {
                if (Config.LOG_SKILL_ENCHANTS) {
                    record = new LogRecord(Level.INFO, "Safe Fail");
                    record.setParameters(new Object[]{player, skill, spb, (int)rate});
                    record.setLoggerName("skill");
                    _logEnchant.log(record);
                }
                sm = SystemMessage.getSystemMessage(SystemMessageId.SKILL_ENCHANT_FAILED_S1_LEVEL_WILL_REMAIN);
                sm.addSkillName(this._skillId);
                player.sendPacket(sm);
                player.sendPacket(ExEnchantSkillResult.valueOf(false));
            }
            player.sendPacket(new UserInfo(player));
            player.sendPacket(new ExBrExtraUserInfo(player));
            player.sendSkillList();
            int afterEnchantSkillLevel = player.getSkillLevel(this._skillId);
            player.sendPacket(new ExEnchantSkillInfo(this._skillId, afterEnchantSkillLevel));
            player.sendPacket(new ExEnchantSkillInfoDetail(1, this._skillId, afterEnchantSkillLevel + 1, player));
            player.updateShortCuts(this._skillId, afterEnchantSkillLevel);
        } else {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DONT_HAVE_ENOUGH_SP_TO_ENCHANT_THAT_SKILL);
            player.sendPacket(sm);
        }
    }

    @Override
    public String getType() {
        return _C__D0_32_REQUESTEXENCHANTSKILLSAFE;
    }
}

