/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.clientpackets.RequestJoinAlly;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;

public final class RequestAnswerJoinAlly
extends L2GameClientPacket {
    private static final String _C__8D_REQUESTANSWERJOINALLY = "[C] 8D RequestAnswerJoinAlly";
    private int _response;

    @Override
    protected void readImpl() {
        this._response = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2PcInstance requestor = activeChar.getRequest().getPartner();
        if (requestor == null) {
            return;
        }
        if (this._response == 0) {
            activeChar.sendPacket(SystemMessageId.YOU_DID_NOT_RESPOND_TO_ALLY_INVITATION);
            requestor.sendPacket(SystemMessageId.NO_RESPONSE_TO_ALLY_INVITATION);
        } else {
            if (!(requestor.getRequest().getRequestPacket() instanceof RequestJoinAlly)) {
                return;
            }
            L2Clan clan = requestor.getClan();
            if (clan.checkAllyJoinCondition(requestor, activeChar)) {
                requestor.sendPacket(SystemMessageId.YOU_INVITED_FOR_ALLIANCE);
                activeChar.sendPacket(SystemMessageId.YOU_ACCEPTED_ALLIANCE);
                activeChar.getClan().setAllyId(clan.getAllyId());
                activeChar.getClan().setAllyName(clan.getAllyName());
                activeChar.getClan().setAllyPenaltyExpiryTime(0L, 0);
                activeChar.getClan().changeAllyCrest(clan.getAllyCrestId(), true);
                activeChar.getClan().updateClanInDB();
                for (L2Clan c : ClanTable.getInstance().getClanAllies(clan.getAllyId())) {
                    if (c.getAllyId() != clan.getAllyId()) continue;
                    CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, c, 3));
                }
            }
        }
        activeChar.getRequest().onRequestResponse();
    }

    @Override
    public String getType() {
        return _C__8D_REQUESTANSWERJOINALLY;
    }
}

