/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2SquadTrainer;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.AcquireSkillType;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillInfo;

public final class RequestAcquireSkillInfo
extends L2GameClientPacket {
    private static final String _C__73_REQUESTACQUIRESKILLINFO = "[C] 73 RequestAcquireSkillInfo";
    private int _id;
    private int _level;
    private AcquireSkillType _skillType;

    @Override
    protected void readImpl() {
        this._id = this.readD();
        this._level = this.readD();
        this._skillType = AcquireSkillType.getAcquireSkillType(this.readD());
    }

    @Override
    protected void runImpl() {
        L2SkillLearn s;
        if (this._id <= 0 || this._level <= 0) {
            _log.warning(RequestAcquireSkillInfo.class.getSimpleName() + ": Invalid Id: " + this._id + " or level: " + this._level + "!");
            return;
        }
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Npc trainer = activeChar.getLastFolkNPC();
        if (!(trainer instanceof L2NpcInstance)) {
            return;
        }
        if (!trainer.canInteract(activeChar) && !activeChar.isGM()) {
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._id, this._level);
        if (skill == null) {
            _log.warning(RequestAcquireSkillInfo.class.getSimpleName() + ": Skill Id: " + this._id + " level: " + this._level + " is undefined. " + RequestAcquireSkillInfo.class.getName() + " failed.");
            return;
        }
        int prevSkillLevel = activeChar.getSkillLevel(this._id);
        if (prevSkillLevel > 0 && this._skillType != AcquireSkillType.TRANSFER && this._skillType != AcquireSkillType.SUBPLEDGE) {
            if (prevSkillLevel == this._level) {
                _log.warning(RequestAcquireSkillInfo.class.getSimpleName() + ": Player " + activeChar.getName() + " is trequesting info for a skill that already knows, Id: " + this._id + " level: " + this._level + "!");
            } else if (prevSkillLevel != this._level - 1) {
                _log.warning(RequestAcquireSkillInfo.class.getSimpleName() + ": Player " + activeChar.getName() + " is requesting info for skill Id: " + this._id + " level " + this._level + " without knowing it's previous level!");
            }
        }
        if ((s = SkillTreesData.getInstance().getSkillLearn(this._skillType, this._id, this._level, activeChar)) == null) {
            return;
        }
        switch (this._skillType) {
            case TRANSFORM: 
            case FISHING: 
            case SUBCLASS: 
            case COLLECT: 
            case TRANSFER: {
                this.sendPacket(new AcquireSkillInfo(this._skillType, s));
                break;
            }
            case CLASS: {
                if (!trainer.getTemplate().canTeach(activeChar.getLearningClass())) break;
                int customSp = s.getCalculatedLevelUpSp(activeChar.getClassId(), activeChar.getLearningClass());
                this.sendPacket(new AcquireSkillInfo(this._skillType, s, customSp));
                break;
            }
            case PLEDGE: {
                if (!activeChar.isClanLeader()) {
                    return;
                }
                this.sendPacket(new AcquireSkillInfo(this._skillType, s));
                break;
            }
            case SUBPLEDGE: {
                if (!activeChar.isClanLeader() || !(trainer instanceof L2SquadTrainer)) {
                    return;
                }
                this.sendPacket(new AcquireSkillInfo(this._skillType, s));
            }
        }
    }

    @Override
    public String getType() {
        return _C__73_REQUESTACQUIRESKILLINFO;
    }
}

