/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.TutorialShowHtml;
import java.util.Map;

public class Debug {
    public static void sendSkillDebug(L2Character attacker, L2Character target, L2Skill skill, StatsSet set) {
        if (!attacker.isPlayer()) {
            return;
        }
        StringBuilder sb = new StringBuilder(256);
        for (Map.Entry<String, Object> entry : set.getSet().entrySet()) {
            sb.append("<tr><td>").append(entry.getKey()).append("</td><td><font color=\"LEVEL\">").append(entry.getValue()).append("</font></td></tr>");
        }
        NpcHtmlMessage msg = new NpcHtmlMessage();
        msg.setFile(attacker.getActingPlayer().getHtmlPrefix(), "data/html/admin/skilldebug.htm");
        msg.replace((CharSequence)"%patk%", target.getPAtk(target));
        msg.replace((CharSequence)"%matk%", target.getMAtk(target, skill));
        msg.replace((CharSequence)"%pdef%", target.getPDef(target));
        msg.replace((CharSequence)"%mdef%", target.getMDef(target, skill));
        msg.replace((CharSequence)"%acc%", target.getAccuracy());
        msg.replace((CharSequence)"%evas%", target.getEvasionRate(target));
        msg.replace((CharSequence)"%crit%", target.getCriticalHit(target, skill));
        msg.replace((CharSequence)"%speed%", target.getRunSpeed());
        msg.replace((CharSequence)"%pAtkSpd%", target.getPAtkSpd());
        msg.replace((CharSequence)"%mAtkSpd%", target.getMAtkSpd());
        msg.replace((CharSequence)"%str%", target.getSTR());
        msg.replace((CharSequence)"%dex%", target.getDEX());
        msg.replace((CharSequence)"%con%", target.getCON());
        msg.replace((CharSequence)"%int%", target.getINT());
        msg.replace((CharSequence)"%wit%", target.getWIT());
        msg.replace((CharSequence)"%men%", target.getMEN());
        msg.replace((CharSequence)"%atkElemType%", Elementals.getElementName(target.getAttackElement()));
        msg.replace((CharSequence)"%atkElemVal%", target.getAttackElementValue(target.getAttackElement()));
        msg.replace((CharSequence)"%fireDef%", target.getDefenseElementValue((byte)0));
        msg.replace((CharSequence)"%waterDef%", target.getDefenseElementValue((byte)1));
        msg.replace((CharSequence)"%windDef%", target.getDefenseElementValue((byte)2));
        msg.replace((CharSequence)"%earthDef%", target.getDefenseElementValue((byte)3));
        msg.replace((CharSequence)"%holyDef%", target.getDefenseElementValue((byte)4));
        msg.replace((CharSequence)"%darkDef%", target.getDefenseElementValue((byte)5));
        msg.replace((CharSequence)"%skill%", skill.toString());
        msg.replace((CharSequence)"%details%", sb.toString());
        attacker.sendPacket(new TutorialShowHtml(msg.getHtml()));
    }

    public static void sendItemDebug(L2PcInstance player, L2ItemInstance item, StatsSet set) {
        StringBuilder sb = new StringBuilder(256);
        for (Map.Entry<String, Object> entry : set.getSet().entrySet()) {
            sb.append("<tr><td>").append(entry.getKey()).append("</td><td><font color=\"LEVEL\">").append(entry.getValue()).append("</font></td></tr>");
        }
        NpcHtmlMessage msg = new NpcHtmlMessage();
        msg.setFile(player.getHtmlPrefix(), "data/html/admin/itemdebug.htm");
        msg.replace((CharSequence)"%itemName%", item.getName());
        msg.replace((CharSequence)"%itemSlot%", Debug.getBodyPart(item.getItem().getBodyPart()));
        msg.replace((CharSequence)"%itemType%", item.isArmor() ? "Armor" : (item.isWeapon() ? "Weapon" : "Etc"));
        msg.replace((CharSequence)"%enchantLevel%", item.getEnchantLevel());
        msg.replace((CharSequence)"%isMagicWeapon%", item.getItem().isMagicWeapon());
        msg.replace((CharSequence)"%item%", item.toString());
        msg.replace((CharSequence)"%details%", sb.toString());
        player.sendPacket(new TutorialShowHtml(msg.getHtml()));
    }

    private static String getBodyPart(int bodyPart) {
        for (Map.Entry<String, Integer> entry : ItemTable._slots.entrySet()) {
            if ((entry.getValue() & bodyPart) != bodyPart) continue;
            return entry.getKey();
        }
        return "Unknown";
    }
}

