/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.zone.AbstractZoneSettings;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.TaskZoneSettings;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.serverpackets.EtcStatusUpdate;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.StringUtil;
import java.util.Map;
import javolution.util.FastMap;

public class L2EffectZone
extends L2ZoneType {
    private int _chance = 100;
    private int _initialDelay = 0;
    private int _reuse = 30000;
    protected boolean _bypassConditions;
    private boolean _isShowDangerIcon;
    protected FastMap<Integer, Integer> _skills;

    public L2EffectZone(int id) {
        super(id);
        this.setTargetType(InstanceType.L2Playable);
        this._bypassConditions = false;
        this._isShowDangerIcon = true;
        AbstractZoneSettings settings = ZoneManager.getSettings(this.getName());
        if (settings == null) {
            settings = new TaskZoneSettings();
        }
        this.setSettings(settings);
    }

    @Override
    public TaskZoneSettings getSettings() {
        return (TaskZoneSettings)super.getSettings();
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("chance")) {
            this._chance = Integer.parseInt(value);
        } else if (name.equals("initialDelay")) {
            this._initialDelay = Integer.parseInt(value);
        } else if (name.equals("reuse")) {
            this._reuse = Integer.parseInt(value);
        } else if (name.equals("bypassSkillConditions")) {
            this._bypassConditions = Boolean.parseBoolean(value);
        } else if (name.equals("maxDynamicSkillCount")) {
            this._skills = new FastMap(Integer.parseInt(value)).shared();
        } else if (name.equals("skillIdLvl")) {
            String[] propertySplit = value.split(";");
            this._skills = new FastMap(propertySplit.length);
            for (String skill : propertySplit) {
                String[] skillSplit = skill.split("-");
                if (skillSplit.length != 2) {
                    _log.warning(StringUtil.concat(this.getClass().getSimpleName() + ": invalid config property -> skillsIdLvl \"", skill, "\""));
                    continue;
                }
                try {
                    this._skills.put((Object)Integer.parseInt(skillSplit[0]), (Object)Integer.parseInt(skillSplit[1]));
                }
                catch (NumberFormatException nfe) {
                    if (skill.isEmpty()) continue;
                    _log.warning(StringUtil.concat(this.getClass().getSimpleName() + ": invalid config property -> skillsIdLvl \"", skillSplit[0], "\"", skillSplit[1]));
                }
            }
        } else if (name.equals("showDangerIcon")) {
            this._isShowDangerIcon = Boolean.parseBoolean(value);
        } else {
            super.setParameter(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEnter(L2Character character) {
        if (this._skills != null && this.getSettings().getTask() == null) {
            L2EffectZone l2EffectZone = this;
            synchronized (l2EffectZone) {
                if (this.getSettings().getTask() == null) {
                    this.getSettings().setTask(ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new ApplySkill(), this._initialDelay, this._reuse));
                }
            }
        }
        if (character.isPlayer()) {
            character.setInsideZone(ZoneId.ALTERED, true);
            if (this._isShowDangerIcon) {
                character.setInsideZone(ZoneId.DANGER_AREA, true);
                character.sendPacket(new EtcStatusUpdate(character.getActingPlayer()));
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character.isPlayer()) {
            character.setInsideZone(ZoneId.ALTERED, false);
            if (this._isShowDangerIcon) {
                character.setInsideZone(ZoneId.DANGER_AREA, false);
                if (!character.isInsideZone(ZoneId.DANGER_AREA)) {
                    character.sendPacket(new EtcStatusUpdate(character.getActingPlayer()));
                }
            }
        }
        if (this._characterList.isEmpty() && this.getSettings().getTask() != null) {
            this.getSettings().clear();
        }
    }

    protected L2Skill getSkill(int skillId, int skillLvl) {
        return SkillTable.getInstance().getInfo(skillId, skillLvl);
    }

    public int getChance() {
        return this._chance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSkill(int skillId, int skillLvL) {
        if (skillLvL < 1) {
            this.removeSkill(skillId);
            return;
        }
        if (this._skills == null) {
            L2EffectZone l2EffectZone = this;
            synchronized (l2EffectZone) {
                if (this._skills == null) {
                    this._skills = new FastMap(3).shared();
                }
            }
        }
        this._skills.put((Object)skillId, (Object)skillLvL);
    }

    public void removeSkill(int skillId) {
        if (this._skills != null) {
            this._skills.remove((Object)skillId);
        }
    }

    public void clearSkills() {
        if (this._skills != null) {
            this._skills.clear();
        }
    }

    public int getSkillLevel(int skillId) {
        if (this._skills == null || !this._skills.containsKey((Object)skillId)) {
            return 0;
        }
        return (Integer)this._skills.get((Object)skillId);
    }

    private final class ApplySkill
    implements Runnable {
        protected ApplySkill() {
            if (L2EffectZone.this._skills == null) {
                throw new IllegalStateException("No skills defined.");
            }
        }

        @Override
        public void run() {
            if (L2EffectZone.this.isEnabled()) {
                for (L2Character temp : L2EffectZone.this.getCharactersInside()) {
                    if (temp == null || temp.isDead() || Rnd.get(100) >= L2EffectZone.this.getChance()) continue;
                    for (Map.Entry e : L2EffectZone.this._skills.entrySet()) {
                        L2Skill skill = L2EffectZone.this.getSkill((Integer)e.getKey(), (Integer)e.getValue());
                        if (skill == null || !L2EffectZone.this._bypassConditions && !skill.checkCondition(temp, temp, false) || temp.isAffectedBySkill((Integer)e.getKey())) continue;
                        skill.applyEffects(temp, temp);
                    }
                }
            }
        }
    }
}

