/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.ZoneId;

public class L2ConditionZone
extends L2ZoneType {
    private boolean NO_ITEM_DROP = false;
    private boolean NO_BOOKMARK = false;

    public L2ConditionZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equalsIgnoreCase("NoBookmark")) {
            this.NO_BOOKMARK = Boolean.parseBoolean(value);
        } else if (name.equalsIgnoreCase("NoItemDrop")) {
            this.NO_ITEM_DROP = Boolean.parseBoolean(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character.isPlayer()) {
            if (this.NO_BOOKMARK) {
                character.setInsideZone(ZoneId.NO_BOOKMARK, true);
            }
            if (this.NO_ITEM_DROP) {
                character.setInsideZone(ZoneId.NO_ITEM_DROP, true);
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character.isPlayer()) {
            if (this.NO_BOOKMARK) {
                character.setInsideZone(ZoneId.NO_BOOKMARK, false);
            }
            if (this.NO_ITEM_DROP) {
                character.setInsideZone(ZoneId.NO_ITEM_DROP, false);
            }
        }
    }
}

