/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.effects.EffectTaskInfo;
import com.l2jserver.gameserver.model.effects.EffectTickTask;
import com.l2jserver.gameserver.model.skills.BuffTimeTask;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;

public final class BuffInfo {
    private final Env _env;
    private final List<AbstractEffect> _effects = new ArrayList<AbstractEffect>(1);
    private Map<AbstractEffect, EffectTaskInfo> _tasks;
    private BuffTimeTask _effectTimeTask;
    private ScheduledFuture<?> _scheduledFutureTimeTask;
    private int _abnormalTime;
    private final int _periodStartTicks;
    private boolean _isRemoved = false;
    private boolean _isInUse = true;

    public BuffInfo(Env env) {
        this._env = env;
        this._abnormalTime = Formulas.calcEffectAbnormalTime(env);
        this._periodStartTicks = GameTimeController.getInstance().getGameTicks();
    }

    public List<AbstractEffect> getEffects() {
        return this._effects;
    }

    public void addEffect(AbstractEffect effect) {
        this._effects.add(effect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(AbstractEffect effect, EffectTaskInfo effectTaskInfo) {
        if (this._tasks == null) {
            BuffInfo buffInfo = this;
            synchronized (buffInfo) {
                if (this._tasks == null) {
                    this._tasks = new ConcurrentHashMap<AbstractEffect, EffectTaskInfo>();
                }
            }
        }
        this._tasks.put(effect, effectTaskInfo);
    }

    private EffectTaskInfo getEffectTask(AbstractEffect effect) {
        return this._tasks == null ? null : this._tasks.get(effect);
    }

    public L2Skill getSkill() {
        return this._env.getSkill();
    }

    public Env getEnv() {
        return this._env;
    }

    public int getAbnormalTime() {
        return this._abnormalTime;
    }

    public void setAbnormalTime(int abnormalTime) {
        this._abnormalTime = abnormalTime;
    }

    public int getPeriodStartTicks() {
        return this._periodStartTicks;
    }

    public int getTime() {
        return this._abnormalTime - (GameTimeController.getInstance().getGameTicks() - this._periodStartTicks) / 10;
    }

    public boolean isRemoved() {
        return this._isRemoved;
    }

    public void setRemoved(boolean val) {
        this._isRemoved = val;
    }

    public boolean isInUse() {
        return this._isInUse;
    }

    public void setInUse(boolean val) {
        this._isInUse = val;
    }

    public L2Character getEffector() {
        return this._env.getCharacter();
    }

    public L2Character getEffected() {
        return this._env.getTarget();
    }

    public void stopAllEffects(boolean removed) {
        this.setRemoved(removed);
        if (this._scheduledFutureTimeTask != null && !this._scheduledFutureTimeTask.isCancelled()) {
            this._scheduledFutureTimeTask.cancel(false);
        }
        this.removeStats();
        this.finishEffects();
    }

    public void initializeEffects() {
        if (this._env.getTarget().isPlayer() && !this._env.getSkill().isPassive()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT);
            sm.addSkillName(this._env.getSkill());
            this._env.getTarget().sendPacket(sm);
        }
        if (this._abnormalTime > 0) {
            this._effectTimeTask = new BuffTimeTask(this);
            this._scheduledFutureTimeTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(this._effectTimeTask, 0L, 1000L);
        }
        this.applyAbnormalVisualEffects();
        for (AbstractEffect effect : this._effects) {
            if (effect.isInstant()) continue;
            effect.onStart(this);
            if (effect.getTicks() > 0) {
                EffectTickTask effectTask = new EffectTickTask(this, effect);
                ScheduledFuture<?> scheduledFuture = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(effectTask, (long)effect.getTicks() * Config.EFFECT_TICK_RATIO, (long)effect.getTicks() * Config.EFFECT_TICK_RATIO);
                this.addTask(effect, new EffectTaskInfo(effectTask, scheduledFuture));
            }
            this._env.getTarget().addStatFuncs(effect.getStatFuncs(this._env));
        }
    }

    public void onTick(AbstractEffect effect, int tickCount) {
        EffectTaskInfo task;
        boolean continueForever = false;
        if (this._isInUse) {
            continueForever = effect.onActionTime(this);
        }
        if (!continueForever && this._env.getSkill().isToggle() && (task = this.getEffectTask(effect)) != null) {
            task.getScheduledFuture().cancel(true);
            this._env.getTarget().getEffectList().remove(true, this);
        }
    }

    public void finishEffects() {
        this.removeAbnormalVisualEffects();
        for (AbstractEffect abstractEffect : this._effects) {
            if (abstractEffect == null || abstractEffect.isInstant()) continue;
            abstractEffect.onExit(this);
        }
        if (this._tasks != null) {
            for (Map.Entry entry : this._tasks.entrySet()) {
                ((EffectTaskInfo)entry.getValue()).getScheduledFuture().cancel(true);
            }
        }
        SystemMessageId smId = null;
        if (this._env.getSkill().isToggle()) {
            smId = SystemMessageId.S1_HAS_BEEN_ABORTED;
        } else if (this.isRemoved()) {
            smId = SystemMessageId.EFFECT_S1_HAS_BEEN_REMOVED;
        } else if (!this._env.getSkill().isPassive()) {
            smId = SystemMessageId.S1_HAS_WORN_OFF;
        }
        if (smId != null) {
            SystemMessage systemMessage = SystemMessage.getSystemMessage(smId);
            systemMessage.addSkillName(this._env.getSkill());
            this._env.getTarget().sendPacket(systemMessage);
        }
        if (this == this._env.getTarget().getEffectList().getShortBuff()) {
            this._env.getTarget().getEffectList().shortBuffStatusUpdate(null);
        }
    }

    private void applyAbnormalVisualEffects() {
        if (this._env.getTarget() == null || this._env.getSkill() == null) {
            return;
        }
        if (this._env.getSkill().hasAbnormalVisualEffects()) {
            this._env.getTarget().startAbnormalVisualEffect(false, this._env.getSkill().getAbnormalVisualEffects());
        }
        if (this._env.getTarget().isPlayer() && this._env.getSkill().hasAbnormalVisualEffectsEvent()) {
            this._env.getTarget().startAbnormalVisualEffect(false, this._env.getSkill().getAbnormalVisualEffectsEvent());
        }
        if (this._env.getSkill().hasAbnormalVisualEffectsSpecial()) {
            this._env.getTarget().startAbnormalVisualEffect(false, this._env.getSkill().getAbnormalVisualEffectsSpecial());
        }
        this._env.getTarget().updateAbnormalEffect();
    }

    private void removeAbnormalVisualEffects() {
        if (this._env.getTarget() == null || this._env.getSkill() == null) {
            return;
        }
        if (this._env.getSkill().hasAbnormalVisualEffects()) {
            this._env.getTarget().stopAbnormalVisualEffect(false, this._env.getSkill().getAbnormalVisualEffects());
        }
        if (this._env.getTarget().isPlayer() && this._env.getSkill().hasAbnormalVisualEffectsEvent()) {
            this._env.getTarget().stopAbnormalVisualEffect(false, this._env.getSkill().getAbnormalVisualEffectsEvent());
        }
        if (this._env.getSkill().hasAbnormalVisualEffectsSpecial()) {
            this._env.getTarget().stopAbnormalVisualEffect(false, this._env.getSkill().getAbnormalVisualEffectsSpecial());
        }
        this._env.getTarget().updateAbnormalEffect();
    }

    public void addStats() {
        for (AbstractEffect effect : this._effects) {
            this._env.getTarget().addStatFuncs(effect.getStatFuncs(this._env));
        }
    }

    public void removeStats() {
        for (AbstractEffect effect : this._effects) {
            this._env.getTarget().removeStatsOwner(effect);
        }
        this._env.getTarget().removeStatsOwner(this._env.getSkill());
    }

    public int getTickCount(AbstractEffect effect) {
        EffectTaskInfo effectTaskInfo;
        if (this._tasks != null && (effectTaskInfo = this._tasks.get(effect)) != null) {
            return effectTaskInfo.getEffectTask().getTickCount();
        }
        return 0;
    }
}

