/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.model.olympiad.OlympiadAnnouncer;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Util;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class Olympiad {
    protected static final Logger _log = Logger.getLogger(Olympiad.class.getName());
    protected static final Logger _logResults = Logger.getLogger("olympiad");
    private static final Map<Integer, StatsSet> _nobles = new FastMap();
    protected static FastList<StatsSet> _heroesToBe;
    private static final TIntIntHashMap _noblesRank;
    public static final String OLYMPIAD_HTML_PATH = "data/html/olympiad/";
    private static final String OLYMPIAD_LOAD_DATA = "SELECT current_cycle, period, olympiad_end, validation_end, next_weekly_change FROM olympiad_data WHERE id = 0";
    private static final String OLYMPIAD_SAVE_DATA = "INSERT INTO olympiad_data (id, current_cycle, period, olympiad_end, validation_end, next_weekly_change) VALUES (0,?,?,?,?,?) ON DUPLICATE KEY UPDATE current_cycle=?, period=?, olympiad_end=?, validation_end=?, next_weekly_change=?";
    private static final String OLYMPIAD_LOAD_NOBLES = "SELECT olympiad_nobles.charId, olympiad_nobles.class_id, characters.char_name, olympiad_nobles.olympiad_points, olympiad_nobles.competitions_done, olympiad_nobles.competitions_won, olympiad_nobles.competitions_lost, olympiad_nobles.competitions_drawn, olympiad_nobles.competitions_done_week, olympiad_nobles.competitions_done_week_classed, olympiad_nobles.competitions_done_week_non_classed, olympiad_nobles.competitions_done_week_team FROM olympiad_nobles, characters WHERE characters.charId = olympiad_nobles.charId";
    private static final String OLYMPIAD_SAVE_NOBLES = "INSERT INTO olympiad_nobles (`charId`,`class_id`,`olympiad_points`,`competitions_done`,`competitions_won`,`competitions_lost`,`competitions_drawn`, `competitions_done_week`, `competitions_done_week_classed`, `competitions_done_week_non_classed`, `competitions_done_week_team`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
    private static final String OLYMPIAD_UPDATE_NOBLES = "UPDATE olympiad_nobles SET olympiad_points = ?, competitions_done = ?, competitions_won = ?, competitions_lost = ?, competitions_drawn = ?, competitions_done_week = ?, competitions_done_week_classed = ?, competitions_done_week_non_classed = ?, competitions_done_week_team = ? WHERE charId = ?";
    private static final String OLYMPIAD_GET_HEROS;
    private static final String GET_ALL_CLASSIFIED_NOBLESS;
    private static final String GET_EACH_CLASS_LEADER;
    private static final String GET_EACH_CLASS_LEADER_CURRENT;
    private static final String GET_EACH_CLASS_LEADER_SOULHOUND;
    private static final String GET_EACH_CLASS_LEADER_CURRENT_SOULHOUND;
    private static final String OLYMPIAD_DELETE_ALL = "TRUNCATE olympiad_nobles";
    private static final String OLYMPIAD_MONTH_CLEAR = "TRUNCATE olympiad_nobles_eom";
    private static final String OLYMPIAD_MONTH_CREATE = "INSERT INTO olympiad_nobles_eom SELECT charId, class_id, olympiad_points, competitions_done, competitions_won, competitions_lost, competitions_drawn FROM olympiad_nobles";
    private static final int[] HERO_IDS;
    private static final int COMP_START;
    private static final int COMP_MIN;
    private static final long COMP_PERIOD;
    protected static final long WEEKLY_PERIOD;
    protected static final long VALIDATION_PERIOD;
    protected static final int DEFAULT_POINTS;
    protected static final int WEEKLY_POINTS;
    public static final String CHAR_ID = "charId";
    public static final String CLASS_ID = "class_id";
    public static final String CHAR_NAME = "char_name";
    public static final String POINTS = "olympiad_points";
    public static final String COMP_DONE = "competitions_done";
    public static final String COMP_WON = "competitions_won";
    public static final String COMP_LOST = "competitions_lost";
    public static final String COMP_DRAWN = "competitions_drawn";
    public static final String COMP_DONE_WEEK = "competitions_done_week";
    public static final String COMP_DONE_WEEK_CLASSED = "competitions_done_week_classed";
    public static final String COMP_DONE_WEEK_NON_CLASSED = "competitions_done_week_non_classed";
    public static final String COMP_DONE_WEEK_TEAM = "competitions_done_week_team";
    protected long _olympiadEnd;
    protected long _validationEnd;
    protected int _period;
    protected long _nextWeeklyChange;
    protected int _currentCycle;
    private long _compEnd;
    private Calendar _compStart;
    protected static boolean _inCompPeriod;
    protected static boolean _compStarted;
    protected ScheduledFuture<?> _scheduledCompStart;
    protected ScheduledFuture<?> _scheduledCompEnd;
    protected ScheduledFuture<?> _scheduledOlympiadEnd;
    protected ScheduledFuture<?> _scheduledWeeklyTask;
    protected ScheduledFuture<?> _scheduledValdationTask;
    protected ScheduledFuture<?> _gameManager = null;
    protected ScheduledFuture<?> _gameAnnouncer = null;

    protected Olympiad() {
        this.load();
        AntiFeedManager.getInstance().registerEvent(1);
        if (this._period == 0) {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Throwable throwable;
        ResultSet rset;
        Throwable throwable2;
        PreparedStatement statement;
        Connection con;
        _nobles.clear();
        boolean loaded = false;
        try {
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            Throwable throwable3 = null;
            try {
                statement = con.prepareStatement(OLYMPIAD_LOAD_DATA);
                throwable2 = null;
                try {
                    rset = statement.executeQuery();
                    throwable = null;
                    try {
                        while (rset.next()) {
                            this._currentCycle = rset.getInt("current_cycle");
                            this._period = rset.getInt("period");
                            this._olympiadEnd = rset.getLong("olympiad_end");
                            this._validationEnd = rset.getLong("validation_end");
                            this._nextWeeklyChange = rset.getLong("next_weekly_change");
                            loaded = true;
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (rset != null) {
                            if (throwable != null) {
                                try {
                                    rset.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                rset.close();
                            }
                        }
                    }
                }
                catch (Throwable x2) {
                    throwable2 = x2;
                    throw x2;
                }
                finally {
                    if (statement != null) {
                        if (throwable2 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (Throwable x2) {
                throwable3 = x2;
                throw x2;
            }
            finally {
                if (con != null) {
                    if (throwable3 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable x2) {
                            throwable3.addSuppressed(x2);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Olympiad System: Error loading olympiad data from database: ", e);
        }
        if (!loaded) {
            _log.log(Level.INFO, "Olympiad System: failed to load data from database, trying to load from file.");
            Properties OlympiadProperties = new Properties();
            try (FileInputStream is = new FileInputStream("./config/Olympiad.properties");){
                OlympiadProperties.load(is);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Olympiad System: Error loading olympiad properties: ", e);
                return;
            }
            this._currentCycle = Integer.parseInt(OlympiadProperties.getProperty("CurrentCycle", "1"));
            this._period = Integer.parseInt(OlympiadProperties.getProperty("Period", "0"));
            this._olympiadEnd = Long.parseLong(OlympiadProperties.getProperty("OlympiadEnd", "0"));
            this._validationEnd = Long.parseLong(OlympiadProperties.getProperty("ValidationEnd", "0"));
            this._nextWeeklyChange = Long.parseLong(OlympiadProperties.getProperty("NextWeeklyChange", "0"));
        }
        switch (this._period) {
            case 0: {
                if (this._olympiadEnd == 0L || this._olympiadEnd < System.currentTimeMillis()) {
                    this.setNewOlympiadEnd();
                    break;
                }
                this.scheduleWeeklyChange();
                break;
            }
            case 1: {
                if (this._validationEnd > System.currentTimeMillis()) {
                    this.loadNoblesRank();
                    this._scheduledValdationTask = ThreadPoolManager.getInstance().scheduleGeneral(new ValidationEndTask(), this.getMillisToValidationEnd());
                    break;
                }
                ++this._currentCycle;
                this._period = 0;
                this.deleteNobles();
                this.setNewOlympiadEnd();
                break;
            }
            default: {
                _log.warning("Olympiad System: Omg something went wrong in loading!! Period = " + this._period);
                return;
            }
        }
        try {
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            Throwable e = null;
            try {
                statement = con.prepareStatement(OLYMPIAD_LOAD_NOBLES);
                throwable2 = null;
                try {
                    rset = statement.executeQuery();
                    throwable = null;
                    try {
                        while (rset.next()) {
                            StatsSet statData = new StatsSet();
                            statData.set(CLASS_ID, rset.getInt(CLASS_ID));
                            statData.set(CHAR_NAME, rset.getString(CHAR_NAME));
                            statData.set(POINTS, rset.getInt(POINTS));
                            statData.set(COMP_DONE, rset.getInt(COMP_DONE));
                            statData.set(COMP_WON, rset.getInt(COMP_WON));
                            statData.set(COMP_LOST, rset.getInt(COMP_LOST));
                            statData.set(COMP_DRAWN, rset.getInt(COMP_DRAWN));
                            statData.set(COMP_DONE_WEEK, rset.getInt(COMP_DONE_WEEK));
                            statData.set(COMP_DONE_WEEK_CLASSED, rset.getInt(COMP_DONE_WEEK_CLASSED));
                            statData.set(COMP_DONE_WEEK_NON_CLASSED, rset.getInt(COMP_DONE_WEEK_NON_CLASSED));
                            statData.set(COMP_DONE_WEEK_TEAM, rset.getInt(COMP_DONE_WEEK_TEAM));
                            statData.set("to_save", false);
                            Olympiad.addNobleStats(rset.getInt(CHAR_ID), statData);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rset != null) {
                            if (throwable != null) {
                                try {
                                    rset.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                rset.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (statement != null) {
                        if (throwable2 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                e = throwable6;
                throw throwable6;
            }
            finally {
                if (con != null) {
                    if (e != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable x2) {
                            e.addSuppressed(x2);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Olympiad System: Error loading noblesse data from database: ", e);
        }
        Olympiad olympiad = this;
        synchronized (olympiad) {
            _log.info("Olympiad System: Loading Olympiad System....");
            if (this._period == 0) {
                _log.info("Olympiad System: Currently in Olympiad Period");
            } else {
                _log.info("Olympiad System: Currently in Validation Period");
            }
            long milliToEnd = this._period == 0 ? this.getMillisToOlympiadEnd() : this.getMillisToValidationEnd();
            _log.info("Olympiad System: " + milliToEnd / 60000L + " minutes until period ends");
            if (this._period == 0) {
                milliToEnd = this.getMillisToWeekChange();
                _log.info("Olympiad System: Next weekly change is in " + milliToEnd / 60000L + " minutes");
            }
        }
        _log.info("Olympiad System: Loaded " + _nobles.size() + " Nobles");
    }

    public void loadNoblesRank() {
        _noblesRank.clear();
        TIntIntHashMap tmpPlace = new TIntIntHashMap();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(GET_ALL_CLASSIFIED_NOBLESS);
             ResultSet rset = statement.executeQuery();){
            int place = 1;
            while (rset.next()) {
                tmpPlace.put(rset.getInt(CHAR_ID), place++);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Olympiad System: Error loading noblesse data from database for Ranking: ", e);
        }
        int rank1 = (int)Math.round((double)tmpPlace.size() * 0.01);
        int rank2 = (int)Math.round((double)tmpPlace.size() * 0.1);
        int rank3 = (int)Math.round((double)tmpPlace.size() * 0.25);
        int rank4 = (int)Math.round((double)tmpPlace.size() * 0.5);
        if (rank1 == 0) {
            rank1 = 1;
            ++rank2;
            ++rank3;
            ++rank4;
        }
        for (int charId : tmpPlace.keys()) {
            if (tmpPlace.get(charId) <= rank1) {
                _noblesRank.put(charId, 1);
                continue;
            }
            if (tmpPlace.get(charId) <= rank2) {
                _noblesRank.put(charId, 2);
                continue;
            }
            if (tmpPlace.get(charId) <= rank3) {
                _noblesRank.put(charId, 3);
                continue;
            }
            if (tmpPlace.get(charId) <= rank4) {
                _noblesRank.put(charId, 4);
                continue;
            }
            _noblesRank.put(charId, 5);
        }
    }

    protected void init() {
        if (this._period == 1) {
            return;
        }
        this._compStart = Calendar.getInstance();
        this._compStart.set(11, COMP_START);
        this._compStart.set(12, COMP_MIN);
        this._compEnd = this._compStart.getTimeInMillis() + COMP_PERIOD;
        if (this._scheduledOlympiadEnd != null) {
            this._scheduledOlympiadEnd.cancel(true);
        }
        this._scheduledOlympiadEnd = ThreadPoolManager.getInstance().scheduleGeneral(new OlympiadEndTask(), this.getMillisToOlympiadEnd());
        this.updateCompStatus();
    }

    protected static int getNobleCount() {
        return _nobles.size();
    }

    protected static StatsSet getNobleStats(int playerId) {
        return _nobles.get(playerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompStatus() {
        Olympiad olympiad = this;
        synchronized (olympiad) {
            long milliToStart = this.getMillisToCompBegin();
            double numSecs = milliToStart / 1000L % 60L;
            double countDown = ((double)milliToStart / 1000.0 - numSecs) / 60.0;
            int numMins = (int)Math.floor(countDown % 60.0);
            countDown = (countDown - (double)numMins) / 60.0;
            int numHours = (int)Math.floor(countDown % 24.0);
            int numDays = (int)Math.floor((countDown - (double)numHours) / 24.0);
            _log.info("Olympiad System: Competition Period Starts in " + numDays + " days, " + numHours + " hours and " + numMins + " mins.");
            _log.info("Olympiad System: Event starts/started : " + Util.dateFormat(this._compStart));
        }
        this._scheduledCompStart = ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                long regEnd;
                if (Olympiad.this.isOlympiadEnd()) {
                    return;
                }
                _inCompPeriod = true;
                Announcements.getInstance().announceToAll(SystemMessage.getSystemMessage(SystemMessageId.THE_OLYMPIAD_GAME_HAS_STARTED));
                _log.info("Olympiad System: Olympiad Game Started");
                _logResults.info("Result,Player1,Player2,Player1 HP,Player2 HP,Player1 Damage,Player2 Damage,Points,Classed");
                Olympiad.this._gameManager = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(OlympiadGameManager.getInstance(), 30000L, 30000L);
                if (Config.ALT_OLY_ANNOUNCE_GAMES) {
                    Olympiad.this._gameAnnouncer = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new OlympiadAnnouncer(), 30000L, 500L);
                }
                if ((regEnd = Olympiad.this.getMillisToCompEnd() - 600000L) > 0L) {
                    ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                        @Override
                        public void run() {
                            Announcements.getInstance().announceToAll(SystemMessage.getSystemMessage(SystemMessageId.OLYMPIAD_REGISTRATION_PERIOD_ENDED));
                        }
                    }, regEnd);
                }
                Olympiad.this._scheduledCompEnd = ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                    @Override
                    public void run() {
                        if (Olympiad.this.isOlympiadEnd()) {
                            return;
                        }
                        _inCompPeriod = false;
                        Announcements.getInstance().announceToAll(SystemMessage.getSystemMessage(SystemMessageId.THE_OLYMPIAD_GAME_HAS_ENDED));
                        _log.info("Olympiad System: Olympiad Game Ended");
                        while (OlympiadGameManager.getInstance().isBattleStarted()) {
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (Olympiad.this._gameManager != null) {
                            Olympiad.this._gameManager.cancel(false);
                            Olympiad.this._gameManager = null;
                        }
                        if (Olympiad.this._gameAnnouncer != null) {
                            Olympiad.this._gameAnnouncer.cancel(false);
                            Olympiad.this._gameAnnouncer = null;
                        }
                        Olympiad.this.saveOlympiadStatus();
                        Olympiad.this.init();
                    }
                }, Olympiad.this.getMillisToCompEnd());
            }
        }, this.getMillisToCompBegin());
    }

    private long getMillisToOlympiadEnd() {
        return this._olympiadEnd - System.currentTimeMillis();
    }

    public void manualSelectHeroes() {
        if (this._scheduledOlympiadEnd != null) {
            this._scheduledOlympiadEnd.cancel(true);
        }
        this._scheduledOlympiadEnd = ThreadPoolManager.getInstance().scheduleGeneral(new OlympiadEndTask(), 0L);
    }

    protected long getMillisToValidationEnd() {
        if (this._validationEnd > System.currentTimeMillis()) {
            return this._validationEnd - System.currentTimeMillis();
        }
        return 10L;
    }

    public boolean isOlympiadEnd() {
        return this._period != 0;
    }

    protected void setNewOlympiadEnd() {
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.OLYMPIAD_PERIOD_S1_HAS_STARTED);
        sm.addNumber(this._currentCycle);
        Announcements.getInstance().announceToAll(sm);
        Calendar currentTime = Calendar.getInstance();
        currentTime.add(2, 1);
        currentTime.set(5, 1);
        currentTime.set(9, 0);
        currentTime.set(10, 12);
        currentTime.set(12, 0);
        currentTime.set(13, 0);
        this._olympiadEnd = currentTime.getTimeInMillis();
        Calendar nextChange = Calendar.getInstance();
        this._nextWeeklyChange = nextChange.getTimeInMillis() + WEEKLY_PERIOD;
        this.scheduleWeeklyChange();
    }

    public boolean inCompPeriod() {
        return _inCompPeriod;
    }

    private long getMillisToCompBegin() {
        if (this._compStart.getTimeInMillis() < System.currentTimeMillis() && this._compEnd > System.currentTimeMillis()) {
            return 10L;
        }
        if (this._compStart.getTimeInMillis() > System.currentTimeMillis()) {
            return this._compStart.getTimeInMillis() - System.currentTimeMillis();
        }
        return this.setNewCompBegin();
    }

    private long setNewCompBegin() {
        this._compStart = Calendar.getInstance();
        this._compStart.set(11, COMP_START);
        this._compStart.set(12, COMP_MIN);
        this._compStart.add(11, 24);
        this._compEnd = this._compStart.getTimeInMillis() + COMP_PERIOD;
        _log.info("Olympiad System: New Schedule @ " + this._compStart.getTime());
        return this._compStart.getTimeInMillis() - System.currentTimeMillis();
    }

    protected long getMillisToCompEnd() {
        return this._compEnd - System.currentTimeMillis();
    }

    private long getMillisToWeekChange() {
        if (this._nextWeeklyChange > System.currentTimeMillis()) {
            return this._nextWeeklyChange - System.currentTimeMillis();
        }
        return 10L;
    }

    private void scheduleWeeklyChange() {
        this._scheduledWeeklyTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Olympiad.this.addWeeklyPoints();
                _log.info("Olympiad System: Added weekly points to nobles");
                Olympiad.this.resetWeeklyMatches();
                _log.info("Olympiad System: Reset weekly matches to nobles");
                Calendar nextChange = Calendar.getInstance();
                Olympiad.this._nextWeeklyChange = nextChange.getTimeInMillis() + WEEKLY_PERIOD;
            }
        }, this.getMillisToWeekChange(), WEEKLY_PERIOD);
    }

    protected synchronized void addWeeklyPoints() {
        if (this._period == 1) {
            return;
        }
        for (StatsSet nobleInfo : _nobles.values()) {
            int currentPoints = nobleInfo.getInt(POINTS);
            nobleInfo.set(POINTS, currentPoints += WEEKLY_POINTS);
        }
    }

    protected synchronized void resetWeeklyMatches() {
        if (this._period == 1) {
            return;
        }
        for (StatsSet nobleInfo : _nobles.values()) {
            nobleInfo.set(COMP_DONE_WEEK, 0);
            nobleInfo.set(COMP_DONE_WEEK_CLASSED, 0);
            nobleInfo.set(COMP_DONE_WEEK_NON_CLASSED, 0);
            nobleInfo.set(COMP_DONE_WEEK_TEAM, 0);
        }
    }

    public int getCurrentCycle() {
        return this._currentCycle;
    }

    public boolean playerInStadia(L2PcInstance player) {
        return ZoneManager.getInstance().getOlympiadStadium(player) != null;
    }

    protected synchronized void saveNobleData() {
        if (_nobles == null || _nobles.isEmpty()) {
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            for (Map.Entry<Integer, StatsSet> entry : _nobles.entrySet()) {
                StatsSet nobleInfo = entry.getValue();
                if (nobleInfo == null) continue;
                int charId = entry.getKey();
                int classId = nobleInfo.getInt(CLASS_ID);
                int points = nobleInfo.getInt(POINTS);
                int compDone = nobleInfo.getInt(COMP_DONE);
                int compWon = nobleInfo.getInt(COMP_WON);
                int compLost = nobleInfo.getInt(COMP_LOST);
                int compDrawn = nobleInfo.getInt(COMP_DRAWN);
                int compDoneWeek = nobleInfo.getInt(COMP_DONE_WEEK);
                int compDoneWeekClassed = nobleInfo.getInt(COMP_DONE_WEEK_CLASSED);
                int compDoneWeekNonClassed = nobleInfo.getInt(COMP_DONE_WEEK_NON_CLASSED);
                int compDoneWeekTeam = nobleInfo.getInt(COMP_DONE_WEEK_TEAM);
                boolean toSave = nobleInfo.getBoolean("to_save");
                PreparedStatement statement = con.prepareStatement(toSave ? OLYMPIAD_SAVE_NOBLES : OLYMPIAD_UPDATE_NOBLES);
                Throwable throwable = null;
                try {
                    if (toSave) {
                        statement.setInt(1, charId);
                        statement.setInt(2, classId);
                        statement.setInt(3, points);
                        statement.setInt(4, compDone);
                        statement.setInt(5, compWon);
                        statement.setInt(6, compLost);
                        statement.setInt(7, compDrawn);
                        statement.setInt(8, compDoneWeek);
                        statement.setInt(9, compDoneWeekClassed);
                        statement.setInt(10, compDoneWeekNonClassed);
                        statement.setInt(11, compDoneWeekTeam);
                        nobleInfo.set("to_save", false);
                    } else {
                        statement.setInt(1, points);
                        statement.setInt(2, compDone);
                        statement.setInt(3, compWon);
                        statement.setInt(4, compLost);
                        statement.setInt(5, compDrawn);
                        statement.setInt(6, compDoneWeek);
                        statement.setInt(7, compDoneWeekClassed);
                        statement.setInt(8, compDoneWeekNonClassed);
                        statement.setInt(9, compDoneWeekTeam);
                        statement.setInt(10, charId);
                    }
                    statement.execute();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "Olympiad System: Failed to save noblesse data to database: ", e);
        }
    }

    public void saveOlympiadStatus() {
        this.saveNobleData();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(OLYMPIAD_SAVE_DATA);){
            statement.setInt(1, this._currentCycle);
            statement.setInt(2, this._period);
            statement.setLong(3, this._olympiadEnd);
            statement.setLong(4, this._validationEnd);
            statement.setLong(5, this._nextWeeklyChange);
            statement.setInt(6, this._currentCycle);
            statement.setInt(7, this._period);
            statement.setLong(8, this._olympiadEnd);
            statement.setLong(9, this._validationEnd);
            statement.setLong(10, this._nextWeeklyChange);
            statement.execute();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "Olympiad System: Failed to save olympiad data to database: ", e);
        }
    }

    protected void updateMonthlyData() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps1 = con.prepareStatement(OLYMPIAD_MONTH_CLEAR);
             PreparedStatement ps2 = con.prepareStatement(OLYMPIAD_MONTH_CREATE);){
            ps1.execute();
            ps2.execute();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "Olympiad System: Failed to update monthly noblese data: ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sortHerosToBe() {
        LogRecord record;
        if (this._period != 1) {
            return;
        }
        if (_nobles != null) {
            _logResults.info("Noble,charid,classid,compDone,points");
            for (Map.Entry<Integer, StatsSet> entry : _nobles.entrySet()) {
                StatsSet nobleInfo = entry.getValue();
                if (nobleInfo == null) continue;
                int charId = entry.getKey();
                int classId = nobleInfo.getInt(CLASS_ID);
                String charName = nobleInfo.getString(CHAR_NAME);
                int points = nobleInfo.getInt(POINTS);
                int compDone = nobleInfo.getInt(COMP_DONE);
                record = new LogRecord(Level.INFO, charName);
                record.setParameters(new Object[]{charId, classId, compDone, points});
                _logResults.log(record);
            }
        }
        _heroesToBe = new FastList();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(OLYMPIAD_GET_HEROS);){
            StatsSet hero;
            FastList soulHounds = new FastList();
            for (int element : HERO_IDS) {
                statement.setInt(1, element);
                ResultSet rset = statement.executeQuery();
                statement.clearParameters();
                if (rset.next()) {
                    hero = new StatsSet();
                    hero.set(CLASS_ID, element);
                    hero.set(CHAR_ID, rset.getInt(CHAR_ID));
                    hero.set(CHAR_NAME, rset.getString(CHAR_NAME));
                    if (element == 132 || element == 133) {
                        hero = _nobles.get(hero.getInt(CHAR_ID));
                        hero.set(CHAR_ID, rset.getInt(CHAR_ID));
                        soulHounds.add((Object)hero);
                    } else {
                        record = new LogRecord(Level.INFO, "Hero " + hero.getString(CHAR_NAME));
                        record.setParameters(new Object[]{hero.getInt(CHAR_ID), hero.getInt(CLASS_ID)});
                        _logResults.log(record);
                        _heroesToBe.add((Object)hero);
                    }
                }
                rset.close();
            }
            switch (soulHounds.size()) {
                case 0: {
                    return;
                }
                case 1: {
                    hero = new StatsSet();
                    StatsSet winner = (StatsSet)soulHounds.get(0);
                    hero.set(CLASS_ID, winner.getInt(CLASS_ID));
                    hero.set(CHAR_ID, winner.getInt(CHAR_ID));
                    hero.set(CHAR_NAME, winner.getString(CHAR_NAME));
                    record = new LogRecord(Level.INFO, "Hero " + hero.getString(CHAR_NAME));
                    record.setParameters(new Object[]{hero.getInt(CHAR_ID), hero.getInt(CLASS_ID)});
                    _logResults.log(record);
                    _heroesToBe.add((Object)hero);
                    return;
                }
                case 2: {
                    hero = new StatsSet();
                    StatsSet hero1 = (StatsSet)soulHounds.get(0);
                    StatsSet hero2 = (StatsSet)soulHounds.get(1);
                    int hero1Points = hero1.getInt(POINTS);
                    int hero2Points = hero2.getInt(POINTS);
                    int hero1Comps = hero1.getInt(COMP_DONE);
                    int hero2Comps = hero2.getInt(COMP_DONE);
                    int hero1Wins = hero1.getInt(COMP_WON);
                    int hero2Wins = hero2.getInt(COMP_WON);
                    StatsSet winner = hero1Points > hero2Points ? hero1 : (hero2Points > hero1Points ? hero2 : (hero1Comps > hero2Comps ? hero1 : (hero2Comps > hero1Comps ? hero2 : (hero1Wins > hero2Wins ? hero1 : hero2))));
                    hero.set(CLASS_ID, winner.getInt(CLASS_ID));
                    hero.set(CHAR_ID, winner.getInt(CHAR_ID));
                    hero.set(CHAR_NAME, winner.getString(CHAR_NAME));
                    record = new LogRecord(Level.INFO, "Hero " + hero.getString(CHAR_NAME));
                    record.setParameters(new Object[]{hero.getInt(CHAR_ID), hero.getInt(CLASS_ID)});
                    _logResults.log(record);
                    _heroesToBe.add((Object)hero);
                    return;
                }
            }
            return;
        }
        catch (SQLException e) {
            _log.warning("Olympiad System: Couldnt load heros from DB");
        }
    }

    public FastList<String> getClassLeaderBoard(int classId) {
        FastList names = new FastList();
        String query = Config.ALT_OLY_SHOW_MONTHLY_WINNERS ? (classId == 132 ? GET_EACH_CLASS_LEADER_SOULHOUND : GET_EACH_CLASS_LEADER) : (classId == 132 ? GET_EACH_CLASS_LEADER_CURRENT_SOULHOUND : GET_EACH_CLASS_LEADER_CURRENT);
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, classId);
            try (ResultSet rset = ps.executeQuery();){
                while (rset.next()) {
                    names.add((Object)rset.getString(CHAR_NAME));
                }
            }
        }
        catch (SQLException e) {
            _log.warning("Olympiad System: Couldn't load olympiad leaders from DB!");
        }
        return names;
    }

    public int getNoblessePasses(L2PcInstance player, boolean clear) {
        if (player == null || this._period != 1 || _noblesRank.isEmpty()) {
            return 0;
        }
        int objId = player.getObjectId();
        if (!_noblesRank.containsKey(objId)) {
            return 0;
        }
        StatsSet noble = _nobles.get(objId);
        if (noble == null || noble.getInt(POINTS) == 0) {
            return 0;
        }
        int rank = _noblesRank.get(objId);
        int points = player.isHero() ? Config.ALT_OLY_HERO_POINTS : 0;
        switch (rank) {
            case 1: {
                points += Config.ALT_OLY_RANK1_POINTS;
                break;
            }
            case 2: {
                points += Config.ALT_OLY_RANK2_POINTS;
                break;
            }
            case 3: {
                points += Config.ALT_OLY_RANK3_POINTS;
                break;
            }
            case 4: {
                points += Config.ALT_OLY_RANK4_POINTS;
                break;
            }
            default: {
                points += Config.ALT_OLY_RANK5_POINTS;
            }
        }
        if (clear) {
            noble.set(POINTS, 0);
        }
        return points *= Config.ALT_OLY_GP_PER_POINT;
    }

    public int getNoblePoints(int objId) {
        if (_nobles == null || !_nobles.containsKey(objId)) {
            return 0;
        }
        return _nobles.get(objId).getInt(POINTS);
    }

    public int getLastNobleOlympiadPoints(int objId) {
        int result = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT olympiad_points FROM olympiad_nobles_eom WHERE charId = ?");){
            ps.setInt(1, objId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.first()) {
                    result = rs.getInt(1);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not load last olympiad points:", e);
        }
        return result;
    }

    public int getCompetitionDone(int objId) {
        if (_nobles == null || !_nobles.containsKey(objId)) {
            return 0;
        }
        return _nobles.get(objId).getInt(COMP_DONE);
    }

    public int getCompetitionWon(int objId) {
        if (_nobles == null || !_nobles.containsKey(objId)) {
            return 0;
        }
        return _nobles.get(objId).getInt(COMP_WON);
    }

    public int getCompetitionLost(int objId) {
        if (_nobles == null || !_nobles.containsKey(objId)) {
            return 0;
        }
        return _nobles.get(objId).getInt(COMP_LOST);
    }

    public int getCompetitionDoneWeek(int objId) {
        if (_nobles == null || !_nobles.containsKey(objId)) {
            return 0;
        }
        return _nobles.get(objId).getInt(COMP_DONE_WEEK);
    }

    public int getCompetitionDoneWeekClassed(int objId) {
        if (_nobles == null || !_nobles.containsKey(objId)) {
            return 0;
        }
        return _nobles.get(objId).getInt(COMP_DONE_WEEK_CLASSED);
    }

    public int getCompetitionDoneWeekNonClassed(int objId) {
        if (_nobles == null || !_nobles.containsKey(objId)) {
            return 0;
        }
        return _nobles.get(objId).getInt(COMP_DONE_WEEK_NON_CLASSED);
    }

    public int getCompetitionDoneWeekTeam(int objId) {
        if (_nobles == null || !_nobles.containsKey(objId)) {
            return 0;
        }
        return _nobles.get(objId).getInt(COMP_DONE_WEEK_TEAM);
    }

    public int getRemainingWeeklyMatches(int objId) {
        return Math.max(Config.ALT_OLY_MAX_WEEKLY_MATCHES - this.getCompetitionDoneWeek(objId), 0);
    }

    public int getRemainingWeeklyMatchesClassed(int objId) {
        return Math.max(Config.ALT_OLY_MAX_WEEKLY_MATCHES_CLASSED - this.getCompetitionDoneWeekClassed(objId), 0);
    }

    public int getRemainingWeeklyMatchesNonClassed(int objId) {
        return Math.max(Config.ALT_OLY_MAX_WEEKLY_MATCHES_NON_CLASSED - this.getCompetitionDoneWeekNonClassed(objId), 0);
    }

    public int getRemainingWeeklyMatchesTeam(int objId) {
        return Math.max(Config.ALT_OLY_MAX_WEEKLY_MATCHES_TEAM - this.getCompetitionDoneWeekTeam(objId), 0);
    }

    protected void deleteNobles() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(OLYMPIAD_DELETE_ALL);){
            statement.execute();
        }
        catch (SQLException e) {
            _log.warning("Olympiad System: Couldn't delete nobles from DB!");
        }
        _nobles.clear();
    }

    protected static StatsSet addNobleStats(int charId, StatsSet data) {
        return _nobles.put(charId, data);
    }

    public static Olympiad getInstance() {
        return SingletonHolder._instance;
    }

    static {
        _noblesRank = new TIntIntHashMap();
        OLYMPIAD_GET_HEROS = "SELECT olympiad_nobles.charId, characters.char_name FROM olympiad_nobles, characters WHERE characters.charId = olympiad_nobles.charId AND olympiad_nobles.class_id = ? AND olympiad_nobles.competitions_done >= " + Config.ALT_OLY_MIN_MATCHES + " AND olympiad_nobles.competitions_won > 0 " + "ORDER BY olympiad_nobles.olympiad_points DESC, olympiad_nobles.competitions_done DESC, olympiad_nobles.competitions_won DESC";
        GET_ALL_CLASSIFIED_NOBLESS = "SELECT charId from olympiad_nobles_eom WHERE competitions_done >= " + Config.ALT_OLY_MIN_MATCHES + " ORDER BY olympiad_points DESC, competitions_done DESC, competitions_won DESC";
        GET_EACH_CLASS_LEADER = "SELECT characters.char_name from olympiad_nobles_eom, characters WHERE characters.charId = olympiad_nobles_eom.charId AND olympiad_nobles_eom.class_id = ? AND olympiad_nobles_eom.competitions_done >= " + Config.ALT_OLY_MIN_MATCHES + " " + "ORDER BY olympiad_nobles_eom.olympiad_points DESC, olympiad_nobles_eom.competitions_done DESC, olympiad_nobles_eom.competitions_won DESC LIMIT 10";
        GET_EACH_CLASS_LEADER_CURRENT = "SELECT characters.char_name from olympiad_nobles, characters WHERE characters.charId = olympiad_nobles.charId AND olympiad_nobles.class_id = ? AND olympiad_nobles.competitions_done >= " + Config.ALT_OLY_MIN_MATCHES + " " + "ORDER BY olympiad_nobles.olympiad_points DESC, olympiad_nobles.competitions_done DESC, olympiad_nobles.competitions_won DESC LIMIT 10";
        GET_EACH_CLASS_LEADER_SOULHOUND = "SELECT characters.char_name from olympiad_nobles_eom, characters WHERE characters.charId = olympiad_nobles_eom.charId AND (olympiad_nobles_eom.class_id = ? OR olympiad_nobles_eom.class_id = 133) AND olympiad_nobles_eom.competitions_done >= " + Config.ALT_OLY_MIN_MATCHES + " " + "ORDER BY olympiad_nobles_eom.olympiad_points DESC, olympiad_nobles_eom.competitions_done DESC, olympiad_nobles_eom.competitions_won DESC LIMIT 10";
        GET_EACH_CLASS_LEADER_CURRENT_SOULHOUND = "SELECT characters.char_name from olympiad_nobles, characters WHERE characters.charId = olympiad_nobles.charId AND (olympiad_nobles.class_id = ? OR olympiad_nobles.class_id = 133) AND olympiad_nobles.competitions_done >= " + Config.ALT_OLY_MIN_MATCHES + " " + "ORDER BY olympiad_nobles.olympiad_points DESC, olympiad_nobles.competitions_done DESC, olympiad_nobles.competitions_won DESC LIMIT 10";
        HERO_IDS = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 131, 132, 133, 134};
        COMP_START = Config.ALT_OLY_START_TIME;
        COMP_MIN = Config.ALT_OLY_MIN;
        COMP_PERIOD = Config.ALT_OLY_CPERIOD;
        WEEKLY_PERIOD = Config.ALT_OLY_WPERIOD;
        VALIDATION_PERIOD = Config.ALT_OLY_VPERIOD;
        DEFAULT_POINTS = Config.ALT_OLY_START_POINTS;
        WEEKLY_POINTS = Config.ALT_OLY_WEEKLY_POINTS;
        _compStarted = false;
    }

    private static class SingletonHolder {
        protected static final Olympiad _instance = new Olympiad();

        private SingletonHolder() {
        }
    }

    protected class ValidationEndTask
    implements Runnable {
        protected ValidationEndTask() {
        }

        @Override
        public void run() {
            Announcements.getInstance().announceToAll("\u30aa\u30ea\u30f3\u30d4\u30a2\u30fc\u30c9\u671f\u9593\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            Olympiad.this._period = 0;
            ++Olympiad.this._currentCycle;
            Olympiad.this.deleteNobles();
            Olympiad.this.setNewOlympiadEnd();
            Olympiad.this.init();
        }
    }

    protected class OlympiadEndTask
    implements Runnable {
        protected OlympiadEndTask() {
        }

        @Override
        public void run() {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.OLYMPIAD_PERIOD_S1_HAS_ENDED);
            sm.addNumber(Olympiad.this._currentCycle);
            Announcements.getInstance().announceToAll(sm);
            Announcements.getInstance().announceToAll("\u30aa\u30ea\u30f3\u30d4\u30a2\u30fc\u30c9\u671f\u9593\u304c\u59cb\u307e\u308a\u307e\u3057\u305f\u3002");
            if (Olympiad.this._scheduledWeeklyTask != null) {
                Olympiad.this._scheduledWeeklyTask.cancel(true);
            }
            Olympiad.this.saveNobleData();
            Olympiad.this._period = 1;
            Olympiad.this.sortHerosToBe();
            Hero.getInstance().resetData();
            Hero.getInstance().computeNewHeroes((List<StatsSet>)_heroesToBe);
            Olympiad.this.saveOlympiadStatus();
            Olympiad.this.updateMonthlyData();
            Calendar validationEnd = Calendar.getInstance();
            Olympiad.this._validationEnd = validationEnd.getTimeInMillis() + VALIDATION_PERIOD;
            Olympiad.this.loadNoblesRank();
            Olympiad.this._scheduledValdationTask = ThreadPoolManager.getInstance().scheduleGeneral(new ValidationEndTask(), Olympiad.this.getMillisToValidationEnd());
        }
    }
}

