/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.items.enchant;

import com.l2jserver.gameserver.datatables.EnchantItemGroupsData;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.enchant.AbstractEnchantItem;
import com.l2jserver.gameserver.model.items.enchant.EnchantItemGroup;
import com.l2jserver.gameserver.model.items.enchant.EnchantResultType;
import com.l2jserver.gameserver.model.items.enchant.EnchantSupportItem;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.L2EtcItemType;
import com.l2jserver.gameserver.model.items.type.L2ItemType;
import com.l2jserver.gameserver.network.Debug;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public final class EnchantScroll
extends AbstractEnchantItem {
    private final boolean _isWeapon;
    private final boolean _isBlessed;
    private final boolean _isSafe;
    private final int _scrollGroupId;
    private Set<Integer> _items;

    public EnchantScroll(StatsSet set) {
        super(set);
        this._scrollGroupId = set.getInt("scrollGroupId", 0);
        L2ItemType type = this.getItem().getItemType();
        this._isWeapon = type == L2EtcItemType.ANCIENT_CRYSTAL_ENCHANT_WP || type == L2EtcItemType.BLESS_SCRL_ENCHANT_WP || type == L2EtcItemType.SCRL_ENCHANT_WP;
        this._isBlessed = type == L2EtcItemType.BLESS_SCRL_ENCHANT_AM || type == L2EtcItemType.BLESS_SCRL_ENCHANT_WP;
        this._isSafe = type == L2EtcItemType.ANCIENT_CRYSTAL_ENCHANT_AM || type == L2EtcItemType.ANCIENT_CRYSTAL_ENCHANT_WP;
    }

    @Override
    public boolean isWeapon() {
        return this._isWeapon;
    }

    public boolean isBlessed() {
        return this._isBlessed;
    }

    public boolean isSafe() {
        return this._isSafe;
    }

    public int getScrollGroupId() {
        return this._scrollGroupId;
    }

    public void addItem(int itemId) {
        if (this._items == null) {
            this._items = new HashSet<Integer>();
        }
        this._items.add(itemId);
    }

    @Override
    public boolean isValid(L2ItemInstance itemToEnchant, EnchantSupportItem supportItem) {
        if (this._items != null && !this._items.contains(itemToEnchant.getId())) {
            return false;
        }
        if (supportItem != null) {
            if (this.isBlessed()) {
                return false;
            }
            if (!supportItem.isValid(itemToEnchant, supportItem)) {
                return false;
            }
            if (supportItem.isWeapon() != this.isWeapon()) {
                return false;
            }
        }
        return super.isValid(itemToEnchant, supportItem);
    }

    public double getChance(L2PcInstance player, L2ItemInstance enchantItem) {
        if (EnchantItemGroupsData.getInstance().getScrollGroup(this._scrollGroupId) == null) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Unexistent enchant scroll group specified for enchant scroll: " + this.getId());
            return -1.0;
        }
        EnchantItemGroup group = EnchantItemGroupsData.getInstance().getItemGroup(enchantItem.getItem(), this._scrollGroupId);
        if (group == null) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't find enchant item group for scroll: " + this.getId() + " requested by: " + player);
            return -1.0;
        }
        return group.getChance(enchantItem.getEnchantLevel());
    }

    public EnchantResultType calculateSuccess(L2PcInstance player, L2ItemInstance enchantItem, EnchantSupportItem supportItem) {
        boolean success;
        if (!this.isValid(enchantItem, supportItem)) {
            return EnchantResultType.ERROR;
        }
        double chance = this.getChance(player, enchantItem);
        if (chance == -1.0) {
            return EnchantResultType.ERROR;
        }
        double bonusRate = this.getBonusRate();
        double supportBonusRate = supportItem != null ? supportItem.getBonusRate() : 0.0;
        double finalChance = Math.min(chance + bonusRate + supportBonusRate, 100.0);
        double random = 100.0 * Rnd.nextDouble();
        boolean bl = success = random < finalChance;
        if (player.isDebug()) {
            EnchantItemGroup group = EnchantItemGroupsData.getInstance().getItemGroup(enchantItem.getItem(), this._scrollGroupId);
            StatsSet set = new StatsSet();
            if (this.isBlessed()) {
                set.set("isBlessed", this.isBlessed());
            }
            if (this.isSafe()) {
                set.set("isSafe", this.isSafe());
            }
            set.set("chance", Util.formatDouble(chance, "#.##"));
            if (bonusRate > 0.0) {
                set.set("bonusRate", Util.formatDouble(bonusRate, "#.##"));
            }
            if (supportBonusRate > 0.0) {
                set.set("supportBonusRate", Util.formatDouble(supportBonusRate, "#.##"));
            }
            set.set("finalChance", Util.formatDouble(finalChance, "#.##"));
            set.set("random", Util.formatDouble(random, "#.##"));
            set.set("success", success);
            set.set("item group", group.getName());
            set.set("scroll group", this._scrollGroupId);
            Debug.sendItemDebug(player, enchantItem, set);
        }
        return success ? EnchantResultType.SUCCESS : EnchantResultType.FAILURE;
    }
}

