/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.interfaces.INamable;
import com.l2jserver.gameserver.model.zone.type.L2ResidenceZone;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractResidence
implements INamable {
    private final int _residenceId;
    private String _name;
    private L2ResidenceZone _zone = null;
    private final List<SkillHolder> _residentialSkills = new ArrayList<SkillHolder>();

    public AbstractResidence(int residenceId) {
        this._residenceId = residenceId;
        this.initResidentialSkills();
    }

    protected abstract void load();

    protected abstract void initResidenceZone();

    protected void initResidentialSkills() {
        List<L2SkillLearn> residentialSkills = SkillTreesData.getInstance().getAvailableResidentialSkills(this.getResidenceId());
        for (L2SkillLearn s : residentialSkills) {
            this._residentialSkills.add(new SkillHolder(s.getSkillId(), s.getSkillLevel()));
        }
    }

    public final int getResidenceId() {
        return this._residenceId;
    }

    @Override
    public final String getName() {
        return this._name;
    }

    public final String getNameHtm() {
        return "&%" + this.getResidenceId() + ";";
    }

    public final void setName(String name) {
        this._name = name;
    }

    public L2ResidenceZone getResidenceZone() {
        return this._zone;
    }

    protected void setResidenceZone(L2ResidenceZone zone) {
        this._zone = zone;
    }

    public final List<SkillHolder> getResidentialSkills() {
        return this._residentialSkills;
    }

    public void giveResidentialSkills(L2PcInstance player) {
        if (this._residentialSkills != null && !this._residentialSkills.isEmpty()) {
            for (SkillHolder sh : this._residentialSkills) {
                player.addSkill(sh.getSkill(), false);
            }
        }
    }

    public void removeResidentialSkills(L2PcInstance player) {
        if (this._residentialSkills != null && !this._residentialSkills.isEmpty()) {
            for (SkillHolder sh : this._residentialSkills) {
                player.removeSkill(sh.getSkill(), false);
            }
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractResidence && ((AbstractResidence)obj).getResidenceId() == this.getResidenceId();
    }

    public String toString() {
        return this.getName() + "(" + this.getResidenceId() + ")";
    }
}

