/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.effects;

import com.l2jserver.Config;
import com.l2jserver.gameserver.handler.EffectHandler;
import com.l2jserver.gameserver.model.ChanceCondition;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.effects.EffectFlag;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.interfaces.IChanceSkillTrigger;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.funcs.Func;
import com.l2jserver.gameserver.model.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.model.stats.Env;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractEffect
implements IChanceSkillTrigger {
    protected static final Logger _log = Logger.getLogger(AbstractEffect.class.getName());
    private final Condition _attachCond;
    private List<FuncTemplate> _funcTemplates;
    private final String _name;
    private final double _val;
    private final int _ticks;
    private final int _triggeredId;
    private final int _triggeredLevel;
    private final ChanceCondition _chanceCondition;
    private final StatsSet _parameters;

    protected AbstractEffect(Condition attachCond, Condition applyCond, StatsSet set, StatsSet params) {
        this._attachCond = attachCond;
        this._name = set.getString("name");
        this._val = set.getDouble("val", 0.0);
        this._ticks = set.getInt("ticks", 0);
        this._triggeredId = set.getInt("triggeredId", 0);
        this._triggeredLevel = set.getInt("triggeredLevel", 1);
        this._chanceCondition = ChanceCondition.parse(set.getString("chanceType", null), set.getInt("activationChance", -1), set.getInt("activationMinDamage", -1), set.getString("activationElements", null), set.getString("activationSkills", null), set.getBoolean("pvpChanceOnly", false));
        this._parameters = params;
    }

    public static final AbstractEffect createEffect(Condition attachCond, Condition applyCond, StatsSet set, StatsSet params) {
        Constructor<? extends AbstractEffect> constructor;
        String name = set.getString("name");
        Class<? extends AbstractEffect> handler = EffectHandler.getInstance().getHandler(name);
        if (handler == null) {
            _log.warning(AbstractEffect.class.getSimpleName() + ": Requested unexistent effect handler: " + name);
            return null;
        }
        try {
            constructor = handler.getConstructor(Condition.class, Condition.class, StatsSet.class, StatsSet.class);
        }
        catch (NoSuchMethodException | SecurityException e1) {
            _log.warning(AbstractEffect.class.getSimpleName() + ": Requested unexistent constructor for effect handler: " + name);
            e1.printStackTrace();
            return null;
        }
        try {
            return constructor.newInstance(attachCond, applyCond, set, params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean testConditions(Env env) {
        return this._attachCond == null || this._attachCond.test(env);
    }

    public void attach(FuncTemplate f) {
        if (this._funcTemplates == null) {
            this._funcTemplates = new ArrayList<FuncTemplate>(1);
        }
        this._funcTemplates.add(f);
    }

    public String getName() {
        return this._name;
    }

    public double getValue() {
        return this._val;
    }

    public int getTicks() {
        return this._ticks;
    }

    public double getTicksMultiplier() {
        return (float)((long)this.getTicks() * Config.EFFECT_TICK_RATIO) / 1000.0f;
    }

    public List<FuncTemplate> getFuncTemplates() {
        return this._funcTemplates;
    }

    @Override
    public int getTriggeredChanceId() {
        return this._triggeredId;
    }

    @Override
    public int getTriggeredChanceLevel() {
        return this._triggeredLevel;
    }

    @Override
    public ChanceCondition getTriggeredChanceCondition() {
        return this._chanceCondition;
    }

    public boolean hasParameters() {
        return this._parameters != null;
    }

    public StatsSet getParameters() {
        return this._parameters;
    }

    public boolean calcSuccess(BuffInfo info) {
        return true;
    }

    public L2EffectType getEffectType() {
        return L2EffectType.NONE;
    }

    public boolean canStart(BuffInfo info) {
        return true;
    }

    public void onStart(BuffInfo info) {
    }

    public boolean onActionTime(BuffInfo info) {
        return false;
    }

    public void onExit(BuffInfo info) {
    }

    public List<Func> getStatFuncs(Env env) {
        if (this.getFuncTemplates() == null) {
            return Collections.emptyList();
        }
        ArrayList<Func> funcs = new ArrayList<Func>(this.getFuncTemplates().size());
        for (FuncTemplate t : this.getFuncTemplates()) {
            Func f = t.getFunc(env, this);
            if (f == null) continue;
            funcs.add(f);
        }
        return funcs;
    }

    public int getEffectFlags() {
        return EffectFlag.NONE.getMask();
    }

    public String toString() {
        return "Effect " + this._name;
    }

    public void decreaseForce() {
    }

    public void increaseEffect() {
    }

    public boolean checkCondition(Object obj) {
        return true;
    }

    @Override
    public boolean triggersChanceSkill() {
        return this._triggeredId > 0;
    }

    public boolean isInstant() {
        return false;
    }
}

