/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.tasks.cubics;

import com.l2jserver.gameserver.handler.ISkillHandler;
import com.l2jserver.gameserver.handler.SkillHandler;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CubicHeal
implements Runnable {
    private static final Logger _log = Logger.getLogger(CubicHeal.class.getName());
    private final L2CubicInstance _cubic;

    public CubicHeal(L2CubicInstance cubic) {
        this._cubic = cubic;
    }

    @Override
    public void run() {
        if (this._cubic == null) {
            return;
        }
        if (this._cubic.getOwner().isDead() || !this._cubic.getOwner().isOnline()) {
            this._cubic.stopAction();
            this._cubic.getOwner().getCubics().remove(this._cubic.getId());
            this._cubic.getOwner().broadcastUserInfo();
            this._cubic.cancelDisappear();
            return;
        }
        try {
            L2Skill skill = null;
            for (L2Skill sk : this._cubic.getSkills()) {
                if (sk.getId() != 4051) continue;
                skill = sk;
                break;
            }
            if (skill != null) {
                this._cubic.cubicTargetForHeal();
                L2Character target = this._cubic.getTarget();
                if (target != null && !target.isDead() && (double)target.getMaxHp() - target.getCurrentHp() > skill.getPower()) {
                    L2Object[] targets = new L2Character[]{target};
                    ISkillHandler handler = SkillHandler.getInstance().getHandler(skill.getSkillType());
                    if (handler != null) {
                        handler.useSkill(this._cubic.getOwner(), skill, targets);
                    } else {
                        skill.useSkill(this._cubic.getOwner(), targets);
                    }
                    this._cubic.getOwner().broadcastPacket(new MagicSkillUse(this._cubic.getOwner(), target, skill.getId(), skill.getLevel(), 0, 0));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
    }
}

