/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.tasks.cubics;

import com.l2jserver.Config;
import com.l2jserver.gameserver.handler.ISkillHandler;
import com.l2jserver.gameserver.handler.SkillHandler;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.skills.L2SkillType;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.util.Rnd;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CubicAction
implements Runnable {
    private static final Logger _log = Logger.getLogger(CubicAction.class.getName());
    private final L2CubicInstance _cubic;
    private final AtomicInteger _currentCount = new AtomicInteger();
    private final int _chance;

    public CubicAction(L2CubicInstance cubic, int chance) {
        this._cubic = cubic;
        this._chance = chance;
    }

    @Override
    public void run() {
        if (this._cubic == null) {
            return;
        }
        try {
            L2Skill skill;
            if (this._cubic.getOwner().isDead() || !this._cubic.getOwner().isOnline()) {
                this._cubic.stopAction();
                this._cubic.getOwner().getCubics().remove(this._cubic.getId());
                this._cubic.getOwner().broadcastUserInfo();
                this._cubic.cancelDisappear();
                return;
            }
            if (!AttackStanceTaskManager.getInstance().hasAttackStanceTask(this._cubic.getOwner())) {
                if (this._cubic.getOwner().hasSummon()) {
                    if (!AttackStanceTaskManager.getInstance().hasAttackStanceTask(this._cubic.getOwner().getSummon())) {
                        this._cubic.stopAction();
                        return;
                    }
                } else {
                    this._cubic.stopAction();
                    return;
                }
            }
            if (this._cubic.getCubicMaxCount() > -1 && this._currentCount.get() >= this._cubic.getCubicMaxCount()) {
                this._cubic.stopAction();
                return;
            }
            boolean useCubicCure = false;
            if (this._cubic.getId() >= 10 && this._cubic.getId() <= 14) {
                for (BuffInfo info : this._cubic.getOwner().getEffectList().getDebuffs().values()) {
                    if (!info.getSkill().canBeDispeled()) continue;
                    useCubicCure = true;
                    info.getEffected().getEffectList().stopSkillEffects(true, info.getSkill());
                }
            }
            if (useCubicCure) {
                MagicSkillUse msu = new MagicSkillUse(this._cubic.getOwner(), this._cubic.getOwner(), 5579, 1, 0, 0);
                this._cubic.getOwner().broadcastPacket(msu);
                this._currentCount.incrementAndGet();
            } else if (Rnd.get(1, 100) < this._chance && (skill = this._cubic.getSkills().get(Rnd.get(this._cubic.getSkills().size()))) != null) {
                if (skill.getId() == 4051) {
                    this._cubic.cubicTargetForHeal();
                } else {
                    this._cubic.getCubicTarget();
                    if (!L2CubicInstance.isInCubicRange(this._cubic.getOwner(), this._cubic.getTarget())) {
                        this._cubic.setTarget(null);
                    }
                }
                L2Character target = this._cubic.getTarget();
                if (target != null && !target.isDead()) {
                    if (Config.DEBUG) {
                        _log.info("L2CubicInstance: Action.run();");
                        _log.info("Cubic ID: " + this._cubic.getId() + " Target: " + target.getName() + " distance: " + target.calculateDistance(this._cubic.getOwner(), true, false));
                    }
                    this._cubic.getOwner().broadcastPacket(new MagicSkillUse(this._cubic.getOwner(), target, skill.getId(), skill.getLevel(), 0, 0));
                    L2SkillType type = skill.getSkillType();
                    ISkillHandler handler = SkillHandler.getInstance().getHandler(skill.getSkillType());
                    L2Object[] targets = new L2Character[]{target};
                    if (skill.isContinuous()) {
                        if (Config.DEBUG) {
                            _log.info("L2CubicInstance: Action.run() handler " + (Object)((Object)type));
                        }
                        this._cubic.useCubicContinuous(skill, targets);
                    } else {
                        handler.useSkill(this._cubic.getOwner(), skill, targets);
                        if (Config.DEBUG) {
                            _log.info("L2CubicInstance: Action.run(); other handler");
                        }
                    }
                    if (skill.hasEffectType(L2EffectType.MAGICAL_ATTACK)) {
                        if (Config.DEBUG) {
                            _log.info("L2CubicInstance: Action.run() handler " + (Object)((Object)type));
                        }
                        this._cubic.useCubicMdam(this._cubic, skill, targets);
                    } else if (skill.hasEffectType(L2EffectType.HP_DRAIN)) {
                        if (Config.DEBUG) {
                            _log.info("L2CubicInstance: Action.run() skill " + (Object)((Object)type));
                        }
                        this._cubic.useCubicDrain(this._cubic, skill, targets);
                    } else if (skill.hasEffectType(L2EffectType.STUN, L2EffectType.ROOT, L2EffectType.PARALYZE)) {
                        if (Config.DEBUG) {
                            _log.info("L2CubicInstance: Action.run() handler " + (Object)((Object)type));
                        }
                        this._cubic.useCubicDisabler(type, skill, targets);
                    } else if (skill.hasEffectType(L2EffectType.DMG_OVER_TIME, L2EffectType.DMG_OVER_TIME_PERCENT)) {
                        if (Config.DEBUG) {
                            _log.info("L2CubicInstance: Action.run() handler " + (Object)((Object)type));
                        }
                        this._cubic.useCubicContinuous(skill, targets);
                    } else if (skill.hasEffectType(L2EffectType.AGGRESSION)) {
                        if (Config.DEBUG) {
                            _log.info("L2CubicInstance: Action.run() handler " + (Object)((Object)type));
                        }
                        this._cubic.useCubicDisabler(type, skill, targets);
                    }
                    this._currentCount.incrementAndGet();
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
    }
}

