/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.PlayableKnownList;
import com.l2jserver.gameserver.network.serverpackets.DeleteObject;
import com.l2jserver.gameserver.network.serverpackets.SpawnItem;

public class PcKnownList
extends PlayableKnownList {
    public PcKnownList(L2PcInstance activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addKnownObject(L2Object object) {
        if (!super.addKnownObject(object)) {
            return false;
        }
        if (object.getPoly().isMorphed() && object.getPoly().getPolyType().equals("item")) {
            this.getActiveChar().sendPacket(new SpawnItem(object));
        } else {
            L2Character obj;
            object.sendInfo(this.getActiveChar());
            if (object instanceof L2Character && (obj = (L2Character)object).hasAI()) {
                obj.getAI().describeStateToPlayer(this.getActiveChar());
            }
        }
        return true;
    }

    @Override
    protected boolean removeKnownObject(L2Object object, boolean forget) {
        if (!super.removeKnownObject(object, forget)) {
            return false;
        }
        if (object instanceof L2AirShipInstance) {
            if (((L2AirShipInstance)object).getCaptainId() != 0 && ((L2AirShipInstance)object).getCaptainId() != this.getActiveChar().getObjectId()) {
                this.getActiveChar().sendPacket(new DeleteObject(((L2AirShipInstance)object).getCaptainId()));
            }
            if (((L2AirShipInstance)object).getHelmObjectId() != 0) {
                this.getActiveChar().sendPacket(new DeleteObject(((L2AirShipInstance)object).getHelmObjectId()));
            }
        }
        this.getActiveChar().sendPacket(new DeleteObject(object));
        if (Config.CHECK_KNOWN && object instanceof L2Npc && this.getActiveChar().isGM()) {
            this.getActiveChar().sendMessage("Removed NPC: " + ((L2Npc)object).getName());
        }
        return true;
    }

    @Override
    public final L2PcInstance getActiveChar() {
        return (L2PcInstance)super.getActiveChar();
    }

    private double proportion(L2Object object) {
        if (object.isAttackable()) {
            L2Attackable a = (L2Attackable)object;
            return 1.0 + (a.getCollisionRadius() + a.getCollisionHeight()) / 600.0;
        }
        if (object.isItem()) {
            return 0.8;
        }
        return 1.0;
    }

    @Override
    public int getDistanceToForgetObject(L2Object object) {
        if (object.isWalker()) {
            return 10000;
        }
        int knownlistSize = this.getKnownObjects().size();
        return (int)(this.proportion(object) * (double)(knownlistSize <= 25 ? 4000 : (knownlistSize <= 35 ? 3500 : (knownlistSize <= 70 ? 2910 : 2310))));
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        if (object.isWalker()) {
            return 9000;
        }
        int knownlistSize = this.getKnownObjects().size();
        return (int)(this.proportion(object) * (double)(knownlistSize <= 25 ? 3400 : (knownlistSize <= 35 ? 2900 : (knownlistSize <= 70 ? 2300 : 1700))));
    }
}

