/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.RaidBossPointsManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;

public final class L2GrandBossInstance
extends L2MonsterInstance {
    private static final int BOSS_MAINTENANCE_INTERVAL = 10000;
    private boolean _useRaidCurse = true;
    private boolean _isInSocialAction = false;

    public L2GrandBossInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2GrandBossInstance);
        this.setIsRaid(true);
        this.setLethalable(false);
    }

    @Override
    protected int getMaintenanceInterval() {
        return 10000;
    }

    @Override
    public void onSpawn() {
        this.setIsNoRndWalk(true);
        super.onSpawn();
    }

    public boolean isInSocialAction() {
        return this._isInSocialAction;
    }

    public void setIsInSocialAction(boolean value) {
        this._isInSocialAction = value;
        this.setIsInvul(value);
        if (value) {
            this.aggroDisable();
        } else {
            this.setAggroEnable(Rnd.get(30000, 60000));
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (GrandBossManager.getInstance().getStatsSet(this.getId()) == null) {
            return true;
        }
        L2PcInstance player = null;
        if (killer instanceof L2PcInstance) {
            player = (L2PcInstance)killer;
        } else if (killer instanceof L2Summon) {
            player = ((L2Summon)killer).getOwner();
        }
        if (player != null) {
            this.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.RAID_WAS_SUCCESSFUL));
            if (player.getParty() != null) {
                for (L2PcInstance member : player.getParty().getMembers()) {
                    RaidBossPointsManager.getInstance().addPoints(member, this.getId(), this.getLevel() / 2 + Rnd.get(-5, 5));
                    if (!member.isNoble()) continue;
                    Hero.getInstance().setRBkilled(member.getObjectId(), this.getId());
                }
            } else {
                RaidBossPointsManager.getInstance().addPoints(player, this.getId(), this.getLevel() / 2 + Rnd.get(-5, 5));
                if (player.isNoble()) {
                    Hero.getInstance().setRBkilled(player.getObjectId(), this.getId());
                }
            }
        }
        return true;
    }

    @Override
    public float getVitalityPoints(int damage) {
        return -super.getVitalityPoints(damage) / 100.0f;
    }

    @Override
    public boolean useVitalityRate() {
        return false;
    }

    public void setUseRaidCurse(boolean val) {
        this._useRaidCurse = val;
    }

    @Override
    public boolean giveRaidCurse() {
        return this._useRaidCurse;
    }
}

