/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;

public class L2FortSiegeNpcInstance
extends L2Npc {
    public L2FortSiegeNpcInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
        this.setInstanceType(InstanceType.L2FortSiegeNpcInstance);
    }

    @Override
    public void showChatWindow(L2PcInstance player, int val) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = val == 0 ? "data/html/fortress/merchant.htm" : "data/html/fortress/merchant-" + val + ".htm";
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcId%", this.getId());
        if (this.getFort().getOwnerClan() != null) {
            html.replace((CharSequence)"%clanname%", this.getFort().getOwnerClan().getName());
        } else {
            html.replace((CharSequence)"%clanname%", "NPC");
        }
        player.sendPacket(html);
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }
}

