/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.model.AbstractPlayerGroup;
import com.l2jserver.gameserver.model.L2CommandChannel;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ServitorInstance;
import com.l2jserver.gameserver.model.entity.DimensionalRift;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExAskModifyPartyLooting;
import com.l2jserver.gameserver.network.serverpackets.ExCloseMPCC;
import com.l2jserver.gameserver.network.serverpackets.ExOpenMPCC;
import com.l2jserver.gameserver.network.serverpackets.ExPartyPetWindowAdd;
import com.l2jserver.gameserver.network.serverpackets.ExPartyPetWindowDelete;
import com.l2jserver.gameserver.network.serverpackets.ExSetPartyLooting;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PartyMemberPosition;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowAdd;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowAll;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowDelete;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowDeleteAll;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class L2Party
extends AbstractPlayerGroup {
    private static final Logger _log = Logger.getLogger(L2Party.class.getName());
    private static final double[] BONUS_EXP_SP = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 2.0, 2.1, 2.2};
    private static final int[] LOOT_SYSSTRINGS = new int[]{487, 488, 798, 799, 800};
    private static final int PARTY_POSITION_BROADCAST_DELAY = 12000;
    public static final byte ITEM_LOOTER = 0;
    public static final byte ITEM_RANDOM = 1;
    public static final byte ITEM_RANDOM_SPOIL = 2;
    public static final byte ITEM_ORDER = 3;
    public static final byte ITEM_ORDER_SPOIL = 4;
    private final FastList<L2PcInstance> _members;
    private boolean _pendingInvitation = false;
    private long _pendingInviteTimeout;
    private int _partyLvl = 0;
    private int _itemDistribution = 0;
    private int _itemLastLoot = 0;
    private L2CommandChannel _commandChannel = null;
    private DimensionalRift _dr;
    private byte _requestChangeLoot = (byte)-1;
    private FastList<Integer> _changeLootAnswers = null;
    protected long _requestChangeLootTimer = 0L;
    private Future<?> _checkTask = null;
    private Future<?> _positionBroadcastTask = null;
    protected PartyMemberPosition _positionPacket;
    private boolean _disbanding = false;

    public L2Party(L2PcInstance leader, int itemDistribution) {
        this._members = new FastList().shared();
        this._members.add((Object)leader);
        this._partyLvl = leader.getLevel();
        this._itemDistribution = itemDistribution;
    }

    public boolean getPendingInvitation() {
        return this._pendingInvitation;
    }

    public void setPendingInvitation(boolean val) {
        this._pendingInvitation = val;
        this._pendingInviteTimeout = GameTimeController.getInstance().getGameTicks() + 150;
    }

    public boolean isInvitationRequestExpired() {
        return this._pendingInviteTimeout <= (long)GameTimeController.getInstance().getGameTicks();
    }

    private L2PcInstance getCheckedRandomMember(int itemId, L2Character target) {
        FastList availableMembers = new FastList();
        for (L2PcInstance member : this.getMembers()) {
            if (!member.getInventory().validateCapacityByItemId(itemId) || !Util.checkIfInRange(Config.ALT_PARTY_RANGE2, target, member, true)) continue;
            availableMembers.add(member);
        }
        if (!availableMembers.isEmpty()) {
            return (L2PcInstance)availableMembers.get(Rnd.get(availableMembers.size()));
        }
        return null;
    }

    private L2PcInstance getCheckedNextLooter(int ItemId, L2Character target) {
        for (int i = 0; i < this.getMemberCount(); ++i) {
            if (++this._itemLastLoot >= this.getMemberCount()) {
                this._itemLastLoot = 0;
            }
            try {
                L2PcInstance member = this.getMembers().get(this._itemLastLoot);
                if (!member.getInventory().validateCapacityByItemId(ItemId) || !Util.checkIfInRange(Config.ALT_PARTY_RANGE2, target, member, true)) continue;
                return member;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private L2PcInstance getActualLooter(L2PcInstance player, int ItemId, boolean spoil, L2Character target) {
        L2PcInstance looter = player;
        switch (this._itemDistribution) {
            case 1: {
                if (spoil) break;
                looter = this.getCheckedRandomMember(ItemId, target);
                break;
            }
            case 2: {
                looter = this.getCheckedRandomMember(ItemId, target);
                break;
            }
            case 3: {
                if (spoil) break;
                looter = this.getCheckedNextLooter(ItemId, target);
                break;
            }
            case 4: {
                looter = this.getCheckedNextLooter(ItemId, target);
            }
        }
        if (looter == null) {
            looter = player;
        }
        return looter;
    }

    public void broadcastToPartyMembersNewLeader() {
        for (L2PcInstance member : this.getMembers()) {
            if (member == null) continue;
            member.sendPacket(PartySmallWindowDeleteAll.STATIC_PACKET);
            member.sendPacket(new PartySmallWindowAll(member, this));
            member.broadcastUserInfo();
        }
    }

    public void broadcastToPartyMembers(L2PcInstance player, L2GameServerPacket msg) {
        for (L2PcInstance member : this.getMembers()) {
            if (member == null || member.getObjectId() == player.getObjectId()) continue;
            member.sendPacket(msg);
        }
    }

    public void addPartyMember(L2PcInstance player) {
        if (this.getMembers().contains(player)) {
            return;
        }
        if (this._requestChangeLoot != -1) {
            this.finishLootRequest(false);
        }
        player.sendPacket(new PartySmallWindowAll(player, this));
        for (L2PcInstance pMember : this.getMembers()) {
            if (pMember == null || !pMember.hasSummon()) continue;
            player.sendPacket(new ExPartyPetWindowAdd(pMember.getSummon()));
        }
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOU_JOINED_S1_PARTY);
        msg.addString(this.getLeader().getName());
        player.sendPacket(msg);
        msg = SystemMessage.getSystemMessage(SystemMessageId.C1_JOINED_PARTY);
        msg.addString(player.getName());
        this.broadcastPacket(msg);
        this.broadcastPacket(new PartySmallWindowAdd(player, this));
        if (player.hasSummon()) {
            this.broadcastPacket(new ExPartyPetWindowAdd(player.getSummon()));
        }
        this.getMembers().add(player);
        if (player.getLevel() > this._partyLvl) {
            this._partyLvl = player.getLevel();
        }
        for (L2PcInstance member : this.getMembers()) {
            if (member == null) continue;
            member.updateEffectIcons(true);
            L2Summon summon = member.getSummon();
            member.broadcastUserInfo();
            if (summon == null) continue;
            summon.updateEffectIcons();
        }
        if (this.isInDimensionalRift()) {
            this._dr.partyMemberInvited();
        }
        if (this.isInCommandChannel()) {
            player.sendPacket(ExOpenMPCC.STATIC_PACKET);
        }
        if (this._positionBroadcastTask == null) {
            this._positionBroadcastTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new PositionBroadcast(), 6000L, 12000L);
        }
    }

    public void removePartyMember(String name, messageType type) {
        this.removePartyMember(this.getPlayerByName(name), type);
    }

    public void removePartyMember(L2PcInstance player, messageType type) {
        if (this.getMembers().contains(player)) {
            SystemMessage msg;
            boolean isLeader = this.isLeader(player);
            if (!this._disbanding && (this.getMembers().size() == 2 || isLeader && !Config.ALT_LEAVE_PARTY_LEADER && type != messageType.Disconnected)) {
                this.disbandParty();
                return;
            }
            this.getMembers().remove(player);
            this.recalculatePartyLevel();
            if (player.isFestivalParticipant()) {
                SevenSignsFestival.getInstance().updateParticipants(player, this);
            }
            if (player.isInDuel()) {
                DuelManager.getInstance().onRemoveFromParty(player);
            }
            try {
                if (player.isChanneling() && player.getSkillChannelizer().hasChannelized()) {
                    player.abortCast();
                } else if (player.isChannelized()) {
                    player.getSkillChannelized().abortChannelization();
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "", e);
            }
            if (type == messageType.Expelled) {
                player.sendPacket(SystemMessageId.HAVE_BEEN_EXPELLED_FROM_PARTY);
                msg = SystemMessage.getSystemMessage(SystemMessageId.C1_WAS_EXPELLED_FROM_PARTY);
                msg.addString(player.getName());
                this.broadcastPacket(msg);
            } else if (type == messageType.Left || type == messageType.Disconnected) {
                player.sendPacket(SystemMessageId.YOU_LEFT_PARTY);
                msg = SystemMessage.getSystemMessage(SystemMessageId.C1_LEFT_PARTY);
                msg.addString(player.getName());
                this.broadcastPacket(msg);
            }
            player.sendPacket(PartySmallWindowDeleteAll.STATIC_PACKET);
            player.setParty(null);
            this.broadcastPacket(new PartySmallWindowDelete(player));
            if (player.hasSummon()) {
                this.broadcastPacket(new ExPartyPetWindowDelete(player.getSummon()));
            }
            if (this.isInDimensionalRift()) {
                this._dr.partyMemberExited(player);
            }
            if (this.isInCommandChannel()) {
                player.sendPacket(new ExCloseMPCC());
            }
            if (isLeader && this.getMembers().size() > 1 && (Config.ALT_LEAVE_PARTY_LEADER || type == messageType.Disconnected)) {
                msg = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_BECOME_A_PARTY_LEADER);
                msg.addString(this.getLeader().getName());
                this.broadcastPacket(msg);
                this.broadcastToPartyMembersNewLeader();
            } else if (this.getMembers().size() == 1) {
                if (this.isInCommandChannel()) {
                    if (this.getCommandChannel().getLeader().getObjectId() == this.getLeader().getObjectId()) {
                        this.getCommandChannel().disbandChannel();
                    } else {
                        this.getCommandChannel().removeParty(this);
                    }
                }
                if (this.getLeader() != null) {
                    this.getLeader().setParty(null);
                    if (this.getLeader().isInDuel()) {
                        DuelManager.getInstance().onRemoveFromParty(this.getLeader());
                    }
                }
                if (this._checkTask != null) {
                    this._checkTask.cancel(true);
                    this._checkTask = null;
                }
                if (this._positionBroadcastTask != null) {
                    this._positionBroadcastTask.cancel(false);
                    this._positionBroadcastTask = null;
                }
                this._members.clear();
            }
        }
    }

    public void disbandParty() {
        this._disbanding = true;
        if (this._members != null) {
            this.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.PARTY_DISPERSED));
            for (L2PcInstance member : this._members) {
                if (member == null) continue;
                this.removePartyMember(member, messageType.None);
            }
        }
    }

    public void changePartyLeader(String name) {
        this.setLeader(this.getPlayerByName(name));
    }

    @Override
    public void setLeader(L2PcInstance player) {
        if (player != null && !player.isInDuel()) {
            if (this.getMembers().contains(player)) {
                if (this.isLeader(player)) {
                    player.sendPacket(SystemMessageId.YOU_CANNOT_TRANSFER_RIGHTS_TO_YOURSELF);
                } else {
                    L2PcInstance temp = this.getLeader();
                    int p1 = this.getMembers().indexOf(player);
                    this.getMembers().set(0, player);
                    this.getMembers().set(p1, temp);
                    SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_HAS_BECOME_A_PARTY_LEADER);
                    msg.addString(this.getLeader().getName());
                    this.broadcastPacket(msg);
                    this.broadcastToPartyMembersNewLeader();
                    if (this.isInCommandChannel() && this._commandChannel.isLeader(temp)) {
                        this._commandChannel.setLeader(this.getLeader());
                        msg = SystemMessage.getSystemMessage(SystemMessageId.COMMAND_CHANNEL_LEADER_NOW_C1);
                        msg.addString(this._commandChannel.getLeader().getName());
                        this._commandChannel.broadcastPacket(msg);
                    }
                    if (player.isInPartyMatchRoom()) {
                        PartyMatchRoom room = PartyMatchRoomList.getInstance().getPlayerRoom(player);
                        room.changeLeader(player);
                    }
                }
            } else {
                player.sendPacket(SystemMessageId.YOU_CAN_TRANSFER_RIGHTS_ONLY_TO_ANOTHER_PARTY_MEMBER);
            }
        }
    }

    private L2PcInstance getPlayerByName(String name) {
        for (L2PcInstance member : this.getMembers()) {
            if (!member.getName().equalsIgnoreCase(name)) continue;
            return member;
        }
        return null;
    }

    public void distributeItem(L2PcInstance player, L2ItemInstance item) {
        if (item.getId() == 57) {
            this.distributeAdena(player, item.getCount(), player);
            ItemTable.getInstance().destroyItem("Party", item, player, null);
            return;
        }
        L2PcInstance target = this.getActualLooter(player, item.getId(), false, player);
        target.addItem("Party", item, (L2Object)player, true);
        if (item.getCount() > 1L) {
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_OBTAINED_S3_S2);
            msg.addString(target.getName());
            msg.addItemName(item);
            msg.addItemNumber(item.getCount());
            this.broadcastToPartyMembers(target, msg);
        } else {
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_OBTAINED_S2);
            msg.addString(target.getName());
            msg.addItemName(item);
            this.broadcastToPartyMembers(target, msg);
        }
    }

    public void distributeItem(L2PcInstance player, int itemId, long itemCount, boolean spoil, L2Attackable target) {
        if (itemId == 57) {
            this.distributeAdena(player, itemCount, target);
            return;
        }
        L2PcInstance looter = this.getActualLooter(player, itemId, spoil, target);
        looter.addItem(spoil ? "Sweeper" : "Party", itemId, itemCount, player, true);
        if (itemCount > 1L) {
            SystemMessage msg = spoil ? SystemMessage.getSystemMessage(SystemMessageId.C1_SWEEPED_UP_S3_S2) : SystemMessage.getSystemMessage(SystemMessageId.C1_OBTAINED_S3_S2);
            msg.addString(looter.getName());
            msg.addItemName(itemId);
            msg.addItemNumber(itemCount);
            this.broadcastToPartyMembers(looter, msg);
        } else {
            SystemMessage msg = spoil ? SystemMessage.getSystemMessage(SystemMessageId.C1_SWEEPED_UP_S2) : SystemMessage.getSystemMessage(SystemMessageId.C1_OBTAINED_S2);
            msg.addString(looter.getName());
            msg.addItemName(itemId);
            this.broadcastToPartyMembers(looter, msg);
        }
    }

    public void distributeItem(L2PcInstance player, ItemHolder item, boolean spoil, L2Attackable target) {
        this.distributeItem(player, item.getId(), item.getCount(), spoil, target);
    }

    public void distributeAdena(L2PcInstance player, long adena, L2Character target) {
        List<L2PcInstance> membersList = this.getMembers();
        FastList ToReward = FastList.newInstance();
        for (L2PcInstance member : membersList) {
            if (!Util.checkIfInRange(Config.ALT_PARTY_RANGE2, target, member, true)) continue;
            ToReward.add((Object)member);
        }
        if (ToReward.size() == 0) {
            FastList.recycle((FastList)ToReward);
            return;
        }
        long count = adena / (long)ToReward.size();
        for (L2PcInstance member : ToReward) {
            member.addAdena("Party", count, player, true);
        }
        FastList.recycle((FastList)ToReward);
    }

    public void distributeXpAndSp(long xpReward, int spReward, List<L2PcInstance> rewardedMembers, int topLvl, int partyDmg, L2Attackable target) {
        List<L2PcInstance> validMembers = this.getValidMembers(rewardedMembers, topLvl);
        xpReward = (long)((double)xpReward * this.getExpBonus(validMembers.size()));
        spReward = (int)((double)spReward * this.getSpBonus(validMembers.size()));
        int sqLevelSum = 0;
        for (L2PcInstance member : validMembers) {
            sqLevelSum += member.getLevel() * member.getLevel();
        }
        float vitalityPoints = target.getVitalityPoints(partyDmg) * Config.RATE_PARTY_XP / (float)validMembers.size();
        boolean useVitalityRate = target.useVitalityRate();
        for (L2PcInstance member : rewardedMembers) {
            if (member.isDead()) continue;
            if (validMembers.contains(member)) {
                float penalty = member.hasServitor() ? ((L2ServitorInstance)member.getSummon()).getExpPenalty() : 0.0f;
                double sqLevel = member.getLevel() * member.getLevel();
                double preCalculation = sqLevel / (double)sqLevelSum * (double)(1.0f - penalty);
                long addexp = Math.round(member.calcStat(Stats.EXPSP_RATE, (double)xpReward * preCalculation, null, null));
                int addsp = (int)member.calcStat(Stats.EXPSP_RATE, (double)spReward * preCalculation, null, null);
                addexp = this.calculateExpSpPartyCutoff(member.getActingPlayer(), topLvl, addexp, addsp, useVitalityRate);
                if (addexp <= 0L) continue;
                member.updateVitalityPoints(vitalityPoints, true, false);
                continue;
            }
            member.addExpAndSp(0L, 0);
        }
    }

    private final long calculateExpSpPartyCutoff(L2PcInstance player, int topLvl, long addExp, int addSp, boolean vit) {
        long xp = addExp;
        int sp = addSp;
        if (Config.PARTY_XP_CUTOFF_METHOD.equalsIgnoreCase("highfive")) {
            int i = 0;
            int lvlDiff = topLvl - player.getLevel();
            for (int[] gap : Config.PARTY_XP_CUTOFF_GAPS) {
                if (lvlDiff >= gap[0] && lvlDiff <= gap[1]) {
                    xp = addExp * (long)Config.PARTY_XP_CUTOFF_GAP_PERCENTS[i] / 100L;
                    sp = addSp * Config.PARTY_XP_CUTOFF_GAP_PERCENTS[i] / 100;
                    player.addExpAndSp(xp, sp, vit);
                    break;
                }
                ++i;
            }
        } else {
            player.addExpAndSp(addExp, addSp, vit);
        }
        return xp;
    }

    public void recalculatePartyLevel() {
        int newLevel = 0;
        for (L2PcInstance member : this.getMembers()) {
            if (member == null) {
                this.getMembers().remove(member);
                continue;
            }
            if (member.getLevel() <= newLevel) continue;
            newLevel = member.getLevel();
        }
        this._partyLvl = newLevel;
    }

    private List<L2PcInstance> getValidMembers(List<L2PcInstance> members, int topLvl) {
        ArrayList<L2PcInstance> validMembers = new ArrayList<L2PcInstance>();
        if (Config.PARTY_XP_CUTOFF_METHOD.equalsIgnoreCase("level")) {
            for (L2PcInstance member : members) {
                if (topLvl - member.getLevel() > Config.PARTY_XP_CUTOFF_LEVEL) continue;
                validMembers.add(member);
            }
        } else if (Config.PARTY_XP_CUTOFF_METHOD.equalsIgnoreCase("percentage")) {
            int sqLevelSum = 0;
            for (L2PcInstance member : members) {
                sqLevelSum += member.getLevel() * member.getLevel();
            }
            for (L2PcInstance member : members) {
                int sqLevel = member.getLevel() * member.getLevel();
                if (!((double)(sqLevel * 100) >= (double)sqLevelSum * Config.PARTY_XP_CUTOFF_PERCENT)) continue;
                validMembers.add(member);
            }
        } else if (Config.PARTY_XP_CUTOFF_METHOD.equalsIgnoreCase("auto")) {
            int sqLevelSum = 0;
            for (L2PcInstance member : members) {
                sqLevelSum += member.getLevel() * member.getLevel();
            }
            int i = members.size() - 1;
            if (i < 1) {
                return members;
            }
            if (i >= BONUS_EXP_SP.length) {
                i = BONUS_EXP_SP.length - 1;
            }
            for (L2PcInstance member : members) {
                int sqLevel = member.getLevel() * member.getLevel();
                if (sqLevel < sqLevelSum / (members.size() * members.size())) continue;
                validMembers.add(member);
            }
        } else if (Config.PARTY_XP_CUTOFF_METHOD.equalsIgnoreCase("highfive")) {
            validMembers.addAll(members);
        } else if (Config.PARTY_XP_CUTOFF_METHOD.equalsIgnoreCase("none")) {
            validMembers.addAll(members);
        }
        return validMembers;
    }

    private double getBaseExpSpBonus(int membersCount) {
        int i = membersCount - 1;
        if (i < 1) {
            return 1.0;
        }
        if (i >= BONUS_EXP_SP.length) {
            i = BONUS_EXP_SP.length - 1;
        }
        return BONUS_EXP_SP[i];
    }

    private double getExpBonus(int membersCount) {
        return membersCount < 2 ? this.getBaseExpSpBonus(membersCount) : this.getBaseExpSpBonus(membersCount) * (double)Config.RATE_PARTY_XP;
    }

    private double getSpBonus(int membersCount) {
        return membersCount < 2 ? this.getBaseExpSpBonus(membersCount) : this.getBaseExpSpBonus(membersCount) * (double)Config.RATE_PARTY_SP;
    }

    @Override
    public int getLevel() {
        return this._partyLvl;
    }

    public int getLootDistribution() {
        return this._itemDistribution;
    }

    public boolean isInCommandChannel() {
        return this._commandChannel != null;
    }

    public L2CommandChannel getCommandChannel() {
        return this._commandChannel;
    }

    public void setCommandChannel(L2CommandChannel channel) {
        this._commandChannel = channel;
    }

    public boolean isInDimensionalRift() {
        return this._dr != null;
    }

    public void setDimensionalRift(DimensionalRift dr) {
        this._dr = dr;
    }

    public DimensionalRift getDimensionalRift() {
        return this._dr;
    }

    @Override
    public L2PcInstance getLeader() {
        try {
            return (L2PcInstance)this._members.getFirst();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public void requestLootChange(byte type) {
        if (this._requestChangeLoot != -1) {
            if (System.currentTimeMillis() > this._requestChangeLootTimer) {
                this.finishLootRequest(false);
            } else {
                return;
            }
        }
        this._requestChangeLoot = type;
        int additionalTime = 45000;
        this._requestChangeLootTimer = System.currentTimeMillis() + (long)additionalTime;
        this._changeLootAnswers = FastList.newInstance();
        this._checkTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new ChangeLootCheck(), additionalTime + 1000, 5000L);
        this.broadcastToPartyMembers(this.getLeader(), new ExAskModifyPartyLooting(this.getLeader().getName(), type));
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.REQUESTING_APPROVAL_CHANGE_PARTY_LOOT_S1);
        sm.addSystemString(LOOT_SYSSTRINGS[type]);
        this.getLeader().sendPacket(sm);
    }

    public synchronized void answerLootChangeRequest(L2PcInstance member, boolean answer) {
        if (this._requestChangeLoot == -1) {
            return;
        }
        if (this._changeLootAnswers.contains((Object)member.getObjectId())) {
            return;
        }
        if (!answer) {
            this.finishLootRequest(false);
            return;
        }
        this._changeLootAnswers.add((Object)member.getObjectId());
        if (this._changeLootAnswers.size() >= this.getMemberCount() - 1) {
            this.finishLootRequest(true);
        }
    }

    protected synchronized void finishLootRequest(boolean success) {
        if (this._requestChangeLoot == -1) {
            return;
        }
        if (this._checkTask != null) {
            this._checkTask.cancel(false);
            this._checkTask = null;
        }
        if (success) {
            this.broadcastPacket(new ExSetPartyLooting(1, this._requestChangeLoot));
            this._itemDistribution = this._requestChangeLoot;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PARTY_LOOT_CHANGED_S1);
            sm.addSystemString(LOOT_SYSSTRINGS[this._requestChangeLoot]);
            this.broadcastPacket(sm);
        } else {
            this.broadcastPacket(new ExSetPartyLooting(0, 0));
            this.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.PARTY_LOOT_CHANGE_CANCELLED));
        }
        this._requestChangeLoot = (byte)-1;
        FastList.recycle(this._changeLootAnswers);
        this._changeLootAnswers = null;
        this._requestChangeLootTimer = 0L;
    }

    @Override
    public List<L2PcInstance> getMembers() {
        return this._members;
    }

    public boolean equals(L2Party party) {
        return party != null && this.getLeaderObjectId() == party.getLeaderObjectId();
    }

    protected class PositionBroadcast
    implements Runnable {
        protected PositionBroadcast() {
        }

        @Override
        public void run() {
            if (L2Party.this._positionPacket == null) {
                L2Party.this._positionPacket = new PartyMemberPosition(L2Party.this);
            } else {
                L2Party.this._positionPacket.reuse(L2Party.this);
            }
            L2Party.this.broadcastPacket(L2Party.this._positionPacket);
        }
    }

    protected class ChangeLootCheck
    implements Runnable {
        protected ChangeLootCheck() {
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() > L2Party.this._requestChangeLootTimer) {
                L2Party.this.finishLootRequest(false);
            }
        }
    }

    public static enum messageType {
        Expelled,
        Left,
        None,
        Disconnected;

    }
}

