/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.datatables.AdminTable;
import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.StatsSet;

public class L2AdminCommandAccessRight {
    private final String _adminCommand;
    private final int _accessLevel;
    private final boolean _requireConfirm;

    public L2AdminCommandAccessRight(StatsSet set) {
        this._adminCommand = set.getString("command");
        this._requireConfirm = set.getBoolean("confirmDlg", false);
        this._accessLevel = set.getInt("accessLevel", 7);
    }

    public L2AdminCommandAccessRight(String command, boolean confirm, int level) {
        this._adminCommand = command;
        this._requireConfirm = confirm;
        this._accessLevel = level;
    }

    public String getAdminCommand() {
        return this._adminCommand;
    }

    public boolean hasAccess(L2AccessLevel characterAccessLevel) {
        L2AccessLevel accessLevel = AdminTable.getInstance().getAccessLevel(this._accessLevel);
        return accessLevel.getLevel() == characterAccessLevel.getLevel() || characterAccessLevel.hasChildAccess(accessLevel);
    }

    public boolean getRequireConfirm() {
        return this._requireConfirm;
    }
}

