/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Castle;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public final class SiegeGuardManager {
    private static Logger _log = Logger.getLogger(SiegeGuardManager.class.getName());
    private final Castle _castle;
    private final List<L2Spawn> _siegeGuardSpawn = new FastList();

    public SiegeGuardManager(Castle castle) {
        this._castle = castle;
    }

    public void addSiegeGuard(L2PcInstance activeChar, int npcId) {
        if (activeChar == null) {
            return;
        }
        this.addSiegeGuard(activeChar.getX(), activeChar.getY(), activeChar.getZ(), activeChar.getHeading(), npcId);
    }

    public void addSiegeGuard(int x, int y, int z, int heading, int npcId) {
        this.saveSiegeGuard(x, y, z, heading, npcId, 0);
    }

    public void hireMerc(L2PcInstance activeChar, int npcId) {
        if (activeChar == null) {
            return;
        }
        this.hireMerc(activeChar.getX(), activeChar.getY(), activeChar.getZ(), activeChar.getHeading(), npcId);
    }

    public void hireMerc(int x, int y, int z, int heading, int npcId) {
        this.saveSiegeGuard(x, y, z, heading, npcId, 1);
    }

    public void removeMerc(int npcId, int x, int y, int z) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("Delete From castle_siege_guards Where npcId = ? And x = ? AND y = ? AND z = ? AND isHired = 1");){
            ps.setInt(1, npcId);
            ps.setInt(2, x);
            ps.setInt(3, y);
            ps.setInt(4, z);
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error deleting hired siege guard at " + x + ',' + y + ',' + z + ": " + e.getMessage(), e);
        }
    }

    public void removeMercs() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("Delete From castle_siege_guards Where castleId = ? And isHired = 1");){
            ps.setInt(1, this.getCastle().getResidenceId());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error deleting hired siege guard for castle " + this.getCastle().getName() + ": " + e.getMessage(), e);
        }
    }

    public void spawnSiegeGuard() {
        try {
            int hiredCount = 0;
            int hiredMax = MercTicketManager.getInstance().getMaxAllowedMerc(this._castle.getResidenceId());
            boolean isHired = this.getCastle().getOwnerId() > 0;
            this.loadSiegeGuard();
            for (L2Spawn spawn : this.getSiegeGuardSpawn()) {
                if (spawn == null) continue;
                spawn.init();
                if (!isHired) continue;
                spawn.stopRespawn();
                if (++hiredCount <= hiredMax) continue;
                return;
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error spawning siege guards for castle " + this.getCastle().getName(), e);
        }
    }

    public void unspawnSiegeGuard() {
        for (L2Spawn spawn : this.getSiegeGuardSpawn()) {
            if (spawn == null || spawn.getLastSpawn() == null) continue;
            spawn.stopRespawn();
            spawn.getLastSpawn().doDie(spawn.getLastSpawn());
        }
        this.getSiegeGuardSpawn().clear();
    }

    private void loadSiegeGuard() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM castle_siege_guards Where castleId = ? And isHired = ?");){
            ps.setInt(1, this.getCastle().getResidenceId());
            if (this.getCastle().getOwnerId() > 0) {
                ps.setInt(2, 1);
            } else {
                ps.setInt(2, 0);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rs.getInt("npcId"));
                    if (template1 != null) {
                        L2Spawn spawn1 = new L2Spawn(template1);
                        spawn1.setAmount(1);
                        spawn1.setX(rs.getInt("x"));
                        spawn1.setY(rs.getInt("y"));
                        spawn1.setZ(rs.getInt("z"));
                        spawn1.setHeading(rs.getInt("heading"));
                        spawn1.setRespawnDelay(rs.getInt("respawnDelay"));
                        spawn1.setLocationId(0);
                        this._siegeGuardSpawn.add(spawn1);
                        continue;
                    }
                    _log.warning(this.getClass().getSimpleName() + ": Missing npc data in npc table for id: " + rs.getInt("npcId"));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error loading siege guard for castle " + this.getCastle().getName() + ": " + e.getMessage(), e);
        }
    }

    private void saveSiegeGuard(int x, int y, int z, int heading, int npcId, int isHire) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("Insert Into castle_siege_guards (castleId, npcId, x, y, z, heading, respawnDelay, isHired) Values (?, ?, ?, ?, ?, ?, ?, ?)");){
            statement.setInt(1, this.getCastle().getResidenceId());
            statement.setInt(2, npcId);
            statement.setInt(3, x);
            statement.setInt(4, y);
            statement.setInt(5, z);
            statement.setInt(6, heading);
            statement.setInt(7, isHire == 1 ? 0 : 600);
            statement.setInt(8, isHire);
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error adding siege guard for castle " + this.getCastle().getName() + ": " + e.getMessage(), e);
        }
    }

    public final Castle getCastle() {
        return this._castle;
    }

    public final List<L2Spawn> getSiegeGuardSpawn() {
        return this._siegeGuardSpawn;
    }
}

