/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2MapRegion;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.zone.L2ZoneRespawn;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.type.L2RespawnZone;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class MapRegionManager
extends DocumentParser {
    private static final Map<String, L2MapRegion> _regions = new HashMap<String, L2MapRegion>();
    private static final String defaultRespawn = "talking_island_town";

    protected MapRegionManager() {
        this.load();
    }

    @Override
    public void load() {
        _regions.clear();
        this.parseDatapackDirectory("data/mapregion", false);
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _regions.size() + " map regions.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"region".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                String name = attrs.getNamedItem("name").getNodeValue();
                String town = attrs.getNamedItem("town").getNodeValue();
                int locId = this.parseInteger(attrs, "locId");
                int castle = this.parseInteger(attrs, "castle");
                int bbs = this.parseInteger(attrs, "bbs");
                L2MapRegion region = new L2MapRegion(name, town, locId, castle, bbs);
                for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                    attrs = c.getAttributes();
                    if ("respawnPoint".equalsIgnoreCase(c.getNodeName())) {
                        int spawnX = this.parseInteger(attrs, "X");
                        int spawnY = this.parseInteger(attrs, "Y");
                        int spawnZ = this.parseInteger(attrs, "Z");
                        boolean other = this.parseBoolean(attrs, "isOther", false);
                        boolean chaotic = this.parseBoolean(attrs, "isChaotic", false);
                        boolean banish = this.parseBoolean(attrs, "isBanish", false);
                        if (other) {
                            region.addOtherSpawn(spawnX, spawnY, spawnZ);
                            continue;
                        }
                        if (chaotic) {
                            region.addChaoticSpawn(spawnX, spawnY, spawnZ);
                            continue;
                        }
                        if (banish) {
                            region.addBanishSpawn(spawnX, spawnY, spawnZ);
                            continue;
                        }
                        region.addSpawn(spawnX, spawnY, spawnZ);
                        continue;
                    }
                    if ("map".equalsIgnoreCase(c.getNodeName())) {
                        region.addMap(this.parseInteger(attrs, "X"), this.parseInteger(attrs, "Y"));
                        continue;
                    }
                    if (!"banned".equalsIgnoreCase(c.getNodeName())) continue;
                    region.addBannedRace(attrs.getNamedItem("race").getNodeValue(), attrs.getNamedItem("point").getNodeValue());
                }
                _regions.put(name, region);
            }
        }
    }

    public final L2MapRegion getMapRegion(int locX, int locY) {
        for (L2MapRegion region : _regions.values()) {
            if (!region.isZoneInRegion(this.getMapRegionX(locX), this.getMapRegionY(locY))) continue;
            return region;
        }
        return null;
    }

    public final int getMapRegionLocId(int locX, int locY) {
        L2MapRegion region = this.getMapRegion(locX, locY);
        if (region != null) {
            return region.getLocId();
        }
        return 0;
    }

    public final L2MapRegion getMapRegion(L2Object obj) {
        return this.getMapRegion(obj.getX(), obj.getY());
    }

    public final int getMapRegionLocId(L2Object obj) {
        return this.getMapRegionLocId(obj.getX(), obj.getY());
    }

    public final int getMapRegionX(int posX) {
        return (posX >> 15) + 9 + 11;
    }

    public final int getMapRegionY(int posY) {
        return (posY >> 15) + 10 + 8;
    }

    public L2MapRegion getClosestTown(int x, int y) {
        return this.getMapRegion(x, y);
    }

    public String getClosestTownName(int x, int y) {
        L2MapRegion region = this.getMapRegion(x, y);
        if (region == null) {
            return "\u30a2\u30c7\u30f3\u57ce\u306e\u6751";
        }
        return region.getTown();
    }

    public String getClosestTownName(L2Character activeChar) {
        L2MapRegion region = this.getMapRegion(activeChar);
        if (region == null) {
            return "\u30a2\u30c7\u30f3\u57ce\u306e\u6751";
        }
        return region.getTown();
    }

    public int getAreaCastle(L2Character activeChar) {
        L2MapRegion region = this.getMapRegion(activeChar);
        if (region == null) {
            return 0;
        }
        return region.getCastle();
    }

    public Location getTeleToLocation(L2Character activeChar, TeleportWhereType teleportWhere) {
        if (activeChar instanceof L2PcInstance) {
            Location loc;
            Instance inst;
            L2ZoneType zone;
            L2PcInstance player = (L2PcInstance)activeChar;
            Castle castle = null;
            Fort fort = null;
            ClanHall clanhall = null;
            if (player.getClan() != null && !player.isFlyingMounted() && !player.isFlying()) {
                if (teleportWhere == TeleportWhereType.CLANHALL && (clanhall = ClanHallManager.getInstance().getAbstractHallByOwner(player.getClan())) != null && (zone = clanhall.getZone()) != null && !player.isFlyingMounted()) {
                    if (player.getKarma() > 0) {
                        return ((L2ZoneRespawn)zone).getChaoticSpawnLoc();
                    }
                    return ((L2ZoneRespawn)zone).getSpawnLoc();
                }
                if (teleportWhere == TeleportWhereType.CASTLE) {
                    castle = CastleManager.getInstance().getCastleByOwner(player.getClan());
                    if (!(castle != null || (castle = CastleManager.getInstance().getCastle(player)) != null && castle.getSiege().getIsInProgress() && castle.getSiege().getDefenderClan(player.getClan()) != null)) {
                        castle = null;
                    }
                    if (castle != null && castle.getResidenceId() > 0) {
                        if (player.getKarma() > 0) {
                            return castle.getResidenceZone().getChaoticSpawnLoc();
                        }
                        return castle.getResidenceZone().getSpawnLoc();
                    }
                }
                if (teleportWhere == TeleportWhereType.FORTRESS) {
                    fort = FortManager.getInstance().getFortByOwner(player.getClan());
                    if (!(fort != null || (fort = FortManager.getInstance().getFort(player)) != null && fort.getSiege().getIsInProgress() && fort.getOwnerClan() == player.getClan())) {
                        fort = null;
                    }
                    if (fort != null && fort.getResidenceId() > 0) {
                        if (player.getKarma() > 0) {
                            return fort.getResidenceZone().getChaoticSpawnLoc();
                        }
                        return fort.getResidenceZone().getSpawnLoc();
                    }
                }
                if (teleportWhere == TeleportWhereType.SIEGEFLAG) {
                    SiegableHall sHall;
                    List<L2Npc> flags;
                    List<L2Npc> flags2;
                    castle = CastleManager.getInstance().getCastle(player);
                    fort = FortManager.getInstance().getFort(player);
                    clanhall = ClanHallManager.getInstance().getNearbyAbstractHall(activeChar.getX(), activeChar.getY(), 10000);
                    L2SiegeFlagInstance tw_flag = TerritoryWarManager.getInstance().getFlagForClan(player.getClan());
                    if (tw_flag != null) {
                        return tw_flag.getLocation();
                    }
                    if (castle != null) {
                        if (castle.getSiege().getIsInProgress() && (flags2 = castle.getSiege().getFlag(player.getClan())) != null && !flags2.isEmpty()) {
                            return flags2.get(0).getLocation();
                        }
                    } else if (fort != null) {
                        if (fort.getSiege().getIsInProgress() && (flags2 = fort.getSiege().getFlag(player.getClan())) != null && !flags2.isEmpty()) {
                            return flags2.get(0).getLocation();
                        }
                    } else if (clanhall != null && clanhall.isSiegableHall() && (flags = (sHall = (SiegableHall)clanhall).getSiege().getFlag(player.getClan())) != null && !flags.isEmpty()) {
                        return flags.get(0).getLocation();
                    }
                }
            }
            if (teleportWhere == TeleportWhereType.CASTLE_BANISH) {
                castle = CastleManager.getInstance().getCastle(player);
                if (castle != null) {
                    return castle.getResidenceZone().getBanishSpawnLoc();
                }
            } else if (teleportWhere == TeleportWhereType.FORTRESS_BANISH) {
                fort = FortManager.getInstance().getFort(activeChar);
                if (fort != null) {
                    return fort.getResidenceZone().getBanishSpawnLoc();
                }
            } else if (teleportWhere == TeleportWhereType.CLANHALL_BANISH && (clanhall = ClanHallManager.getInstance().getClanHall(activeChar)) != null) {
                return clanhall.getZone().getBanishSpawnLoc();
            }
            if (player.getKarma() > 0) {
                try {
                    zone = ZoneManager.getInstance().getZone(player, L2RespawnZone.class);
                    if (zone != null) {
                        return this.getRestartRegion(activeChar, ((L2RespawnZone)zone).getRespawnPoint((L2PcInstance)activeChar)).getChaoticSpawnLoc();
                    }
                    return this.getMapRegion(activeChar).getChaoticSpawnLoc();
                }
                catch (Exception e) {
                    if (player.isFlyingMounted()) {
                        return _regions.get("union_base_of_kserth").getChaoticSpawnLoc();
                    }
                    return _regions.get(defaultRespawn).getChaoticSpawnLoc();
                }
            }
            castle = CastleManager.getInstance().getCastle(player);
            if (castle != null && castle.getSiege().getIsInProgress() && (castle.getSiege().checkIsDefender(player.getClan()) || castle.getSiege().checkIsAttacker(player.getClan())) && SevenSigns.getInstance().getSealOwner(3) == 2) {
                return castle.getResidenceZone().getOtherSpawnLoc();
            }
            if (player.getInstanceId() > 0 && (inst = InstanceManager.getInstance().getInstance(player.getInstanceId())) != null && (loc = inst.getSpawnLoc()) != null) {
                return loc;
            }
        }
        try {
            L2RespawnZone zone = ZoneManager.getInstance().getZone(activeChar, L2RespawnZone.class);
            if (zone != null) {
                return this.getRestartRegion(activeChar, zone.getRespawnPoint((L2PcInstance)activeChar)).getSpawnLoc();
            }
            return this.getMapRegion(activeChar).getSpawnLoc();
        }
        catch (Exception e) {
            return _regions.get(defaultRespawn).getSpawnLoc();
        }
    }

    public L2MapRegion getRestartRegion(L2Character activeChar, String point) {
        try {
            L2PcInstance player = (L2PcInstance)activeChar;
            L2MapRegion region = _regions.get(point);
            if (region.getBannedRace().containsKey((Object)player.getRace())) {
                this.getRestartRegion(player, region.getBannedRace().get((Object)player.getRace()));
            }
            return region;
        }
        catch (Exception e) {
            return _regions.get(defaultRespawn);
        }
    }

    public L2MapRegion getMapRegionByName(String regionName) {
        return _regions.get(regionName);
    }

    public static MapRegionManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final MapRegionManager _instance = new MapRegionManager();

        private SingletonHolder() {
        }
    }
}

