/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.handler.AdminCommandHandler;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.tasks.FourSepulchersChangeCoolDownTimeTask;
import com.l2jserver.gameserver.instancemanager.tasks.FourSepulchersChangeEntryTimeTask;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SepulcherMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SepulcherNpcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import jp.sf.l2j.arrayMaps.SortedIntBooleanArrayMap;
import jp.sf.l2j.arrayMaps.SortedIntIntArrayMap;
import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;

public final class FourSepulchersManager
implements IAdminCommandHandler {
    private static final Logger _log = Logger.getLogger(FourSepulchersManager.class.getName());
    private static final int QUEST_ID = 620;
    private static final int ENTRANCE_PASS = 7075;
    private static final int USED_PASS = 7261;
    private static final int CHAPEL_KEY = 7260;
    private static final int ANTIQUE_BROOCH = 7262;
    private FourSepulchersPeriod _currentPeriod;
    private ScheduledFuture<?> _changePeriodTask;
    private Location[] START_HALL_SPAWN = new Location[]{new Location(181632, -85587, -7218, 0), new Location(179963, -88978, -7218, 0), new Location(173217, -86132, -7218, 0), new Location(175608, -82296, -7218, 0)};
    private final int[] DUKES_HALL_GATEKEEPER = new int[]{31929, 31934, 31939, 31944};
    private final int[] SHADOW_OF_HALISHA = new int[]{25339, 25349, 25346, 25342};
    private final Location[] SHADOW_SPAWN = new Location[]{new Location(191231, -85574, -7216, 33380), new Location(189534, -88969, -7216, 32768), new Location(173195, -76560, -7215, 49277), new Location(175591, -72744, -7215, 49317)};
    protected SortedIntBooleanArrayMap _archonSpawned = new SortedIntBooleanArrayMap();
    protected SortedIntBooleanArrayMap _hallInUse = new SortedIntBooleanArrayMap();
    protected SortedIntObjectArrayMap<Location> _startHallSpawns = new SortedIntObjectArrayMap((Object[])new Location[0]);
    protected SortedIntIntArrayMap _hallGateKeepers = new SortedIntIntArrayMap();
    protected SortedIntIntArrayMap _keyBoxNpc = new SortedIntIntArrayMap();
    protected SortedIntIntArrayMap _victim = new SortedIntIntArrayMap();
    protected SortedIntObjectArrayMap<L2Spawn> _mysteriousBoxSpawns = new SortedIntObjectArrayMap((Object[])new L2Spawn[0]);
    protected SortedIntObjectArrayMap<L2Spawn> _shadowSpawns = new SortedIntObjectArrayMap((Object[])new L2Spawn[0]);
    protected SortedIntObjectArrayMap<FastList<L2Spawn>> _dukeFinalMobs = new SortedIntObjectArrayMap((Object[])new FastList[0]);
    protected SortedIntObjectArrayMap<FastList<L2SepulcherMonsterInstance>> _dukeMobs = new SortedIntObjectArrayMap((Object[])new FastList[0]);
    protected SortedIntObjectArrayMap<FastList<L2Spawn>> _emperorsGraveNpcs = new SortedIntObjectArrayMap((Object[])new FastList[0]);
    protected SortedIntObjectArrayMap<FastList<L2Spawn>> _magicalMonsters = new SortedIntObjectArrayMap((Object[])new FastList[0]);
    protected SortedIntObjectArrayMap<FastList<L2Spawn>> _physicalMonsters = new SortedIntObjectArrayMap((Object[])new FastList[0]);
    protected SortedIntObjectArrayMap<FastList<L2SepulcherMonsterInstance>> _viscountMobs = new SortedIntObjectArrayMap((Object[])new FastList[0]);
    protected FastList<L2Spawn> _managers;
    protected FastList<L2Npc> _allMobs = new FastList();
    public static final int NEW_CYCLE_MINUTE = 55;
    public static final int OUST_PLAYER_MARGIN_TIME = 30000;
    public static final int ATTACK_ELASPED_INTERVAL = 5;
    private long _attackTimeStart;

    public void init() {
        if (this._changePeriodTask != null) {
            this._changePeriodTask.cancel(false);
            this._changePeriodTask = null;
        }
        this._currentPeriod = null;
        this.initFixedInfo();
        this.loadMysteriousBox();
        this.initKeyBoxSpawns();
        this.loadPhysicalMonsters();
        this.loadMagicalMonsters();
        this.initLocationShadowSpawns();
        this.initExecutionerSpawns();
        this.loadDukeMonsters();
        this.loadEmperorsGraveMonsters();
        this.spawnManagers();
        this._changePeriodTask = ThreadPoolManager.getInstance().scheduleGeneral(new FourSepulchersChangeCoolDownTimeTask(), 0L);
        _log.info(this.getClass().getSimpleName() + ": Beginning in Cooldown time");
        AdminCommandHandler.getInstance().registerHandler(this);
    }

    public void clean() {
        for (Location location : (Location[])this._startHallSpawns.values()) {
            L2BossZone zone = GrandBossManager.getInstance().getZone(location.getX(), location.getY(), location.getZ());
            if (zone != null) {
                zone.oustAllPlayers();
                continue;
            }
            if (GrandBossManager.getInstance().getZones().size() <= 0) continue;
            throw new RuntimeException();
        }
        this.deleteAllMobs();
        this.closeAllDoors();
        this._hallInUse.fill(false);
        this._archonSpawned.fill(false);
    }

    protected void spawnManagers() {
        this._managers = new FastList();
        for (int i = 31921; i <= 31924; ++i) {
            L2Spawn spawnDat = SpawnTable.getInstance().getSpawnOne(i);
            this._managers.add((Object)spawnDat);
            _log.info(this.getClass().getSimpleName() + ": spawned " + spawnDat.getTemplate().getName());
        }
    }

    protected void initFixedInfo() {
        this._startHallSpawns.put(31921, (Object)this.START_HALL_SPAWN[0]);
        this._startHallSpawns.put(31922, (Object)this.START_HALL_SPAWN[1]);
        this._startHallSpawns.put(31923, (Object)this.START_HALL_SPAWN[2]);
        this._startHallSpawns.put(31924, (Object)this.START_HALL_SPAWN[3]);
        this._hallInUse.put(31921, false);
        this._hallInUse.put(31922, false);
        this._hallInUse.put(31923, false);
        this._hallInUse.put(31924, false);
        this._hallGateKeepers.put(31925, 25150012);
        this._hallGateKeepers.put(31926, 25150013);
        this._hallGateKeepers.put(31927, 25150014);
        this._hallGateKeepers.put(31928, 25150015);
        this._hallGateKeepers.put(31929, 25150016);
        this._hallGateKeepers.put(31930, 25150002);
        this._hallGateKeepers.put(31931, 25150003);
        this._hallGateKeepers.put(31932, 25150004);
        this._hallGateKeepers.put(31933, 25150005);
        this._hallGateKeepers.put(31934, 25150006);
        this._hallGateKeepers.put(31935, 25150032);
        this._hallGateKeepers.put(31936, 25150033);
        this._hallGateKeepers.put(31937, 25150034);
        this._hallGateKeepers.put(31938, 25150035);
        this._hallGateKeepers.put(31939, 25150036);
        this._hallGateKeepers.put(31940, 25150022);
        this._hallGateKeepers.put(31941, 25150023);
        this._hallGateKeepers.put(31942, 25150024);
        this._hallGateKeepers.put(31943, 25150025);
        this._hallGateKeepers.put(31944, 25150026);
        this._keyBoxNpc.put(18120, 31455);
        this._keyBoxNpc.put(18121, 31455);
        this._keyBoxNpc.put(18122, 31455);
        this._keyBoxNpc.put(18123, 31455);
        this._keyBoxNpc.put(18124, 31456);
        this._keyBoxNpc.put(18125, 31456);
        this._keyBoxNpc.put(18126, 31456);
        this._keyBoxNpc.put(18127, 31456);
        this._keyBoxNpc.put(18128, 31457);
        this._keyBoxNpc.put(18129, 31457);
        this._keyBoxNpc.put(18130, 31457);
        this._keyBoxNpc.put(18131, 31457);
        this._keyBoxNpc.put(18149, 31458);
        this._keyBoxNpc.put(18150, 31459);
        this._keyBoxNpc.put(18151, 31459);
        this._keyBoxNpc.put(18152, 31459);
        this._keyBoxNpc.put(18153, 31459);
        this._keyBoxNpc.put(18154, 31460);
        this._keyBoxNpc.put(18155, 31460);
        this._keyBoxNpc.put(18156, 31460);
        this._keyBoxNpc.put(18157, 31460);
        this._keyBoxNpc.put(18158, 31461);
        this._keyBoxNpc.put(18159, 31461);
        this._keyBoxNpc.put(18160, 31461);
        this._keyBoxNpc.put(18161, 31461);
        this._keyBoxNpc.put(18162, 31462);
        this._keyBoxNpc.put(18163, 31462);
        this._keyBoxNpc.put(18164, 31462);
        this._keyBoxNpc.put(18165, 31462);
        this._keyBoxNpc.put(18183, 31463);
        this._keyBoxNpc.put(18184, 31464);
        this._keyBoxNpc.put(18212, 31465);
        this._keyBoxNpc.put(18213, 31465);
        this._keyBoxNpc.put(18214, 31465);
        this._keyBoxNpc.put(18215, 31465);
        this._keyBoxNpc.put(18216, 31466);
        this._keyBoxNpc.put(18217, 31466);
        this._keyBoxNpc.put(18218, 31466);
        this._keyBoxNpc.put(18219, 31466);
        this._victim.put(18150, 18158);
        this._victim.put(18151, 18159);
        this._victim.put(18152, 18160);
        this._victim.put(18153, 18161);
        this._victim.put(18154, 18162);
        this._victim.put(18155, 18163);
        this._victim.put(18156, 18164);
        this._victim.put(18157, 18165);
    }

    private void loadMysteriousBox() {
        this._mysteriousBoxSpawns.clear();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY id");){
            ps.setInt(1, 0);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rs.getInt("npc_templateid"));
                    if (template1 != null) {
                        L2Spawn spawnDat = new L2Spawn(template1);
                        spawnDat.setAmount(rs.getInt("count"));
                        spawnDat.setX(rs.getInt("locx"));
                        spawnDat.setY(rs.getInt("locy"));
                        spawnDat.setZ(rs.getInt("locz"));
                        spawnDat.setHeading(rs.getInt("heading"));
                        spawnDat.setRespawnDelay(rs.getInt("respawn_delay"));
                        int keyNpcId = rs.getInt("key_npc_id");
                        this._mysteriousBoxSpawns.put(keyNpcId, (Object)spawnDat);
                        continue;
                    }
                    _log.warning("FourSepulchersManager.LoadMysteriousBox: Data missing in NPC table for ID: " + rs.getInt("npc_templateid") + ".");
                }
            }
            _log.info(this.getClass().getSimpleName() + ": loaded " + this._mysteriousBoxSpawns.size() + " Mysterious-Box spawns.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "FourSepulchersManager.LoadMysteriousBox: Spawn could not be initialized: " + e.getMessage(), e);
        }
    }

    private void initKeyBoxSpawns() {
        for (int spawnNpcId : this._keyBoxNpc.values()) {
            try {
                L2NpcTemplate template = NpcTable.getInstance().getTemplate(spawnNpcId);
                if (template == null) {
                    throw new AssertionError();
                }
                new L2Spawn(template);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "FourSepulchersManager.InitKeyBoxSpawns: Spawn could not be initialized: " + e.getMessage(), e);
            }
        }
    }

    private void loadPhysicalMonsters() {
        this._physicalMonsters.clear();
        int loaded = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");){
            ps1.setInt(1, 1);
            try (ResultSet rs1 = ps1.executeQuery();
                 PreparedStatement ps2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist Where key_npc_id = ? and spawntype = ? ORDER BY id");){
                while (rs1.next()) {
                    FastList physicalSpawns = new FastList();
                    int keyNpcId = rs1.getInt("key_npc_id");
                    ps2.setInt(1, keyNpcId);
                    ps2.setInt(2, 1);
                    try (ResultSet rs2 = ps2.executeQuery();){
                        while (rs2.next()) {
                            L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rs2.getInt("npc_templateid"));
                            if (template1 != null) {
                                L2Spawn spawnDat = new L2Spawn(template1);
                                spawnDat.setAmount(rs2.getInt("count"));
                                spawnDat.setX(rs2.getInt("locx"));
                                spawnDat.setY(rs2.getInt("locy"));
                                spawnDat.setZ(rs2.getInt("locz"));
                                spawnDat.setHeading(rs2.getInt("heading"));
                                spawnDat.setRespawnDelay(rs2.getInt("respawn_delay"));
                                physicalSpawns.add((Object)spawnDat);
                                ++loaded;
                                continue;
                            }
                            _log.warning("FourSepulchersManager.LoadPhysicalMonsters: Data missing in NPC table for ID: " + rs2.getInt("npc_templateid") + ".");
                        }
                    }
                    ps2.clearParameters();
                    this._physicalMonsters.put(keyNpcId, (Object)physicalSpawns);
                }
            }
            _log.info(this.getClass().getSimpleName() + ": loaded " + loaded + " Physical type monsters spawns.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "FourSepulchersManager.LoadPhysicalMonsters: Spawn could not be initialized: " + e.getMessage(), e);
        }
    }

    private void loadMagicalMonsters() {
        this._magicalMonsters.clear();
        int loaded = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");){
            ps1.setInt(1, 2);
            try (ResultSet rs1 = ps1.executeQuery();
                 PreparedStatement ps2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist WHERE key_npc_id = ? AND spawntype = ? ORDER BY id");){
                while (rs1.next()) {
                    FastList magicalSpawns = new FastList();
                    int keyNpcId = rs1.getInt("key_npc_id");
                    ps2.setInt(1, keyNpcId);
                    ps2.setInt(2, 2);
                    try (ResultSet rset2 = ps2.executeQuery();){
                        while (rset2.next()) {
                            L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset2.getInt("npc_templateid"));
                            if (template1 != null) {
                                L2Spawn spawnDat = new L2Spawn(template1);
                                spawnDat.setAmount(rset2.getInt("count"));
                                spawnDat.setX(rset2.getInt("locx"));
                                spawnDat.setY(rset2.getInt("locy"));
                                spawnDat.setZ(rset2.getInt("locz"));
                                spawnDat.setHeading(rset2.getInt("heading"));
                                spawnDat.setRespawnDelay(rset2.getInt("respawn_delay"));
                                magicalSpawns.add((Object)spawnDat);
                                ++loaded;
                                continue;
                            }
                            _log.warning("FourSepulchersManager.LoadMagicalMonsters: Data missing in NPC table for ID: " + rset2.getInt("npc_templateid") + ".");
                        }
                    }
                    ps2.clearParameters();
                    this._magicalMonsters.put(keyNpcId, (Object)magicalSpawns);
                }
            }
            _log.info(this.getClass().getSimpleName() + ": loaded " + loaded + " Magical type monsters spawns.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "FourSepulchersManager.LoadMagicalMonsters: Spawn could not be initialized: " + e.getMessage(), e);
        }
    }

    private void loadDukeMonsters() {
        this._dukeFinalMobs.clear();
        this._archonSpawned.clear();
        int loaded = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");){
            ps1.setInt(1, 5);
            try (ResultSet rs1 = ps1.executeQuery();
                 PreparedStatement ps2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist WHERE key_npc_id = ? AND spawntype = ? ORDER BY id");){
                while (rs1.next()) {
                    FastList dukeFinalSpawns = new FastList();
                    int keyNpcId = rs1.getInt("key_npc_id");
                    ps2.setInt(1, keyNpcId);
                    ps2.setInt(2, 5);
                    try (ResultSet rset2 = ps2.executeQuery();){
                        ps2.clearParameters();
                        while (rset2.next()) {
                            L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset2.getInt("npc_templateid"));
                            if (template1 != null) {
                                L2Spawn spawnDat = new L2Spawn(template1);
                                spawnDat.setAmount(rset2.getInt("count"));
                                spawnDat.setX(rset2.getInt("locx"));
                                spawnDat.setY(rset2.getInt("locy"));
                                spawnDat.setZ(rset2.getInt("locz"));
                                spawnDat.setHeading(rset2.getInt("heading"));
                                spawnDat.setRespawnDelay(rset2.getInt("respawn_delay"));
                                dukeFinalSpawns.add((Object)spawnDat);
                                ++loaded;
                                continue;
                            }
                            _log.warning("FourSepulchersManager.LoadDukeMonsters: Data missing in NPC table for ID: " + rset2.getInt("npc_templateid") + ".");
                        }
                    }
                    ps2.clearParameters();
                    this._dukeFinalMobs.put(keyNpcId, (Object)dukeFinalSpawns);
                    this._archonSpawned.put(keyNpcId, false);
                }
            }
            _log.info(this.getClass().getSimpleName() + ": loaded " + loaded + " Church of duke monsters spawns.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "FourSepulchersManager.LoadDukeMonsters: Spawn could not be initialized: " + e.getMessage(), e);
        }
    }

    private void loadEmperorsGraveMonsters() {
        this._emperorsGraveNpcs.clear();
        int loaded = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");){
            ps1.setInt(1, 6);
            try (ResultSet rs1 = ps1.executeQuery();
                 PreparedStatement ps2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist WHERE key_npc_id = ? and spawntype = ? ORDER BY id");){
                while (rs1.next()) {
                    FastList _emperorsGraveSpawns = new FastList();
                    int keyNpcId = rs1.getInt("key_npc_id");
                    ps2.setInt(1, keyNpcId);
                    ps2.setInt(2, 6);
                    try (ResultSet rs2 = ps2.executeQuery();){
                        while (rs2.next()) {
                            L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rs2.getInt("npc_templateid"));
                            if (template1 != null) {
                                L2Spawn spawnDat = new L2Spawn(template1);
                                spawnDat.setAmount(rs2.getInt("count"));
                                spawnDat.setX(rs2.getInt("locx"));
                                spawnDat.setY(rs2.getInt("locy"));
                                spawnDat.setZ(rs2.getInt("locz"));
                                spawnDat.setHeading(rs2.getInt("heading"));
                                spawnDat.setRespawnDelay(rs2.getInt("respawn_delay"));
                                _emperorsGraveSpawns.add((Object)spawnDat);
                                ++loaded;
                                continue;
                            }
                            _log.warning("FourSepulchersManager.LoadEmperorsGraveMonsters: Data missing in NPC table for ID: " + rs2.getInt("npc_templateid") + ".");
                        }
                    }
                    ps2.clearParameters();
                    this._emperorsGraveNpcs.put(keyNpcId, (Object)_emperorsGraveSpawns);
                }
            }
            _log.info(this.getClass().getSimpleName() + ": loaded " + loaded + " Emperor's grave NPC spawns.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "FourSepulchersManager.LoadEmperorsGraveMonsters: Spawn could not be initialized: " + e.getMessage(), e);
        }
    }

    private static void shuffle(int[] array) {
        int i = array.length;
        while (--i > 0) {
            int j = Rnd.get(i);
            int swap = array[i];
            array[i] = array[j];
            array[j] = swap;
        }
    }

    protected void initLocationShadowSpawns() {
        this._shadowSpawns.clear();
        FourSepulchersManager.shuffle(this.SHADOW_OF_HALISHA);
        for (int i = 0; i < 4; ++i) {
            int keyNpcId = this.DUKES_HALL_GATEKEEPER[i];
            int spawnNpcId = this.SHADOW_OF_HALISHA[i];
            Location loc = this.SHADOW_SPAWN[i];
            L2NpcTemplate template = NpcTable.getInstance().getTemplate(spawnNpcId);
            if (template != null) {
                try {
                    L2Spawn spawnDat = new L2Spawn(template);
                    spawnDat.setAmount(1);
                    spawnDat.setXYZ(loc.getX(), loc.getY(), loc.getZ());
                    spawnDat.setHeading(loc.getHeading());
                    this._shadowSpawns.put(keyNpcId, (Object)spawnDat);
                }
                catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                    _log.log(Level.SEVERE, "Error on InitLocationShadowSpawns", e);
                }
                continue;
            }
            _log.warning("FourSepulchersManager.InitLocationShadowSpawns: Data missing in NPC table for ID: " + spawnNpcId + ".");
        }
    }

    protected void initExecutionerSpawns() {
        for (int spawnNpcId : this._victim.values()) {
            try {
                L2NpcTemplate template = NpcTable.getInstance().getTemplate(spawnNpcId);
                if (template == null) {
                    throw new AssertionError();
                }
                new L2Spawn(template);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "FourSepulchersManager.InitExecutionerSpawns: Spawn could not be initialized: " + e.getMessage(), e);
            }
        }
    }

    public void setChangePeriodTask(ScheduledFuture<?> task) {
        this._changePeriodTask = task;
    }

    public void setAttackTimeStart(long attackTimeStart) {
        this._attackTimeStart = attackTimeStart;
    }

    public long getAttackTimeStart() {
        return this._attackTimeStart;
    }

    public boolean isAttackTime() {
        return this._currentPeriod == FourSepulchersPeriod.ATTACK;
    }

    public void setAttackTime() {
        this._currentPeriod = FourSepulchersPeriod.ATTACK;
    }

    public boolean isCoolDownTime() {
        return this._currentPeriod == FourSepulchersPeriod.COOL_DOWN;
    }

    public void setCoolDownTime() {
        this._currentPeriod = FourSepulchersPeriod.COOL_DOWN;
    }

    public boolean isEntryTime() {
        return this._currentPeriod == FourSepulchersPeriod.ENTRY;
    }

    public void setEntryTime() {
        this._currentPeriod = FourSepulchersPeriod.ENTRY;
    }

    public boolean isWarmUpTime() {
        return this._currentPeriod == FourSepulchersPeriod.WARM_UP;
    }

    public void setWarmUpTime() {
        this._currentPeriod = FourSepulchersPeriod.WARM_UP;
    }

    public synchronized void tryEntry(L2Npc npc, L2PcInstance player) {
        Quest hostQuest = QuestManager.getInstance().getQuest(620);
        if (hostQuest == null) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Couldn't find quest: " + 620);
            return;
        }
        int npcId = npc.getId();
        switch (npcId) {
            case 31921: 
            case 31922: 
            case 31923: 
            case 31924: {
                break;
            }
            default: {
                if (!player.isGM()) {
                    _log.warning("Player " + player.getName() + "(" + player.getObjectId() + ") tried to cheat in four sepulchers.");
                    Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " tried to enter four sepulchers with invalid npc id.", Config.DEFAULT_PUNISH);
                }
                return;
            }
        }
        if (this._hallInUse.get(npcId)) {
            this.showHtmlFile(player, npcId + "-FULL.htm", npc, null);
            return;
        }
        if (Config.FS_PARTY_MEMBER_COUNT > 1) {
            if (!player.isInParty() || player.getParty().getMemberCount() < Config.FS_PARTY_MEMBER_COUNT) {
                this.showHtmlFile(player, npcId + "-SP.htm", npc, null);
                return;
            }
            if (!player.getParty().isLeader(player)) {
                this.showHtmlFile(player, npcId + "-NL.htm", npc, null);
                return;
            }
            for (L2PcInstance mem : player.getParty().getMembers()) {
                QuestState qs = mem.getQuestState(hostQuest.getName());
                if (qs == null || !qs.isStarted() && !qs.isCompleted()) {
                    this.showHtmlFile(player, npcId + "-NS.htm", npc, mem);
                    return;
                }
                if (mem.getInventory().getItemByItemId(7075) == null) {
                    this.showHtmlFile(player, npcId + "-SE.htm", npc, mem);
                    return;
                }
                if (player.getWeightPenalty() < 3) continue;
                mem.sendPacket(SystemMessageId.INVENTORY_LESS_THAN_80_PERCENT);
                return;
            }
        } else if (Config.FS_PARTY_MEMBER_COUNT <= 1 && player.isInParty()) {
            if (!player.getParty().isLeader(player)) {
                this.showHtmlFile(player, npcId + "-NL.htm", npc, null);
                return;
            }
            for (L2PcInstance mem : player.getParty().getMembers()) {
                QuestState qs = mem.getQuestState(hostQuest.getName());
                if (qs == null || !qs.isStarted() && !qs.isCompleted()) {
                    this.showHtmlFile(player, npcId + "-NS.htm", npc, mem);
                    return;
                }
                if (mem.getInventory().getItemByItemId(7075) == null) {
                    this.showHtmlFile(player, npcId + "-SE.htm", npc, mem);
                    return;
                }
                if (player.getWeightPenalty() < 3) continue;
                mem.sendPacket(SystemMessageId.INVENTORY_LESS_THAN_80_PERCENT);
                return;
            }
        } else {
            QuestState qs = player.getQuestState(hostQuest.getName());
            if (qs == null || !qs.isStarted() && !qs.isCompleted()) {
                this.showHtmlFile(player, npcId + "-NS.htm", npc, player);
                return;
            }
            if (player.getInventory().getItemByItemId(7075) == null) {
                this.showHtmlFile(player, npcId + "-SE.htm", npc, player);
                return;
            }
            if (player.getWeightPenalty() >= 3) {
                player.sendPacket(SystemMessageId.INVENTORY_LESS_THAN_80_PERCENT);
                return;
            }
        }
        if (!this.isEntryTime()) {
            this.showHtmlFile(player, npcId + "-NE.htm", npc, null);
            return;
        }
        this.showHtmlFile(player, npcId + "-OK.htm", npc, null);
        this.entry(npcId, player);
    }

    private void entry(int npcId, L2PcInstance player) {
        L2ItemInstance hallsKey;
        int drifty;
        int driftx;
        FastList members;
        Location location = (Location)this._startHallSpawns.get(npcId);
        if (Config.FS_PARTY_MEMBER_COUNT > 1) {
            members = new FastList();
            for (L2PcInstance mem : player.getParty().getMembers()) {
                if (mem.isDead() || !Util.checkIfInRange(700, player, mem, true)) continue;
                members.add((Object)mem);
            }
            for (L2PcInstance mem : members) {
                GrandBossManager.getInstance().getZone(location.getX(), location.getY(), location.getZ()).allowPlayerEntry(mem, 30);
                driftx = Rnd.get(-80, 80);
                drifty = Rnd.get(-80, 80);
                mem.teleToLocation(location.getX() + driftx, location.getY() + drifty, location.getZ());
                mem.destroyItemByItemId("Quest", 7075, 1L, mem, true);
                if (mem.getInventory().getItemByItemId(7262) == null) {
                    mem.addItem("Quest", 7261, 1L, mem, true);
                }
                if ((hallsKey = mem.getInventory().getItemByItemId(7260)) == null) continue;
                mem.destroyItemByItemId("Quest", 7260, hallsKey.getCount(), mem, true);
            }
            this._hallInUse.put(npcId, true);
        }
        if (Config.FS_PARTY_MEMBER_COUNT <= 1 && player.isInParty()) {
            members = new FastList();
            for (L2PcInstance mem : player.getParty().getMembers()) {
                if (mem.isDead() || !Util.checkIfInRange(700, player, mem, true)) continue;
                members.add((Object)mem);
            }
            for (L2PcInstance mem : members) {
                GrandBossManager.getInstance().getZone(location.getX(), location.getY(), location.getZ()).allowPlayerEntry(mem, 30);
                driftx = Rnd.get(-80, 80);
                drifty = Rnd.get(-80, 80);
                mem.teleToLocation(location.getX() + driftx, location.getY() + drifty, location.getZ());
                mem.destroyItemByItemId("Quest", 7075, 1L, mem, true);
                if (mem.getInventory().getItemByItemId(7262) == null) {
                    mem.addItem("Quest", 7261, 1L, mem, true);
                }
                if ((hallsKey = mem.getInventory().getItemByItemId(7260)) == null) continue;
                mem.destroyItemByItemId("Quest", 7260, hallsKey.getCount(), mem, true);
            }
            this._hallInUse.put(npcId, true);
        } else {
            L2ItemInstance hallsKey2;
            GrandBossManager.getInstance().getZone(location.getX(), location.getY(), location.getZ()).allowPlayerEntry(player, 30);
            int driftx2 = Rnd.get(-80, 80);
            int drifty2 = Rnd.get(-80, 80);
            player.teleToLocation(location.getX() + driftx2, location.getY() + drifty2, location.getZ());
            player.destroyItemByItemId("Quest", 7075, 1L, player, true);
            if (player.getInventory().getItemByItemId(7262) == null) {
                player.addItem("Quest", 7261, 1L, player, true);
            }
            if ((hallsKey2 = player.getInventory().getItemByItemId(7260)) != null) {
                player.destroyItemByItemId("Quest", 7260, hallsKey2.getCount(), player, true);
            }
            this._hallInUse.put(npcId, true);
        }
    }

    public void spawnMysteriousBox(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        L2Spawn spawnDat = (L2Spawn)this._mysteriousBoxSpawns.get(npcId);
        if (spawnDat != null) {
            this._allMobs.add((Object)spawnDat.doSpawn());
            spawnDat.stopRespawn();
        }
    }

    public void spawnMonster(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        FastList mobs = new FastList();
        FastList monsterList = Rnd.get(2) == 0 ? (FastList)this._physicalMonsters.get(npcId) : (FastList)this._magicalMonsters.get(npcId);
        if (monsterList != null) {
            boolean spawnKeyBoxMob = false;
            boolean spawnedKeyBoxMob = false;
            for (L2Spawn spawnDat : monsterList) {
                if (spawnedKeyBoxMob) {
                    spawnKeyBoxMob = false;
                } else {
                    switch (npcId) {
                        case 31469: 
                        case 31474: 
                        case 31479: 
                        case 31484: {
                            if (Rnd.get(48) != 0) break;
                            spawnKeyBoxMob = true;
                            break;
                        }
                        default: {
                            spawnKeyBoxMob = false;
                        }
                    }
                }
                L2SepulcherMonsterInstance mob = null;
                if (spawnKeyBoxMob) {
                    try {
                        L2NpcTemplate template = NpcTable.getInstance().getTemplate(18149);
                        if (template != null) {
                            L2Spawn keyBoxMobSpawn = new L2Spawn(template);
                            keyBoxMobSpawn.setAmount(1);
                            keyBoxMobSpawn.setLocation(spawnDat.getLocation());
                            keyBoxMobSpawn.setRespawnDelay(3600);
                            mob = (L2SepulcherMonsterInstance)keyBoxMobSpawn.doSpawn();
                            keyBoxMobSpawn.stopRespawn();
                        } else {
                            _log.warning("FourSepulchersManager.SpawnMonster: Data missing in NPC table for ID: 18149");
                        }
                    }
                    catch (Exception e) {
                        _log.log(Level.WARNING, "FourSepulchersManager.SpawnMonster: Spawn could not be initialized: " + e.getMessage(), e);
                    }
                    spawnedKeyBoxMob = true;
                } else {
                    mob = (L2SepulcherMonsterInstance)spawnDat.doSpawn();
                    spawnDat.stopRespawn();
                }
                if (mob == null) continue;
                mob.mysteriousBoxId = npcId;
                switch (npcId) {
                    case 31469: 
                    case 31472: 
                    case 31474: 
                    case 31477: 
                    case 31479: 
                    case 31482: 
                    case 31484: 
                    case 31487: {
                        mobs.add((Object)mob);
                    }
                }
                this._allMobs.add((Object)mob);
            }
            switch (npcId) {
                case 31469: 
                case 31474: 
                case 31479: 
                case 31484: {
                    this._viscountMobs.put(npcId, (Object)mobs);
                    break;
                }
                case 31472: 
                case 31477: 
                case 31482: 
                case 31487: {
                    this._dukeMobs.put(npcId, (Object)mobs);
                }
            }
        }
    }

    public synchronized boolean isViscountMobsAnnihilated(int npcId) {
        FastList mobs = (FastList)this._viscountMobs.get(npcId);
        if (mobs == null) {
            return true;
        }
        for (L2SepulcherMonsterInstance mob : mobs) {
            if (mob.isDead()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean isDukeMobsAnnihilated(int npcId) {
        FastList mobs = (FastList)this._dukeMobs.get(npcId);
        if (mobs == null) {
            return true;
        }
        for (L2SepulcherMonsterInstance mob : mobs) {
            if (mob.isDead()) continue;
            return false;
        }
        return true;
    }

    public void spawnKeyBox(L2Npc activeChar) {
        if (!this.isAttackTime()) {
            return;
        }
        int keyNpcId = activeChar.getId();
        int spawnNpcId = this._keyBoxNpc.get(keyNpcId);
        try {
            L2NpcTemplate template = NpcTable.getInstance().getTemplate(spawnNpcId);
            if (template == null) {
                throw new AssertionError();
            }
            L2Spawn spawnDat = new L2Spawn(template);
            spawnDat.setAmount(1);
            spawnDat.setXYZ(activeChar.getX(), activeChar.getY(), activeChar.getZ());
            spawnDat.setHeading(activeChar.getHeading());
            spawnDat.setRespawnDelay(3600);
            this._allMobs.add((Object)spawnDat.doSpawn());
            spawnDat.stopRespawn();
        }
        catch (Exception e) {
            _log.warning("FourSepulchersManager.spawnKeyBox(" + keyNpcId + "): Data missing in NPC table for ID: " + spawnNpcId + ".");
        }
    }

    public void spawnExecutionerOfHalisha(L2Npc activeChar) {
        if (!this.isAttackTime()) {
            return;
        }
        int keyNpcId = activeChar.getId();
        int spawnNpcId = this._victim.get(keyNpcId);
        try {
            L2NpcTemplate template = NpcTable.getInstance().getTemplate(spawnNpcId);
            if (template == null) {
                throw new AssertionError();
            }
            L2Spawn spawnDat = new L2Spawn(template);
            spawnDat.setAmount(1);
            spawnDat.setXYZ(activeChar.getX(), activeChar.getY(), activeChar.getZ());
            spawnDat.setHeading(activeChar.getHeading());
            spawnDat.setRespawnDelay(3600);
            this._allMobs.add((Object)spawnDat.doSpawn());
            spawnDat.stopRespawn();
        }
        catch (Exception e) {
            _log.warning("FourSepulchersManager.spawnExecutionerOfHalisha(" + keyNpcId + "): Data missing in NPC table for ID: " + spawnNpcId + ".");
        }
    }

    public void spawnArchonOfHalisha(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        if (this._archonSpawned.get(npcId)) {
            return;
        }
        FastList monsterList = (FastList)this._dukeFinalMobs.get(npcId);
        if (monsterList != null) {
            for (L2Spawn spawnDat : monsterList) {
                L2SepulcherMonsterInstance mob = (L2SepulcherMonsterInstance)spawnDat.doSpawn();
                spawnDat.stopRespawn();
                if (mob == null) continue;
                mob.mysteriousBoxId = npcId;
                this._allMobs.add((Object)mob);
            }
            this._archonSpawned.put(npcId, true);
        }
    }

    public void spawnEmperorsGraveNpc(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        FastList monsterList = (FastList)this._emperorsGraveNpcs.get(npcId);
        if (monsterList != null) {
            for (L2Spawn spawnDat : monsterList) {
                this._allMobs.add((Object)spawnDat.doSpawn());
                spawnDat.stopRespawn();
            }
        }
    }

    public void locationShadowSpawns() {
        this.initLocationShadowSpawns();
    }

    public void spawnShadow(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        L2Spawn spawnDat = (L2Spawn)this._shadowSpawns.get(npcId);
        if (spawnDat != null) {
            L2SepulcherMonsterInstance mob = (L2SepulcherMonsterInstance)spawnDat.doSpawn();
            spawnDat.stopRespawn();
            if (mob != null) {
                mob.mysteriousBoxId = npcId;
                this._allMobs.add((Object)mob);
            }
        }
    }

    public void deleteAllMobs() {
        for (L2Npc mob : this._allMobs) {
            if (mob == null) continue;
            try {
                if (mob.getSpawn() != null) {
                    mob.getSpawn().stopRespawn();
                }
                mob.deleteMe();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed deleting mob.", e);
            }
        }
        this._allMobs.clear();
    }

    protected void closeAllDoors() {
        for (int doorId : this._hallGateKeepers.values()) {
            try {
                L2DoorInstance door = DoorTable.getInstance().getDoor(doorId);
                if (door != null) {
                    door.closeMe();
                    continue;
                }
                _log.warning(this.getClass().getSimpleName() + ": Attempted to close undefined door. doorId: " + doorId);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed closing door", e);
            }
        }
    }

    public void managerSay(int min) {
        block8: {
            block7: {
                if (!this.isAttackTime()) break block7;
                if (min < 5) {
                    return;
                }
                String msg = (min = (min + 2) / 5 * 5) >= Config.FS_TIME_ATTACK ? "\u30b2\u30fc\u30e0\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002\u9593\u3082\u306a\u304f\u81ea\u52d5\u30c6\u30ec\u30dd\u30fc\u30c8\u3057\u307e\u3059\u3002" : "\u73fe\u5728" + min + "\u5206\u304c\u7d4c\u904e\u3057\u307e\u3057\u305f";
                for (L2Spawn temp : this._managers) {
                    if (temp == null) {
                        _log.warning(this.getClass().getSimpleName() + ": managerSay(): manager is null");
                        continue;
                    }
                    if (!(temp.getLastSpawn() instanceof L2SepulcherNpcInstance)) {
                        _log.warning(this.getClass().getSimpleName() + ": managerSay(): manager is not Sepulcher instance");
                        continue;
                    }
                    if (!this._hallInUse.get(temp.getId())) continue;
                    ((L2SepulcherNpcInstance)temp.getLastSpawn()).sayInShout(msg);
                }
                break block8;
            }
            if (!this.isEntryTime()) break block8;
            NpcStringId msg1 = NpcStringId.YOU_MAY_NOW_ENTER_THE_SEPULCHER;
            NpcStringId msg2 = NpcStringId.IF_YOU_PLACE_YOUR_HAND_ON_THE_STONE_STATUE_IN_FRONT_OF_EACH_SEPULCHER_YOU_WILL_BE_ABLE_TO_ENTER;
            for (L2Spawn temp : this._managers) {
                if (temp == null) {
                    _log.warning(this.getClass().getSimpleName() + ": Something goes wrong in managerSay()...");
                    continue;
                }
                if (!(temp.getLastSpawn() instanceof L2SepulcherNpcInstance)) {
                    _log.warning(this.getClass().getSimpleName() + ": Something goes wrong in managerSay()...");
                    continue;
                }
                ((L2SepulcherNpcInstance)temp.getLastSpawn()).sayInShout(msg1);
                ((L2SepulcherNpcInstance)temp.getLastSpawn()).sayInShout(msg2);
            }
        }
    }

    public SortedIntIntArrayMap getHallGateKeepers() {
        return this._hallGateKeepers;
    }

    public void showHtmlFile(L2PcInstance player, String file, L2Npc npc, L2PcInstance member) {
        NpcHtmlMessage html = new NpcHtmlMessage(npc.getObjectId());
        html.setFile(player.getHtmlPrefix(), "data/html/SepulcherNpc/" + file);
        if (member != null) {
            html.replace((CharSequence)"%member%", member.getName());
        }
        player.sendPacket(html);
    }

    @Override
    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (command.equals("admin_FourSepulchers")) {
            ScheduledFuture<?> task;
            if (this.isWarmUpTime()) {
                activeChar.sendMessage("FourSepulchersManager: In Warm-Up Time");
                task = this._changePeriodTask;
                if (task != null) {
                    task.cancel(false);
                }
                this.setAttackTime();
            }
            if (this.isAttackTime()) {
                activeChar.sendMessage("FourSepulchersManager: In Attack Time");
                task = this._changePeriodTask;
                if (task != null) {
                    task.cancel(false);
                }
                new FourSepulchersChangeCoolDownTimeTask().run();
            }
            if (this.isCoolDownTime()) {
                activeChar.sendMessage("FourSepulchersManager: In Cool-Down Time");
                task = this._changePeriodTask;
                if (task != null) {
                    task.cancel(false);
                }
                new FourSepulchersChangeEntryTimeTask().run();
            }
            if (this.isEntryTime()) {
                activeChar.sendMessage("FourSepulchersManager: In Entry Time");
            }
        }
        return true;
    }

    @Override
    public String[] getAdminCommandList() {
        _log.info("FourSepulchersManager: Implements admin command //FourSepulchers");
        return new String[]{"admin_FourSepulchers"};
    }

    public static final FourSepulchersManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final FourSepulchersManager _instance = new FourSepulchersManager();

        private SingletonHolder() {
        }
    }

    private static enum FourSepulchersPeriod {
        COOL_DOWN,
        ENTRY,
        WARM_UP,
        ATTACK;

    }
}

