/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2TeleportLocation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TeleportLocationTable {
    private static Logger _log = Logger.getLogger(TeleportLocationTable.class.getName());
    private final Map<Integer, L2TeleportLocation> _teleports = new HashMap<Integer, L2TeleportLocation>();

    protected TeleportLocationTable() {
        this.reloadAll();
    }

    public void reloadAll() {
        this._teleports.clear();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT id, loc_x, loc_y, loc_z, price, fornoble, itemId FROM teleport");){
            while (rs.next()) {
                L2TeleportLocation teleport = new L2TeleportLocation();
                teleport.setTeleId(rs.getInt("id"));
                teleport.setLocX(rs.getInt("loc_x"));
                teleport.setLocY(rs.getInt("loc_y"));
                teleport.setLocZ(rs.getInt("loc_z"));
                teleport.setPrice(rs.getInt("price"));
                teleport.setIsForNoble(rs.getInt("fornoble") == 1);
                teleport.setItemId(rs.getInt("itemId"));
                this._teleports.put(teleport.getTeleId(), teleport);
            }
            _log.info(this.getClass().getSimpleName() + ": Loaded " + this._teleports.size() + " Teleport Location Templates.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error loading Teleport Table.", e);
        }
        if (Config.CUSTOM_TELEPORT_TABLE) {
            int _cTeleCount = this._teleports.size();
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 Statement s = con.createStatement();
                 ResultSet rs = s.executeQuery("SELECT id, loc_x, loc_y, loc_z, price, fornoble, itemId FROM custom_teleport");){
                while (rs.next()) {
                    L2TeleportLocation teleport = new L2TeleportLocation();
                    teleport.setTeleId(rs.getInt("id"));
                    teleport.setLocX(rs.getInt("loc_x"));
                    teleport.setLocY(rs.getInt("loc_y"));
                    teleport.setLocZ(rs.getInt("loc_z"));
                    teleport.setPrice(rs.getInt("price"));
                    teleport.setIsForNoble(rs.getInt("fornoble") == 1);
                    teleport.setItemId(rs.getInt("itemId"));
                    this._teleports.put(teleport.getTeleId(), teleport);
                }
                _cTeleCount = this._teleports.size() - _cTeleCount;
                if (_cTeleCount > 0) {
                    _log.info(this.getClass().getSimpleName() + ": Loaded " + _cTeleCount + " Custom Teleport Location Templates.");
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error while creating custom teleport table " + e.getMessage(), e);
            }
        }
    }

    public L2TeleportLocation getTemplate(int id) {
        return this._teleports.get(id);
    }

    public static TeleportLocationTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final TeleportLocationTable _instance = new TeleportLocationTable();

        private SingletonHolder() {
        }
    }
}

