/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SummonSkillsTable {
    private static Logger _log = Logger.getLogger(SummonSkillsTable.class.getName());
    private final Map<Integer, Map<Integer, L2PetSkillLearn>> _skillTrees = new HashMap<Integer, Map<Integer, L2PetSkillLearn>>();

    protected SummonSkillsTable() {
        this.load();
    }

    public void load() {
        long started = System.currentTimeMillis();
        this._skillTrees.clear();
        int npcId = 0;
        int count = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT id FROM npc WHERE type IN ('L2Pet','L2BabyPet','L2SiegeSummon') ORDER BY id");
             PreparedStatement ps2 = con.prepareStatement("SELECT minLvl, skillId, skillLvl FROM pets_skills where templateId=? ORDER BY skillId, skillLvl");){
            while (rs.next()) {
                HashMap<Integer, L2PetSkillLearn> map = new HashMap<Integer, L2PetSkillLearn>();
                npcId = rs.getInt("id");
                ps2.setInt(1, npcId);
                try (ResultSet skilltree = ps2.executeQuery();){
                    while (skilltree.next()) {
                        int id = skilltree.getInt("skillId");
                        int lvl = skilltree.getInt("skillLvl");
                        map.put(SkillTable.getSkillHashCode(id, lvl + 1), new L2PetSkillLearn(id, lvl, skilltree.getInt("minLvl")));
                    }
                    this._skillTrees.put(npcId, map);
                }
                ps2.clearParameters();
                count += map.size();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error while creating pet skill tree (Pet ID " + npcId + "): " + e.getMessage(), e);
        }
        _log.info(this.getClass().getSimpleName() + ": Loaded " + count + " skills. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
    }

    public int getAvailableLevel(L2Summon cha, int skillId) {
        int lvl = 0;
        if (!this._skillTrees.containsKey(cha.getId())) {
            _log.warning(this.getClass().getSimpleName() + ": Pet id " + cha.getId() + " does not have any skills assigned.");
            return lvl;
        }
        Collection<L2PetSkillLearn> skills = this._skillTrees.get(cha.getId()).values();
        for (L2PetSkillLearn temp : skills) {
            if (temp.getId() != skillId) continue;
            if (temp.getLevel() == 0) {
                int maxLvl;
                if (cha.getLevel() < 70) {
                    lvl = cha.getLevel() / 10;
                    if (lvl <= 0) {
                        lvl = 1;
                    }
                } else {
                    lvl = 7 + (cha.getLevel() - 70) / 5;
                }
                if (lvl <= (maxLvl = SkillTable.getInstance().getMaxLevel(temp.getId()))) break;
                lvl = maxLvl;
                break;
            }
            if (temp.getMinLevel() > cha.getLevel() || temp.getLevel() <= lvl) continue;
            lvl = temp.getLevel();
        }
        return lvl;
    }

    public List<Integer> getAvailableSkills(L2Summon cha) {
        ArrayList<Integer> skillIds = new ArrayList<Integer>();
        if (!this._skillTrees.containsKey(cha.getId())) {
            _log.warning(this.getClass().getSimpleName() + ": Pet id " + cha.getId() + " does not have any skills assigned.");
            return skillIds;
        }
        Collection<L2PetSkillLearn> skills = this._skillTrees.get(cha.getId()).values();
        for (L2PetSkillLearn temp : skills) {
            if (skillIds.contains(temp.getId())) continue;
            skillIds.add(temp.getId());
        }
        return skillIds;
    }

    public static SummonSkillsTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SummonSkillsTable _instance = new SummonSkillsTable();

        private SingletonHolder() {
        }
    }

    public static final class L2PetSkillLearn {
        private final int _id;
        private final int _level;
        private final int _minLevel;

        public L2PetSkillLearn(int id, int lvl, int minLvl) {
            this._id = id;
            this._level = lvl;
            this._minLevel = minLvl;
        }

        public int getId() {
            return this._id;
        }

        public int getLevel() {
            return this._level;
        }

        public int getMinLevel() {
            return this._minLevel;
        }
    }
}

