/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.engines.DocumentEngine;
import com.l2jserver.gameserver.model.skills.L2Skill;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class SkillTable {
    private static Logger _log = Logger.getLogger(SkillTable.class.getName());
    private FastIntObjectMap<L2Skill> _skills;
    private TIntIntHashMap _skillMaxLevel;
    private TIntArrayList _enchantable;
    public static final int PRIME = 1021;

    protected SkillTable() {
        this.load();
    }

    public void reload() {
        this.load();
        SkillTreesData.getInstance().load();
    }

    private void load() {
        FastIntObjectMap _skills = new FastIntObjectMap();
        TIntIntHashMap _skillMaxLevel = new TIntIntHashMap();
        TIntArrayList _enchantable = new TIntArrayList();
        _skills.clear();
        DocumentEngine.getInstance().loadAllSkills((FastIntObjectMap<L2Skill>)_skills);
        _skillMaxLevel.clear();
        for (L2Skill skill : _skills.values()) {
            int skillId = skill.getId();
            int skillLvl = skill.getLevel();
            if (skillLvl > 99) {
                if (_enchantable.contains(skillId)) continue;
                _enchantable.add(skillId);
                continue;
            }
            int maxLvl = _skillMaxLevel.get(skillId);
            if (skillLvl <= maxLvl) continue;
            _skillMaxLevel.put(skillId, skillLvl);
        }
        _enchantable.sort();
        _skillMaxLevel.trimToSize();
        _enchantable.trimToSize();
        this._skills = _skills;
        this._skillMaxLevel = _skillMaxLevel;
        this._enchantable = _enchantable;
    }

    public static int getSkillHashCode(L2Skill skill) {
        return SkillTable.getSkillHashCode(skill.getId(), skill.getLevel());
    }

    public static int getSkillHashCode(int skillId, int skillLevel) {
        return skillId * 1021 + skillLevel;
    }

    public static int getSkillId(int skillHashCode) {
        return skillHashCode / 1021;
    }

    public static int getSkillLevel(int skillHashCode) {
        return skillHashCode % 1021;
    }

    public static L2Skill getSkill(int skillHashCode) {
        return (L2Skill)SkillTable.getInstance()._skills.get(skillHashCode);
    }

    @Deprecated
    public final L2Skill getInfo(int skillHashCode) {
        return (L2Skill)this._skills.get(skillHashCode);
    }

    public L2Skill getInfo(int skillId, int level) {
        L2Skill result = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(skillId, level));
        if (result != null) {
            return result;
        }
        int maxLvl = this._skillMaxLevel.get(skillId);
        if (maxLvl > 0 && level > maxLvl) {
            if (Config.DEBUG) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": call to unexisting skill level id: " + skillId + " requested level: " + level + " max level: " + maxLvl, new Throwable());
            }
            return (L2Skill)this._skills.get(SkillTable.getSkillHashCode(skillId, maxLvl));
        }
        _log.warning(this.getClass().getSimpleName() + ": No skill info found for skill id " + skillId + " and skill level " + level + ".");
        return null;
    }

    public int getMaxLevel(int skillId) {
        return this._skillMaxLevel.get(skillId);
    }

    public boolean isEnchantable(int skillId) {
        return this._enchantable.binarySearch(skillId) >= 0;
    }

    public L2Skill[] getSiegeSkills(boolean addNoble, boolean hasCastle) {
        L2Skill[] temp = new L2Skill[2 + (addNoble ? 1 : 0) + (hasCastle ? 2 : 0)];
        int i = 0;
        temp[i++] = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(246, 1));
        temp[i++] = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(247, 1));
        if (addNoble) {
            temp[i++] = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(326, 1));
        }
        if (hasCastle) {
            temp[i++] = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(844, 1));
            temp[i++] = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(845, 1));
        }
        return temp;
    }

    public static SkillTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SkillTable _instance = new SkillTable();

        private SingletonHolder() {
        }
    }

    public static enum FrequentSkill {
        RAID_CURSE(4215, 1),
        RAID_CURSE2(4515, 1),
        SEAL_OF_RULER(246, 1),
        BUILD_HEADQUARTERS(247, 1),
        WYVERN_BREATH(4289, 1),
        STRIDER_SIEGE_ASSAULT(325, 1),
        FIREWORK(5965, 1),
        LARGE_FIREWORK(2025, 1),
        BLESSING_OF_PROTECTION(5182, 1),
        VOID_BURST(3630, 1),
        VOID_FLOW(3631, 1),
        THE_VICTOR_OF_WAR(5074, 1),
        THE_VANQUISHED_OF_WAR(5075, 1),
        SPECIAL_TREE_RECOVERY_BONUS(2139, 1),
        WEAPON_GRADE_PENALTY(6209, 1),
        ARMOR_GRADE_PENALTY(6213, 1);

        private final int _skillHashCode;

        private FrequentSkill(int id, int level) {
            this._skillHashCode = SkillTable.getSkillHashCode(id, level);
        }

        public int getId() {
            return SkillTable.getSkillId(this._skillHashCode);
        }

        public int getLevel() {
            return SkillTable.getSkillLevel(this._skillHashCode);
        }

        public L2Skill getSkill() {
            return SkillTable.getSkill(this._skillHashCode);
        }
    }
}

