/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.L2RecipeInstance;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.L2RecipeStatInstance;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RecipeData
extends DocumentParser {
    private static final Map<Integer, L2RecipeList> _recipes = new HashMap<Integer, L2RecipeList>();

    protected RecipeData() {
        this.load();
    }

    @Override
    public void load() {
        _recipes.clear();
        this.parseDatapackFile("data/recipes.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _recipes.size() + " recipes.");
    }

    @Override
    protected void parseDocument() {
        ArrayList<L2RecipeInstance> recipePartList = new ArrayList<L2RecipeInstance>();
        ArrayList<L2RecipeStatInstance> recipeStatUseList = new ArrayList<L2RecipeStatInstance>();
        ArrayList<L2RecipeStatInstance> recipeAltStatChangeList = new ArrayList<L2RecipeStatInstance>();
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            block5: for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"item".equalsIgnoreCase(d.getNodeName())) continue;
                recipePartList.clear();
                recipeStatUseList.clear();
                recipeAltStatChangeList.clear();
                NamedNodeMap attrs = d.getAttributes();
                int id = -1;
                boolean haveRare = false;
                StatsSet set = new StatsSet();
                Node att = attrs.getNamedItem("id");
                if (att == null) {
                    this._log.severe(this.getClass().getSimpleName() + ": Missing id for recipe item, skipping");
                    continue;
                }
                id = Integer.parseInt(att.getNodeValue());
                set.set("id", id);
                att = attrs.getNamedItem("recipeId");
                if (att == null) {
                    this._log.severe(this.getClass().getSimpleName() + ": Missing recipeId for recipe item id: " + id + ", skipping");
                    continue;
                }
                set.set("recipeId", Integer.parseInt(att.getNodeValue()));
                att = attrs.getNamedItem("name");
                if (att == null) {
                    this._log.severe(this.getClass().getSimpleName() + ": Missing name for recipe item id: " + id + ", skipping");
                    continue;
                }
                set.set("recipeName", att.getNodeValue());
                att = attrs.getNamedItem("craftLevel");
                if (att == null) {
                    this._log.severe(this.getClass().getSimpleName() + ": Missing level for recipe item id: " + id + ", skipping");
                    continue;
                }
                set.set("craftLevel", Integer.parseInt(att.getNodeValue()));
                att = attrs.getNamedItem("type");
                if (att == null) {
                    this._log.severe(this.getClass().getSimpleName() + ": Missing type for recipe item id: " + id + ", skipping");
                    continue;
                }
                set.set("isDwarvenRecipe", att.getNodeValue().equalsIgnoreCase("dwarven"));
                att = attrs.getNamedItem("successRate");
                if (att == null) {
                    this._log.severe(this.getClass().getSimpleName() + ": Missing successRate for recipe item id: " + id + ", skipping");
                    continue;
                }
                set.set("successRate", Integer.parseInt(att.getNodeValue()));
                for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                    int value;
                    String statName;
                    if ("statUse".equalsIgnoreCase(c.getNodeName())) {
                        statName = c.getAttributes().getNamedItem("name").getNodeValue();
                        value = Integer.parseInt(c.getAttributes().getNamedItem("value").getNodeValue());
                        try {
                            recipeStatUseList.add(new L2RecipeStatInstance(statName, value));
                            continue;
                        }
                        catch (Exception e) {
                            this._log.severe(this.getClass().getSimpleName() + ": Error in StatUse parameter for recipe item id: " + id + ", skipping");
                            continue block5;
                        }
                    }
                    if ("altStatChange".equalsIgnoreCase(c.getNodeName())) {
                        statName = c.getAttributes().getNamedItem("name").getNodeValue();
                        value = Integer.parseInt(c.getAttributes().getNamedItem("value").getNodeValue());
                        try {
                            recipeAltStatChangeList.add(new L2RecipeStatInstance(statName, value));
                            continue;
                        }
                        catch (Exception e) {
                            this._log.severe(this.getClass().getSimpleName() + ": Error in AltStatChange parameter for recipe item id: " + id + ", skipping");
                            continue block5;
                        }
                    }
                    if ("ingredient".equalsIgnoreCase(c.getNodeName())) {
                        int ingId = Integer.parseInt(c.getAttributes().getNamedItem("id").getNodeValue());
                        int ingCount = Integer.parseInt(c.getAttributes().getNamedItem("count").getNodeValue());
                        recipePartList.add(new L2RecipeInstance(ingId, ingCount));
                        continue;
                    }
                    if ("production".equalsIgnoreCase(c.getNodeName())) {
                        set.set("itemId", Integer.parseInt(c.getAttributes().getNamedItem("id").getNodeValue()));
                        set.set("count", Integer.parseInt(c.getAttributes().getNamedItem("count").getNodeValue()));
                        continue;
                    }
                    if (!"productionRare".equalsIgnoreCase(c.getNodeName())) continue;
                    set.set("rareItemId", Integer.parseInt(c.getAttributes().getNamedItem("id").getNodeValue()));
                    set.set("rareCount", Integer.parseInt(c.getAttributes().getNamedItem("count").getNodeValue()));
                    set.set("rarity", Integer.parseInt(c.getAttributes().getNamedItem("rarity").getNodeValue()));
                    haveRare = true;
                }
                L2RecipeList recipeList = new L2RecipeList(set, haveRare);
                for (L2RecipeInstance recipePart : recipePartList) {
                    recipeList.addRecipe(recipePart);
                }
                for (L2RecipeStatInstance recipeStatUse : recipeStatUseList) {
                    recipeList.addStatUse(recipeStatUse);
                }
                for (L2RecipeStatInstance recipeAltStatChange : recipeAltStatChangeList) {
                    recipeList.addAltStatChange(recipeAltStatChange);
                }
                _recipes.put(id, recipeList);
            }
        }
    }

    public L2RecipeList getRecipeList(int listId) {
        return _recipes.get(listId);
    }

    public L2RecipeList getRecipeByItemId(int itemId) {
        for (L2RecipeList find : _recipes.values()) {
            if (find.getRecipeId() != itemId) continue;
            return find;
        }
        return null;
    }

    public int[] getAllItemIds() {
        int[] idList = new int[_recipes.size()];
        int i = 0;
        for (L2RecipeList rec : _recipes.values()) {
            idList[i++] = rec.getRecipeId();
        }
        return idList;
    }

    public L2RecipeList getValidRecipeList(L2PcInstance player, int id) {
        L2RecipeList recipeList = _recipes.get(id);
        if (recipeList == null || recipeList.getRecipes().length == 0) {
            player.sendMessage(this.getClass().getSimpleName() + ": No recipe for: " + id);
            player.isInCraftMode(false);
            return null;
        }
        return recipeList;
    }

    public static RecipeData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final RecipeData _instance = new RecipeData();

        private SingletonHolder() {
        }
    }
}

