/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public class NpcBufferTable {
    private static final Logger _log = Logger.getLogger(NpcBufferTable.class.getName());
    private final FastIntObjectMap<NpcBufferSkills> _buffers = new FastIntObjectMap();

    protected NpcBufferTable() {
        int buffGroup;
        int skillFeeAmount;
        int skillFeeId;
        int skillLevel;
        int skillId;
        int npcId;
        NpcBufferSkills skills;
        int lastNpcId;
        Throwable throwable;
        ResultSet rset;
        Throwable throwable2;
        Statement s;
        Throwable throwable3;
        Connection con;
        int skillCount = 0;
        try {
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            throwable3 = null;
            try {
                s = con.createStatement();
                throwable2 = null;
                try {
                    rset = s.executeQuery("SELECT `npc_id`,`skill_id`,`skill_level`,`skill_fee_id`,`skill_fee_amount`,`buff_group` FROM `npc_buffer` ORDER BY `npc_id` ASC");
                    throwable = null;
                    try {
                        lastNpcId = 0;
                        skills = null;
                        while (rset.next()) {
                            npcId = rset.getInt("npc_id");
                            skillId = rset.getInt("skill_id");
                            skillLevel = rset.getInt("skill_level");
                            skillFeeId = rset.getInt("skill_fee_id");
                            skillFeeAmount = rset.getInt("skill_fee_amount");
                            buffGroup = rset.getInt("buff_group");
                            if (npcId != lastNpcId) {
                                if (lastNpcId != 0) {
                                    this._buffers.put(lastNpcId, skills);
                                }
                                skills = new NpcBufferSkills(npcId);
                                skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                            } else if (skills != null) {
                                skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                            }
                            lastNpcId = npcId;
                            ++skillCount;
                        }
                        if (lastNpcId != 0) {
                            this._buffers.put(lastNpcId, skills);
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (rset != null) {
                            if (throwable != null) {
                                try {
                                    rset.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                rset.close();
                            }
                        }
                    }
                }
                catch (Throwable x2) {
                    throwable2 = x2;
                    throw x2;
                }
                finally {
                    if (s != null) {
                        if (throwable2 != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                        } else {
                            s.close();
                        }
                    }
                }
            }
            catch (Throwable x2) {
                throwable3 = x2;
                throw x2;
            }
            finally {
                if (con != null) {
                    if (throwable3 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable x2) {
                            throwable3.addSuppressed(x2);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading npc_buffer table: " + e.getMessage(), e);
        }
        if (Config.CUSTOM_NPCBUFFER_TABLES) {
            try {
                con = L2DatabaseFactory.getInstance().getConnectionFast();
                throwable3 = null;
                try {
                    s = con.createStatement();
                    throwable2 = null;
                    try {
                        rset = s.executeQuery("SELECT `npc_id`,`skill_id`,`skill_level`,`skill_fee_id`,`skill_fee_amount`,`buff_group` FROM `custom_npc_buffer` ORDER BY `npc_id` ASC");
                        throwable = null;
                        try {
                            lastNpcId = 0;
                            skills = null;
                            while (rset.next()) {
                                npcId = rset.getInt("npc_id");
                                skillId = rset.getInt("skill_id");
                                skillLevel = rset.getInt("skill_level");
                                skillFeeId = rset.getInt("skill_fee_id");
                                skillFeeAmount = rset.getInt("skill_fee_amount");
                                buffGroup = rset.getInt("buff_group");
                                if (npcId != lastNpcId) {
                                    if (lastNpcId != 0) {
                                        this._buffers.put(lastNpcId, (Object)skills);
                                    }
                                    skills = new NpcBufferSkills(npcId);
                                    skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                                } else if (skills != null) {
                                    skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                                }
                                lastNpcId = npcId;
                                ++skillCount;
                            }
                            if (lastNpcId != 0) {
                                this._buffers.put(lastNpcId, skills);
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (rset != null) {
                                if (throwable != null) {
                                    try {
                                        rset.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    rset.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (s != null) {
                            if (throwable2 != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable x2) {
                                    throwable2.addSuppressed(x2);
                                }
                            } else {
                                s.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (con != null) {
                        if (throwable3 != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable x2) {
                                throwable3.addSuppressed(x2);
                            }
                        } else {
                            con.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading custom_npc_buffer table: " + e.getMessage(), e);
            }
        }
        _log.info(this.getClass().getSimpleName() + ": Loaded " + this._buffers.size() + " buffers and " + skillCount + " skills.");
    }

    public NpcBufferData getSkillInfo(int npcId, int buffGroup) {
        NpcBufferSkills skills = (NpcBufferSkills)this._buffers.get(npcId);
        if (skills != null) {
            return skills.getSkillGroupInfo(buffGroup);
        }
        return null;
    }

    public static NpcBufferTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final NpcBufferTable _instance = new NpcBufferTable();

        private SingletonHolder() {
        }
    }

    private static class NpcBufferSkills {
        private final int _npcId;
        private final FastIntObjectMap<NpcBufferData> _skills = new FastIntObjectMap();

        protected NpcBufferSkills(int npcId) {
            this._npcId = npcId;
        }

        public void addSkill(int skillId, int skillLevel, int skillFeeId, int skillFeeAmount, int buffGroup) {
            this._skills.put(buffGroup, (Object)new NpcBufferData(skillId, skillLevel, skillFeeId, skillFeeAmount));
        }

        public NpcBufferData getSkillGroupInfo(int buffGroup) {
            return (NpcBufferData)this._skills.get(buffGroup);
        }

        public int getNpcId() {
            return this._npcId;
        }
    }

    public static class NpcBufferData {
        private final SkillHolder _skill;
        private final ItemHolder _fee;

        protected NpcBufferData(int skillId, int skillLevel, int feeId, int feeAmount) {
            this._skill = new SkillHolder(skillId, skillLevel);
            this._fee = new ItemHolder(feeId, feeAmount);
        }

        public SkillHolder getSkill() {
            return this._skill;
        }

        public ItemHolder getFee() {
            return this._fee;
        }
    }
}

