/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.L2Seed;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.items.L2Item;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ManorData
extends DocumentParser {
    private static Logger _log = Logger.getLogger(ManorData.class.getName());
    private static final HashMap<Integer, L2Seed> _seeds = new HashMap();

    protected ManorData() {
        this.load();
    }

    @Override
    public void load() {
        _seeds.clear();
        this.parseDatapackFile("data/seeds.xml");
        _log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + _seeds.size() + " seeds.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"castle".equalsIgnoreCase(d.getNodeName())) continue;
                int castleId = this.parseInteger(d.getAttributes(), "id");
                for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
                    if (!"crop".equalsIgnoreCase(c.getNodeName())) continue;
                    StatsSet set = new StatsSet();
                    set.set("castleId", castleId);
                    NamedNodeMap attrs = c.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node att = attrs.item(i);
                        set.set(att.getNodeName(), att.getNodeValue());
                    }
                    L2Seed seed = new L2Seed(set);
                    _seeds.put(seed.getSeedId(), seed);
                }
            }
        }
    }

    public List<Integer> getAllCrops() {
        ArrayList<Integer> crops = new ArrayList<Integer>();
        for (L2Seed seed : _seeds.values()) {
            if (crops.contains(seed.getCropId()) || seed.getCropId() == 0 || crops.contains(seed.getCropId())) continue;
            crops.add(seed.getCropId());
        }
        return crops;
    }

    public int getSeedBasicPrice(int seedId) {
        L2Item seedItem = ItemTable.getInstance().getTemplate(seedId);
        if (seedItem != null) {
            return seedItem.getReferencePrice();
        }
        return 0;
    }

    public int getSeedBasicPriceByCrop(int cropId) {
        for (L2Seed seed : _seeds.values()) {
            if (seed.getCropId() != cropId) continue;
            return this.getSeedBasicPrice(seed.getSeedId());
        }
        return 0;
    }

    public int getCropBasicPrice(int cropId) {
        L2Item cropItem = ItemTable.getInstance().getTemplate(cropId);
        if (cropItem != null) {
            return cropItem.getReferencePrice();
        }
        return 0;
    }

    public int getMatureCrop(int cropId) {
        for (L2Seed seed : _seeds.values()) {
            if (seed.getCropId() != cropId) continue;
            return seed.getMatureId();
        }
        return 0;
    }

    public long getSeedBuyPrice(int seedId) {
        long buyPrice = this.getSeedBasicPrice(seedId);
        return buyPrice > 0L ? buyPrice : 1L;
    }

    public int getSeedMinLevel(int seedId) {
        L2Seed seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getLevel() - 5;
        }
        return -1;
    }

    public int getSeedMaxLevel(int seedId) {
        L2Seed seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getLevel() + 5;
        }
        return -1;
    }

    public int getSeedLevelByCrop(int cropId) {
        for (L2Seed seed : _seeds.values()) {
            if (seed.getCropId() != cropId) continue;
            return seed.getLevel();
        }
        return 0;
    }

    public int getSeedLevel(int seedId) {
        L2Seed seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getLevel();
        }
        return -1;
    }

    public boolean isAlternative(int seedId) {
        L2Seed seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.isAlternative();
        }
        return false;
    }

    public int getCropType(int seedId) {
        L2Seed seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getCropId();
        }
        return -1;
    }

    public int getRewardItem(int cropId, int type) {
        for (L2Seed seed : _seeds.values()) {
            if (seed.getCropId() != cropId) continue;
            return seed.getReward(type);
        }
        return -1;
    }

    public int getRewardItemBySeed(int seedId, int type) {
        L2Seed seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getReward(type);
        }
        return 0;
    }

    public List<Integer> getCropsForCastle(int castleId) {
        ArrayList<Integer> crops = new ArrayList<Integer>();
        for (L2Seed seed : _seeds.values()) {
            if (seed.getCastleId() != castleId || crops.contains(seed.getCropId())) continue;
            crops.add(seed.getCropId());
        }
        return crops;
    }

    public List<Integer> getSeedsForCastle(int castleId) {
        ArrayList<Integer> seedsID = new ArrayList<Integer>();
        for (L2Seed seed : _seeds.values()) {
            if (seed.getCastleId() != castleId || seedsID.contains(seed.getSeedId())) continue;
            seedsID.add(seed.getSeedId());
        }
        return seedsID;
    }

    public int getCastleIdForSeed(int seedId) {
        L2Seed seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getCastleId();
        }
        return 0;
    }

    public int getSeedSaleLimit(int seedId) {
        L2Seed seed = _seeds.get(seedId);
        if (seed != null) {
            return seed.getSeedLimit();
        }
        return 0;
    }

    public int getCropPuchaseLimit(int cropId) {
        for (L2Seed seed : _seeds.values()) {
            if (seed.getCropId() != cropId) continue;
            return seed.getCropLimit();
        }
        return 0;
    }

    public static ManorData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final ManorData _instance = new ManorData();

        private SingletonHolder() {
        }
    }
}

