/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.model.skills.funcs.LambdaConst;
import com.l2jserver.gameserver.model.stats.Stats;
import java.util.ArrayList;
import java.util.Set;
import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;
import org.w3c.dom.Node;

public class EnchantItemHPBonusData
extends DocumentParser {
    private final SortedIntObjectArrayMap<ArrayList<Integer>> _armorHPBonuses = new SortedIntObjectArrayMap((Object[])new ArrayList[0]);
    private static final float fullArmorModifier = 1.5f;

    protected EnchantItemHPBonusData() {
        this.load();
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equals(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"enchantHP".equals(d.getNodeName())) continue;
                ArrayList<Integer> bonuses = new ArrayList<Integer>();
                for (Node e = d.getFirstChild(); e != null; e = e.getNextSibling()) {
                    if (!"bonus".equals(e.getNodeName())) continue;
                    bonuses.add(Integer.valueOf(e.getTextContent()));
                }
                this._armorHPBonuses.put(this.parseInteger(d.getAttributes(), "grade").intValue(), bonuses);
            }
        }
        if (!this._armorHPBonuses.isEmpty()) {
            L2Item item;
            ItemTable it = ItemTable.getInstance();
            Set<Integer> armorIds = it.getAllArmorsId();
            for (Integer itemId : armorIds) {
                item = it.getTemplate(itemId);
                if (item == null || item.getCrystalType() == 0) continue;
                switch (item.getBodyPart()) {
                    case 1: 
                    case 64: 
                    case 256: 
                    case 512: 
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: 
                    case 32768: {
                        item.attach(new FuncTemplate(null, null, "EnchantHp", Stats.MAX_HP, 96, new LambdaConst(0.0)));
                        break;
                    }
                }
            }
            Set<Integer> shieldIds = it.getAllWeaponsId();
            for (Integer itemId : shieldIds) {
                item = it.getTemplate(itemId);
                if (item == null || item.getCrystalType() == 0) continue;
                switch (item.getBodyPart()) {
                    case 256: {
                        item.attach(new FuncTemplate(null, null, "EnchantHp", Stats.MAX_HP, 96, new LambdaConst(0.0)));
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void load() {
        this._armorHPBonuses.clear();
        this.parseDatapackFile("data/stats/enchantHPBonus.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._armorHPBonuses.size() + " Enchant HP Bonuses.");
    }

    public final int getHPBonus(L2ItemInstance item) {
        ArrayList values = (ArrayList)this._armorHPBonuses.get(item.getItem().getItemGradeSPlus());
        if (values == null || values.isEmpty() || item.getOlyEnchantLevel() <= 0) {
            return 0;
        }
        int bonus = (Integer)values.get(Math.min(item.getOlyEnchantLevel(), values.size()) - 1);
        if (item.getItem().getBodyPart() == 32768) {
            return (int)((float)bonus * 1.5f);
        }
        return bonus;
    }

    public static final EnchantItemHPBonusData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final EnchantItemHPBonusData _instance = new EnchantItemHPBonusData();

        private SingletonHolder() {
        }
    }
}

