/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.enums.CategoryType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class CategoryData
extends DocumentParser {
    private static final Logger _log = Logger.getLogger(CategoryData.class.getName());
    private final HashMap<CategoryType, int[]> _categories = new HashMap();

    protected CategoryData() {
        this.load();
    }

    @Override
    public void load() {
        this._categories.clear();
        this.parseDatapackFile("data/categoryData.xml");
        _log.info(this.getClass().getSimpleName() + ": Loaded " + this._categories.size() + " Categories.");
    }

    @Override
    protected void parseDocument() {
        for (Node node = this.getCurrentDocument().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"list".equalsIgnoreCase(node.getNodeName())) continue;
            for (Node list_node = node.getFirstChild(); list_node != null; list_node = list_node.getNextSibling()) {
                if (!"category".equalsIgnoreCase(list_node.getNodeName())) continue;
                NamedNodeMap attrs = list_node.getAttributes();
                CategoryType categoryType = CategoryType.findByName(attrs.getNamedItem("name").getNodeValue());
                if (categoryType == null) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Can't find category by name :" + attrs.getNamedItem("name").getNodeValue());
                    continue;
                }
                HashSet<Integer> ids = new HashSet<Integer>();
                for (Node category_node = list_node.getFirstChild(); category_node != null; category_node = category_node.getNextSibling()) {
                    if (!"id".equalsIgnoreCase(category_node.getNodeName())) continue;
                    ids.add(Integer.parseInt(category_node.getTextContent()));
                }
                int[] ida = new int[ids.size()];
                int index = 0;
                for (Integer id : ids) {
                    ida[index++] = id;
                }
                Arrays.sort(ida);
                this._categories.put(categoryType, ida);
            }
        }
    }

    public boolean isInCategory(CategoryType type, int id) {
        int[] category = this._categories.get((Object)type);
        if (category == null) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Can't find category type :" + (Object)((Object)type));
            return false;
        }
        return Arrays.binarySearch(category, id) >= 0;
    }

    public static CategoryData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CategoryData _instance = new CategoryData();

        private SingletonHolder() {
        }
    }
}

