/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import gnu.trove.map.hash.TIntLongHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.sf.l2j.troja.FastIntObjectMap;
import jp.sf.l2j.troja.IntObjectMap;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public final class BotReportTable {
    static final Logger _log = Logger.getLogger(BotReportTable.class.getName());
    private static final int COLUMN_BOT_ID = 1;
    private static final int COLUMN_REPORTER_ID = 2;
    private static final int COLUMN_REPORT_TIME = 3;
    public static final int ATTACK_ACTION_BLOCK_ID = -1;
    public static final int TRADE_ACTION_BLOCK_ID = -2;
    public static final int PARTY_ACTION_BLOCK_ID = -3;
    public static final int ACTION_BLOCK_ID = -4;
    public static final int CHAT_BLOCK_ID = -5;
    private static final String SQL_LOAD_REPORTED_CHAR_DATA = "SELECT * FROM bot_reported_char_data";
    private static final String SQL_INSERT_REPORTED_CHAR_DATA = "INSERT INTO bot_reported_char_data VALUES (?,?,?)";
    private static final String SQL_CLEAR_REPORTED_CHAR_DATA = "DELETE FROM bot_reported_char_data";
    private TIntLongHashMap _ipRegistry;
    private FastIntObjectMap<ReporterCharData> _charRegistry;
    private FastIntObjectMap<ReportedCharData> _reports;
    private FastIntObjectMap<PunishHolder> _punishments;

    BotReportTable() {
        if (Config.BOTREPORT_ENABLE) {
            this._ipRegistry = new TIntLongHashMap();
            this._charRegistry = new FastIntObjectMap().shared();
            this._reports = new FastIntObjectMap().shared();
            this._punishments = new FastIntObjectMap().shared();
            try {
                File punishments = new File("./config/botreport_punishments.xml");
                if (!punishments.exists()) {
                    throw new FileNotFoundException(punishments.getName());
                }
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(punishments, (DefaultHandler)new PunishmentsLoader());
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "BotReportTable: Could not load punishments from /config/botreport_punishments.xml", e);
            }
            this.loadReportedCharData();
            this.scheduleResetPointTask();
        }
    }

    private void loadReportedCharData() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            PreparedStatement st = con.prepareStatement(SQL_LOAD_REPORTED_CHAR_DATA);
            ResultSet rset = st.executeQuery();
            long lastResetTime = 0L;
            try {
                String[] hour = Config.BOTREPORT_RESETPOINT_HOUR;
                Calendar c = Calendar.getInstance();
                c.set(11, Integer.parseInt(hour[0]));
                c.set(12, Integer.parseInt(hour[1]));
                if (System.currentTimeMillis() < c.getTimeInMillis()) {
                    c.set(6, c.get(6) - 1);
                }
                lastResetTime = c.getTimeInMillis();
            }
            catch (Exception e) {
                // empty catch block
            }
            while (rset.next()) {
                Object rcd;
                int botId = rset.getInt(1);
                int reporter = rset.getInt(2);
                long date = rset.getLong(3);
                if (this._reports.containsKey(botId)) {
                    ((ReportedCharData)this._reports.get(botId)).addReporter(reporter, date);
                } else {
                    rcd = new ReportedCharData();
                    ((ReportedCharData)rcd).addReporter(reporter, date);
                    this._reports.put(rset.getInt(1), rcd);
                }
                if (date <= lastResetTime) continue;
                rcd = null;
                rcd = (ReporterCharData)this._charRegistry.get(reporter);
                if (rcd != null) {
                    ((ReporterCharData)rcd).setPoints(((ReporterCharData)rcd).getPointsLeft() - 1);
                    continue;
                }
                rcd = new ReporterCharData();
                ((ReporterCharData)rcd).setPoints(6);
                this._charRegistry.put(reporter, rcd);
            }
            rset.close();
            st.close();
            _log.info("BotReportTable: Loaded " + this._reports.size() + " bot reports");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "BotReportTable: Could not load reported char data!", e);
        }
    }

    public void saveReportedCharData() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            PreparedStatement st = con.prepareStatement(SQL_CLEAR_REPORTED_CHAR_DATA);
            st.execute();
            st = con.prepareStatement(SQL_INSERT_REPORTED_CHAR_DATA);
            for (IntObjectMap.Entry entry : this._reports.entrySet()) {
                TIntLongHashMap reportTable = ((ReportedCharData)entry.getValue())._reporters;
                for (int reporterId : reportTable.keys()) {
                    st.setInt(1, entry.getKey());
                    st.setInt(2, reporterId);
                    st.setLong(3, reportTable.get(reporterId));
                    st.execute();
                    st.clearParameters();
                }
            }
            st.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "BotReportTable: Could not update reported char data in database!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reportBot(L2PcInstance reporter) {
        L2Object target = reporter.getTarget();
        L2PcInstance bot = null;
        if (target == null || (bot = target.getActingPlayer()) == null || target.getObjectId() == reporter.getObjectId()) {
            return false;
        }
        if (bot.isInsideZone(ZoneId.PEACE) || bot.isInsideZone(ZoneId.PVP)) {
            reporter.sendPacket(SystemMessageId.YOU_CANNOT_REPORT_CHARACTER_IN_PEACE_OR_BATTLE_ZONE);
            return false;
        }
        if (bot.isInOlympiadMode()) {
            reporter.sendPacket(SystemMessageId.TARGET_NOT_REPORT_CANNOT_REPORT_PEACE_PVP_ZONE_OR_OLYMPIAD_OR_CLAN_WAR_ENEMY);
            return false;
        }
        if (bot.getClan() != null && bot.getClan().isAtWarWith(reporter.getClan())) {
            reporter.sendPacket(SystemMessageId.YOU_CANNOT_REPORT_CLAN_WAR_ENEMY);
            return false;
        }
        if (bot.getExp() == bot.getStat().getStartingExp()) {
            reporter.sendPacket(SystemMessageId.YOU_CANNOT_REPORT_CHAR_WHO_ACQUIRED_XP);
            return false;
        }
        ReportedCharData rcd = (ReportedCharData)this._reports.get(bot.getObjectId());
        ReporterCharData rcdRep = (ReporterCharData)this._charRegistry.get(reporter.getObjectId());
        int reporterId = reporter.getObjectId();
        BotReportTable botReportTable = this;
        synchronized (botReportTable) {
            if (this._reports.containsKey(reporterId)) {
                reporter.sendPacket(SystemMessageId.YOU_HAVE_BEEN_REPORTED_AND_CANNOT_REPORT);
                return false;
            }
            int ip = BotReportTable.hashIp(reporter);
            if (!BotReportTable.timeHasPassed(this._ipRegistry, ip)) {
                reporter.sendPacket(SystemMessageId.CANNOT_REPORT_TARGET_ALREDY_REPORTED_BY_CLAN_ALLY_MEMBER_OR_SAME_IP);
                return false;
            }
            if (rcd != null) {
                if (rcd.alredyReportedBy(reporterId)) {
                    reporter.sendPacket(SystemMessageId.YOU_CANNOT_REPORT_CHAR_AT_THIS_TIME_1);
                    return false;
                }
                if (!Config.BOTREPORT_ALLOW_REPORTS_FROM_SAME_CLAN_MEMBERS && rcd.reportedBySameClan(reporter.getClan())) {
                    reporter.sendPacket(SystemMessageId.CANNOT_REPORT_TARGET_ALREDY_REPORTED_BY_CLAN_ALLY_MEMBER_OR_SAME_IP);
                    return false;
                }
            }
            if (rcdRep != null) {
                if (rcdRep.getPointsLeft() == 0) {
                    reporter.sendPacket(SystemMessageId.YOU_HAVE_USED_ALL_POINTS_POINTS_ARE_RESET_AT_NOON);
                    return false;
                }
                long reuse = System.currentTimeMillis() - rcdRep.getLastReporTime();
                if (reuse < Config.BOTREPORT_REPORT_DELAY) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_CAN_REPORT_IN_S1_MINS_YOU_HAVE_S2_POINTS_LEFT);
                    sm.addNumber((int)(reuse / 60000L));
                    sm.addNumber(rcdRep.getPointsLeft());
                    reporter.sendPacket(sm);
                    return false;
                }
            }
            long curTime = System.currentTimeMillis();
            if (rcd == null) {
                rcd = new ReportedCharData();
                this._reports.put(bot.getObjectId(), (Object)rcd);
            }
            rcd.addReporter(reporterId, curTime);
            if (rcdRep == null) {
                rcdRep = new ReporterCharData();
            }
            rcdRep.registerReport(curTime);
            this._ipRegistry.put(ip, curTime);
            this._charRegistry.put(reporterId, (Object)rcdRep);
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_WAS_REPORTED_AS_BOT);
        sm.addCharName(bot);
        reporter.sendPacket(sm);
        sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_USED_REPORT_POINT_ON_C1_YOU_HAVE_C2_POINTS_LEFT);
        sm.addCharName(bot);
        sm.addNumber(rcdRep.getPointsLeft());
        reporter.sendPacket(sm);
        this.handleReport(bot, rcd);
        return true;
    }

    private void handleReport(L2PcInstance bot, ReportedCharData rcd) {
        this.punishBot(bot, (PunishHolder)this._punishments.get(rcd.getReportCount()));
        for (IntObjectMap.Entry entry : this._punishments.entrySet()) {
            int key = entry.getKey();
            if (key >= 0 || Math.abs(key) > rcd.getReportCount()) continue;
            this.punishBot(bot, (PunishHolder)entry.getValue());
        }
    }

    private void punishBot(L2PcInstance bot, PunishHolder ph) {
        if (ph != null) {
            SystemMessageId id;
            ph._punish.applyEffects(bot, bot);
            if (ph._systemMessageId > -1 && (id = SystemMessageId.getSystemMessageId(ph._systemMessageId)) != null) {
                bot.sendPacket(id);
            }
        }
    }

    void addPunishment(int neededReports, int skillId, int skillLevel, int sysMsg) {
        L2Skill sk = SkillTable.getInstance().getInfo(skillId, skillLevel);
        if (sk != null) {
            this._punishments.put(neededReports, (Object)new PunishHolder(sk, sysMsg));
        } else {
            _log.warning("BotReportTable: Could not add punishment for " + neededReports + " report(s): Skill " + skillId + "-" + skillLevel + " does not exist!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetPointsAndSchedule() {
        FastIntObjectMap<ReporterCharData> fastIntObjectMap = this._charRegistry;
        synchronized (fastIntObjectMap) {
            for (ReporterCharData rcd : this._charRegistry.values()) {
                rcd.setPoints(7);
            }
        }
        this.scheduleResetPointTask();
    }

    private void scheduleResetPointTask() {
        try {
            String[] hour = Config.BOTREPORT_RESETPOINT_HOUR;
            Calendar c = Calendar.getInstance();
            c.set(11, Integer.parseInt(hour[0]));
            c.set(12, Integer.parseInt(hour[1]));
            if (System.currentTimeMillis() > c.getTimeInMillis()) {
                c.set(6, c.get(6) + 1);
            }
            ThreadPoolManager.getInstance().scheduleGeneral(new ResetPointTask(), c.getTimeInMillis() - System.currentTimeMillis());
        }
        catch (Exception e) {
            ThreadPoolManager.getInstance().scheduleGeneral(new ResetPointTask(), 86400000L);
            _log.log(Level.WARNING, "BotReportTable: Could not properly schedule bot report points reset task. Scheduled in 24 hours.", e);
        }
    }

    public static BotReportTable getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static int hashIp(L2PcInstance player) {
        String con = player.getClient().getConnection().getInetAddress().getHostAddress();
        String[] rawByte = con.split("\\.");
        int[] rawIp = new int[4];
        for (int i = 0; i < 4; ++i) {
            rawIp[i] = Integer.parseInt(rawByte[i]);
        }
        return rawIp[0] | rawIp[1] << 8 | rawIp[2] << 16 | rawIp[3] << 24;
    }

    private static boolean timeHasPassed(TIntLongHashMap map, int objectId) {
        long time = map.get(objectId);
        if (time != map.getNoEntryValue()) {
            return System.currentTimeMillis() - time > Config.BOTREPORT_REPORT_DELAY;
        }
        return true;
    }

    private static final class SingletonHolder {
        static final BotReportTable INSTANCE = new BotReportTable();

        private SingletonHolder() {
        }
    }

    class ResetPointTask
    implements Runnable {
        ResetPointTask() {
        }

        @Override
        public void run() {
            BotReportTable.this.resetPointsAndSchedule();
        }
    }

    class PunishHolder {
        final L2Skill _punish;
        final int _systemMessageId;

        PunishHolder(L2Skill sk, int sysMsg) {
            this._punish = sk;
            this._systemMessageId = sysMsg;
        }
    }

    private final class PunishmentsLoader
    extends DefaultHandler {
        PunishmentsLoader() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attr) {
            if (qName.equals("punishment")) {
                int reportCount = -1;
                int skillId = -1;
                int skillLevel = 1;
                int sysMessage = -1;
                try {
                    reportCount = Integer.parseInt(attr.getValue("neededReportCount"));
                    skillId = Integer.parseInt(attr.getValue("skillId"));
                    String level = attr.getValue("skillLevel");
                    String systemMessageId = attr.getValue("sysMessageId");
                    if (level != null) {
                        skillLevel = Integer.parseInt(level);
                    }
                    if (systemMessageId != null) {
                        sysMessage = Integer.parseInt(systemMessageId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                BotReportTable.this.addPunishment(reportCount, skillId, skillLevel, sysMessage);
            }
        }
    }

    private final class ReportedCharData {
        TIntLongHashMap _reporters = new TIntLongHashMap();

        ReportedCharData() {
        }

        int getReportCount() {
            return this._reporters.size();
        }

        boolean alredyReportedBy(int objectId) {
            return this._reporters.contains(objectId);
        }

        void addReporter(int objectId, long reportTime) {
            this._reporters.put(objectId, reportTime);
        }

        boolean reportedBySameClan(L2Clan clan) {
            if (clan == null) {
                return false;
            }
            for (int reporterId : this._reporters.keys()) {
                if (!clan.isMember(reporterId)) continue;
                return true;
            }
            return false;
        }
    }

    private final class ReporterCharData {
        private long _lastReport = 0L;
        private byte _reportPoints = (byte)7;

        ReporterCharData() {
        }

        void registerReport(long time) {
            this._reportPoints = (byte)(this._reportPoints - 1);
            this._lastReport = time;
        }

        long getLastReporTime() {
            return this._lastReport;
        }

        byte getPointsLeft() {
            return this._reportPoints;
        }

        void setPoints(int points) {
            this._reportPoints = (byte)points;
        }
    }
}

