/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mmocore.network.IAcceptFilter;

public class IPv4Filter
implements IAcceptFilter,
Runnable {
    private final HashMap<Integer, Flood> _ipFloodMap = new HashMap();
    private static final long SLEEP_TIME = 5000L;

    public IPv4Filter() {
        Thread t = new Thread((Runnable)this, this.getClass().getSimpleName());
        t.setDaemon(true);
        t.start();
    }

    private static final int hash(byte[] ip) {
        return ip[0] & 0xFF | (ip[1] & 0xFF) << 8 | (ip[2] & 0xFF) << 16 | (ip[3] & 0xFF) << 24;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(SocketChannel sc) {
        Flood f;
        InetAddress addr = sc.socket().getInetAddress();
        int h = IPv4Filter.hash(addr.getAddress());
        long current = System.currentTimeMillis();
        HashMap<Integer, Flood> hashMap = this._ipFloodMap;
        synchronized (hashMap) {
            f = this._ipFloodMap.get(h);
        }
        if (f != null) {
            if (f.trys == -1) {
                f.lastAccess = current;
                return false;
            }
            if (f.lastAccess + 1000L > current) {
                f.lastAccess = current;
                if (f.trys >= 3) {
                    f.trys = -1;
                    return false;
                }
                ++f.trys;
            } else {
                f.lastAccess = current;
            }
        } else {
            hashMap = this._ipFloodMap;
            synchronized (hashMap) {
                this._ipFloodMap.put(h, new Flood());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            long reference = System.currentTimeMillis() - 300000L;
            HashMap<Integer, Flood> hashMap = this._ipFloodMap;
            synchronized (hashMap) {
                Iterator<Map.Entry<Integer, Flood>> it = this._ipFloodMap.entrySet().iterator();
                while (it.hasNext()) {
                    Flood f = it.next().getValue();
                    if (f.lastAccess >= reference) continue;
                    it.remove();
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    protected static final class Flood {
        long lastAccess = System.currentTimeMillis();
        int trys = 0;

        Flood() {
        }
    }
}

