/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.tools.dbinstaller.gui;

import com.l2jserver.tools.dbinstaller.RunTasks;
import com.l2jserver.tools.dbinstaller.gui.DBInstallerGUI;
import com.l2jserver.tools.dbinstaller.util.mysql.MySqlConnect;
import com.l2jserver.tools.dbinstaller.util.swing.SpringUtilities;
import com.l2jserver.tools.images.ImagesTable;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class DBConfigGUI
extends JFrame {
    private static final long serialVersionUID = -8391792251140797076L;
    JTextField _dbHost;
    JTextField _dbPort;
    JTextField _dbUser;
    JPasswordField _dbPass;
    JTextField _dbDbse;
    String _db;
    String _dir;
    String _cleanUp;
    String log;
    Preferences _prop;

    public DBConfigGUI(String db, String dir, String cleanUp) {
        super("L2J Database Installer");
        this.setLayout(new SpringLayout());
        DBConfigGUI.setDefaultLookAndFeelDecorated(true);
        this.setIconImage(ImagesTable.getImage("l2j.png").getImage());
        this._db = db;
        this._dir = dir;
        this._cleanUp = cleanUp;
        this.log = "dbinst_localhost_" + db + ".log";
        int width = 260;
        int height = 220;
        Dimension resolution = Toolkit.getDefaultToolkit().getScreenSize();
        this.setDefaultCloseOperation(3);
        this.setBounds((resolution.width - width) / 2, (resolution.height - height) / 2, width, height);
        this.setResizable(false);
        this._prop = Preferences.userRoot();
        JLabel labelDbHost = new JLabel("Host: ", 2);
        this.add(labelDbHost);
        this._dbHost = new JTextField(15);
        this._dbHost.setText(this._prop.get("dbHost_" + db, "localhost"));
        labelDbHost.setLabelFor(this._dbHost);
        this.add(this._dbHost);
        JLabel labelDbPort = new JLabel("Port: ", 2);
        this.add(labelDbPort);
        this._dbPort = new JTextField(15);
        this._dbPort.setText(this._prop.get("dbPort_" + db, "3306"));
        labelDbPort.setLabelFor(this._dbPort);
        this.add(this._dbPort);
        JLabel labelDbUser = new JLabel("Username: ", 2);
        this.add(labelDbUser);
        this._dbUser = new JTextField(15);
        this._dbUser.setText(this._prop.get("dbUser_" + db, "root"));
        labelDbUser.setLabelFor(this._dbUser);
        this.add(this._dbUser);
        JLabel labelDbPass = new JLabel("Password: ", 2);
        this.add(labelDbPass);
        this._dbPass = new JPasswordField(15);
        this._dbPass.setText(this._prop.get("dbPass_" + db, ""));
        labelDbPass.setLabelFor(this._dbPass);
        this.add(this._dbPass);
        JLabel labelDbDbse = new JLabel("Database: ", 2);
        this.add(labelDbDbse);
        this._dbDbse = new JTextField(15);
        this._dbDbse.setText(this._prop.get("dbDbse_" + db, db));
        labelDbDbse.setLabelFor(this._dbDbse);
        this.add(this._dbDbse);
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(cancelListener);
        this.add(btnCancel);
        ActionListener connectListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MySqlConnect connector = new MySqlConnect(DBConfigGUI.this._dbHost.getText(), DBConfigGUI.this._dbPort.getText(), DBConfigGUI.this._dbUser.getText(), new String(DBConfigGUI.this._dbPass.getPassword()), DBConfigGUI.this._dbDbse.getText(), false);
                DBConfigGUI.this.log = "dbinst_" + DBConfigGUI.this._dbHost.getText().replaceAll("[^0-9a-zA-Z.]+", "-") + "_" + DBConfigGUI.this._dbDbse.getText() + ".log";
                if (connector.getConnection() != null) {
                    DBConfigGUI.this._prop.put("dbHost_" + DBConfigGUI.this._db, DBConfigGUI.this._dbHost.getText());
                    DBConfigGUI.this._prop.put("dbPort_" + DBConfigGUI.this._db, DBConfigGUI.this._dbPort.getText());
                    DBConfigGUI.this._prop.put("dbUser_" + DBConfigGUI.this._db, DBConfigGUI.this._dbUser.getText());
                    DBConfigGUI.this._prop.put("dbDbse_" + DBConfigGUI.this._db, DBConfigGUI.this._dbDbse.getText());
                    boolean cleanInstall = false;
                    DBInstallerGUI dbi = new DBInstallerGUI(connector.getConnection());
                    DBConfigGUI.this.setVisible(false);
                    Object[] options = new Object[]{"Full Install", "Upgrade", "Exit"};
                    int n = JOptionPane.showOptionDialog(null, "Select Installation Type", "Installation Type", 1, 3, null, options, options[1]);
                    if (n == 2 || n == -1) {
                        System.exit(0);
                    }
                    if (n == 0) {
                        int conf = JOptionPane.showConfirmDialog(null, "Do you really want to destroy your db?", "Confirm", 0, 2);
                        if (conf == 1) {
                            System.exit(0);
                        }
                        cleanInstall = true;
                    }
                    dbi.setVisible(true);
                    RunTasks task = new RunTasks(dbi, DBConfigGUI.this._dbHost.getText(), DBConfigGUI.this._db, DBConfigGUI.this._dir, DBConfigGUI.this._cleanUp, cleanInstall, DBConfigGUI.this.log);
                    task.setPriority(10);
                    task.start();
                }
            }
        };
        JButton btnConnect = new JButton("Connect");
        btnConnect.addActionListener(connectListener);
        this.add(btnConnect);
        SpringUtilities.makeCompactGrid(this.getContentPane(), 6, 2, 5, 5, 5, 5);
        this.setVisible(true);
    }
}

