/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.tools.gsregistering;

import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.tools.gsregistering.BaseGameServerRegister;
import com.l2jserver.tools.gsregistering.GUserInterface;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;

public class RegisterDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle _bundle;
    private final JComboBox<ComboServer> _combo;
    private final GUserInterface _owner;

    public RegisterDialog(GUserInterface owner) {
        super((Frame)owner.getFrame(), true);
        this._owner = owner;
        this.setDefaultCloseOperation(2);
        this._bundle = owner.getBundle();
        this.setTitle(this._bundle.getString("registerGS"));
        this.setResizable(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 1;
        JLabel label = new JLabel(this._bundle.getString("serverName"));
        this.add((Component)label, cons);
        this._combo = new JComboBox();
        this._combo.setEditable(false);
        for (Map.Entry<Integer, String> entry : GameServerTable.getInstance().getServerNames().entrySet()) {
            if (GameServerTable.getInstance().hasRegisteredGameServerOnId(entry.getKey())) continue;
            this._combo.addItem(new ComboServer(entry.getKey(), entry.getValue()));
        }
        cons.gridx = 1;
        cons.gridy = 0;
        this.add(this._combo, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 2;
        JTextPane textPane = new JTextPane();
        textPane.setText(this._bundle.getString("saveHexId"));
        textPane.setEditable(false);
        textPane.setBackground(label.getBackground());
        this.add((Component)textPane, cons);
        cons.gridwidth = 1;
        JButton btnSave = new JButton(this._bundle.getString("save"));
        btnSave.setActionCommand("save");
        btnSave.addActionListener(this);
        cons.gridx = 0;
        cons.gridy = 2;
        this.add((Component)btnSave, cons);
        JButton btnCancel = new JButton(this._bundle.getString("cancel"));
        btnCancel.setActionCommand("cancel");
        btnCancel.addActionListener(this);
        cons.gridx = 1;
        cons.gridy = 2;
        this.add((Component)btnCancel, cons);
        double leftSize = Math.max(label.getPreferredSize().getWidth(), btnSave.getPreferredSize().getWidth());
        double rightSize = Math.max(this._combo.getPreferredSize().getWidth(), btnCancel.getPreferredSize().getWidth());
        double height = this._combo.getPreferredSize().getHeight() + 4.0 * textPane.getPreferredSize().getHeight() + btnSave.getPreferredSize().getHeight();
        this.setSize((int)(leftSize + rightSize + 30.0), (int)(height + 20.0));
        this.setLocationRelativeTo(owner.getFrame());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("save")) {
            ComboServer server = (ComboServer)this._combo.getSelectedItem();
            int gsId = server.getId();
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle(this._bundle.getString("hexidDest"));
            fc.setFileSelectionMode(1);
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return null;
                }
            });
            fc.showOpenDialog(this);
            try {
                BaseGameServerRegister.registerGameServer(gsId, fc.getSelectedFile().getAbsolutePath());
                this._owner.refreshAsync();
                this.setVisible(false);
            }
            catch (IOException e1) {
                this._owner.showError(this._bundle.getString("ioErrorRegister"), e1);
            }
        } else if (cmd.equals("cancel")) {
            this.setVisible(false);
        }
    }

    class ComboServer {
        private final int _id;
        private final String _name;

        public ComboServer(int id, String name) {
            this._id = id;
            this._name = name;
        }

        public int getId() {
            return this._id;
        }

        public String getName() {
            return this._name;
        }

        public String toString() {
            return this.getName();
        }
    }
}

