/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.status;

import com.l2jserver.status.GameStatusThread;
import com.l2jserver.status.LoginStatusThread;
import com.l2jserver.util.Rnd;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javolution.util.FastList;

public class Status
extends Thread {
    protected static final Logger _log = Logger.getLogger(Status.class.getName());
    private final ServerSocket statusServerSocket;
    private final int _uptime;
    private final int _statusPort;
    private String _statusPw;
    private final int _mode;
    private final List<LoginStatusThread> _loginStatus;

    @Override
    public void run() {
        this.setPriority(10);
        while (!this.isInterrupted()) {
            try {
                LoginStatusThread lst;
                Socket connection = this.statusServerSocket.accept();
                if (this._mode == 1) {
                    new GameStatusThread(connection, this._uptime, this._statusPw);
                } else if (this._mode == 2 && (lst = new LoginStatusThread(connection, this._uptime, this._statusPw)).isAlive()) {
                    this._loginStatus.add(lst);
                }
                if (!this.isInterrupted()) continue;
                try {
                    this.statusServerSocket.close();
                }
                catch (IOException io) {
                    _log.warning(this.getClass().getSimpleName() + ": " + io.getMessage());
                }
            }
            catch (IOException e) {
                if (!this.isInterrupted()) continue;
                try {
                    this.statusServerSocket.close();
                }
                catch (IOException io) {
                    _log.warning(this.getClass().getSimpleName() + ": " + io.getMessage());
                }
            }
            break;
        }
    }

    public Status(int mode) throws IOException {
        super("Status");
        this._mode = mode;
        Properties telnetSettings = new Properties();
        try (FileInputStream is = new FileInputStream(new File("./config/Telnet.properties"));){
            telnetSettings.load(is);
        }
        this._statusPort = Integer.parseInt(telnetSettings.getProperty("StatusPort", "12345"));
        this._statusPw = telnetSettings.getProperty("StatusPW");
        if (this._mode == 1 || this._mode == 2) {
            if (this._statusPw == null) {
                _log.info("Server's Telnet Function Has No Password Defined!");
                _log.info("A Password Has Been Automaticly Created!");
                this._statusPw = this.rndPW(10);
                _log.info("Password Has Been Set To: *****");
            }
            _log.info("Telnet StatusServer started successfully, listening on Port: " + this._statusPort);
        }
        this.statusServerSocket = new ServerSocket(this._statusPort);
        this._uptime = (int)System.currentTimeMillis();
        this._loginStatus = new FastList();
    }

    private String rndPW(int length) {
        String lowerChar = "qwertyuiopasdfghjklzxcvbnm";
        String upperChar = "QWERTYUIOPASDFGHJKLZXCVBNM";
        String digits = "1234567890";
        StringBuilder password = new StringBuilder(length);
        block5: for (int i = 0; i < length; ++i) {
            int charSet = Rnd.nextInt(3);
            switch (charSet) {
                case 0: {
                    password.append("qwertyuiopasdfghjklzxcvbnm".charAt(Rnd.nextInt("qwertyuiopasdfghjklzxcvbnm".length() - 1)));
                    continue block5;
                }
                case 1: {
                    password.append("QWERTYUIOPASDFGHJKLZXCVBNM".charAt(Rnd.nextInt("QWERTYUIOPASDFGHJKLZXCVBNM".length() - 1)));
                    continue block5;
                }
                case 2: {
                    password.append("1234567890".charAt(Rnd.nextInt("1234567890".length() - 1)));
                }
            }
        }
        return password.toString();
    }

    public void sendMessageToTelnets(String msg) {
        FastList lsToRemove = new FastList();
        for (LoginStatusThread ls : this._loginStatus) {
            if (ls.isInterrupted()) {
                lsToRemove.add(ls);
                continue;
            }
            ls.printToTelnet(msg);
        }
    }
}

