/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

import com.l2jserver.util.HexUtils;
import com.l2jserver.util.Rnd;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

public class Util {
    private static final Logger _log = Logger.getLogger(Util.class.getName());
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final String DATE_FORMAT = "yyyy/MM/dd HH:mm (E)";

    public static boolean isInternalHostname(String host) {
        try {
            InetAddress addr = InetAddress.getByName(host);
            return addr.isSiteLocalAddress() || addr.isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            _log.warning("Util: " + e.getMessage());
            return false;
        }
    }

    public static String printData(byte[] data, int len) {
        return HexUtils.bArr2HexEdChars(data, len).toString();
    }

    public static String printData(byte[] data) {
        return Util.printData(data, data.length);
    }

    public static String printData(ByteBuffer buf) {
        byte[] data = new byte[buf.remaining()];
        buf.get(data);
        String hex = Util.printData(data, data.length);
        buf.position(buf.position() - data.length);
        return hex;
    }

    public static byte[] generateHex(int size) {
        byte[] array = new byte[size];
        Rnd.nextBytes(array);
        return array;
    }

    public static String dateFormat() {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date());
    }

    public static String dateFormat(long d) {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date(d));
    }

    public static String dateFormat(Date d) {
        return new SimpleDateFormat(DATE_FORMAT).format(d);
    }

    public static String dateFormat(Calendar d) {
        return new SimpleDateFormat(DATE_FORMAT).format(d.getTime());
    }

    public static String strTimeLeft(int time) {
        if (time % 86400 == 0) {
            return time / 86400 + "\u65e5\u9593";
        }
        if (time % 3600 == 0) {
            return time / 3600 + "\u6642\u9593";
        }
        if (time % 60 == 0) {
            return time / 60 + "\u5206\u9593";
        }
        return time + "\u79d2\u9593";
    }

    public static String strTime(int time) {
        if (time == 0) {
            return "0\u79d2";
        }
        StringBuilder sb = new StringBuilder(256);
        long n = time / 86400;
        if (n > 0L) {
            sb.append(n).append('\u65e5');
            time %= 86400;
        }
        if ((n = (long)(time / 3600)) > 0L) {
            sb.append(n).append("\u6642\u9593");
            time %= 3600;
        }
        if ((n = (long)(time / 60)) > 0L) {
            sb.append(n).append('\u5206');
            time %= 60;
        }
        if ((n = (long)time) > 0L) {
            sb.append(n).append('\u79d2');
        }
        return sb.toString();
    }

    public static String strMillTime(long milliTime) {
        if (milliTime == 0L) {
            return "0\u79d2";
        }
        if (milliTime <= 999L) {
            return milliTime + "\u3349\u79d2";
        }
        return Util.strTime((int)((milliTime + 999L) / 1000L));
    }

    public static BufferedReader utf8BufferedReader(String name) throws FileNotFoundException {
        return Util.skipBOM(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), StandardCharsets.UTF_8)));
    }

    public static BufferedReader utf8BufferedReader(File file) throws FileNotFoundException {
        return Util.skipBOM(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8)));
    }

    public static BufferedWriter utf8BufferedWriter(String name) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(name), StandardCharsets.UTF_8));
    }

    public static BufferedWriter utf8BufferedWriter(String name, boolean append) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(name, append), StandardCharsets.UTF_8));
    }

    public static BufferedWriter utf8BufferedWriter(File file) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
    }

    public static BufferedWriter utf8BufferedWriter(File file, boolean append) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), StandardCharsets.UTF_8));
    }

    private static BufferedReader skipBOM(BufferedReader reader) {
        try {
            reader.mark(1);
            if (reader.read() != 65279) {
                reader.reset();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return reader;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String replaceIllegalCharacters(String str) {
        String valid = str;
        for (char c : ILLEGAL_CHARACTERS) {
            valid = valid.replace(c, '_');
        }
        return valid;
    }

    public static boolean isValidFileName(String name) {
        File f = new File(name);
        try {
            f.getCanonicalPath();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

