package quests.Q641_AttackSailren;

import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.State;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;

/**
 * Made by Vice [L2JOneo]
 * [JOJO] L2JTW q
 *   http://www.l2jtw.com:3690/svn/datapack/L2JTW_Datapack_Gracia_Plus/data/scripts/quests/641_AttackSailren/__init__.py
 *   r547	timestamp 2009/10/11 12:17:17
 *
 * [JOJO] java 2011/11/07
 */
class Q641_AttackSailren extends Quest
{
 private static final String qn = "641_AttackSailren";
 
 // NPC
 private static final int STATUE = 32109;
 
 // MOBS
 private static final int VEL1 = 22196;
 private static final int VEL2 = 22197;
 private static final int VEL3 = 22198;
 private static final int VEL4 = 22218;
 private static final int VEL5 = 22223;
 private static final int PTE = 22199;
 
 // ITEMS
 private static final int FRAGMENTS = 8782;
 private static final int GAZKH = 8784;
 
 private final L2BossZone _zone;
 
 private Q641_AttackSailren(int id, String name, String descr) {
     super(id, name, descr);
     _zone = GrandBossManager.getInstance().getZone(27734, -6938, -1982); // Lair of Sailren
     //questItemIds = null;
 }

 @Override
 public String onEvent(String event, QuestState st)
 {
   String htmltext = event;
   if (event.equals("32109-03.htm")) {
     st.set("cond", "1");
     st.setState(State.STARTED);
     st.playSound("ItemSound.quest_accept");
   }
   else if (event.equals("32109-05.htm")) {
     st.playSound("ItemSound.quest_finish");
     st.takeItems(FRAGMENTS, 30);
     st.giveItems(GAZKH,1);
     st.exitQuest(true);
   }
   return htmltext;
 }

 @Override
 public String onTalk(L2Npc npc, L2PcInstance player)
 {
   QuestState st = player.getQuestState(qn);
   String htmltext = getNoQuestMsg(player);//"<html><body>NGXg𐋍sĂȂ܂B</body></html>";
   if (st == null) return htmltext;
   final int npcId = npc.getNpcId();
   final int id = st.getState();
   final int cond = st.getInt("cond");
   if (npcId == STATUE) {
     if (id == State.CREATED) {
       if (player.getLevel() >= 77)
         htmltext = "32109-01.htm";
       else {
         st.exitQuest(true);
         return "32109-00.htm";
       }
     }
     else if (cond == 1)
       htmltext = "32109-03.htm";
     else if (cond == 2)
       htmltext = "32109-04.htm";
   }
   return htmltext;
 }

 @Override
 public String onKill(L2Npc npc, L2PcInstance player, boolean isPet)
 {
   if (_zone.isInsideZone(player)) return null; // [JOJO] Lair of Sailren
   L2PcInstance partyMember = getRandomPartyMember(player, "1");
   if (partyMember == null) return null;
   QuestState st = partyMember.getQuestState(qn);
   if (st == null) return null;
   if (st.getState() == State.STARTED) {
     switch (npc.getNpcId()) {
     case VEL1:
     case VEL2:
     case VEL3:
     case VEL4:
     case VEL5:
     case PTE:
       if (st.getQuestItemsCount(FRAGMENTS) < 30) {
         st.giveItems(FRAGMENTS, 1);
         if (st.getQuestItemsCount(FRAGMENTS) == 30) {
           st.playSound("ItemSound.quest_middle");
           st.set("cond","2");
         }
         else
           st.playSound("ItemSound.quest_itemget");
       }
       break;
     }
   }
   return null;
 }

 public static void main(String args[])
 {
    Quest QUEST = new Q641_AttackSailren(641, qn, "TCɌēˌI");
    
    QUEST.addStartNpc(STATUE);
    
    QUEST.addTalkId(STATUE);
    
    QUEST.addKillId(VEL1);
    QUEST.addKillId(VEL2);
    QUEST.addKillId(VEL3);
    QUEST.addKillId(VEL4);
    QUEST.addKillId(VEL5);
    QUEST.addKillId(PTE);
 }
}