/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.admincommandhandlers;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SpecialCamera;

public class AdminCamera implements IAdminCommandHandler
{
	private static final String[] ADMIN_COMMANDS =
	{
		"admin_camera"
	};
	
	public boolean useAdminCommand(String command, L2PcInstance activeChar)
	{
		//[JOJO]-------------------------------------------------
		if (command.equals("admin_camera")) return showCameraHtml(activeChar);	/* "//camera" */
		if (command.contains(" | ")) return useCameraHtml(command, activeChar);	/* "admin_camera | 1000 | 10 | ...." */
		//-------------------------------------------------------
		try
		{
			final L2Character target = (L2Character)activeChar.getTarget();
			final String[] com = command.split(" ");
			
			target.broadcastPacket(new SpecialCamera(target.getObjectId(), Integer.parseInt(com[1]),
					Integer.parseInt(com[2]), Integer.parseInt(com[3]), Integer.parseInt(com[4]),
					Integer.parseInt(com[5]), Integer.parseInt(com[6]), Integer.parseInt(com[7]),
					Integer.parseInt(com[8]), Integer.parseInt(com[9])));
		}
		catch (Exception e)
		{
			activeChar.sendMessage("Usage: //camera distance yaw pitch time duration turn rise widescreen unknown");
			return false;
		}
		return true;
	}
	
	//[JOJO]-------------------------------------------------
	private class AdminCameraValues { public int distance, yaw, pitch, time, duration, turn, rise, widescreen, unknown; }
	private javolution.util.FastMap<Integer, AdminCameraValues> _cameraParamPool = new javolution.util.FastMap<Integer, AdminCameraValues>();

	private boolean useCameraHtml(String command, L2PcInstance activeChar)
	{
		try
		{
			final L2Character target = (L2Character)activeChar.getTarget();
			String[] com = command.split(" *\\| *", 10);
			if (com.length != 10)
				throw new RuntimeException();
			AdminCameraValues camera = _cameraParamPool.get(activeChar.getObjectId());
			if (camera == null) camera = new AdminCameraValues();
			camera.distance = parseInt(com[1], camera.distance);
			camera.yaw = parseInt(com[2], camera.yaw);
			camera.pitch = parseInt(com[3], camera.pitch);
			camera.time = parseInt(com[4], camera.time);
			camera.duration = parseInt(com[5], camera.duration);
			camera.turn = parseInt(com[6], camera.turn);
			camera.rise = parseInt(com[7], camera.rise);
			camera.widescreen = parseInt(com[8], camera.widescreen);
			camera.unknown = parseInt(com[9], camera.unknown);

			target.broadcastPacket(new SpecialCamera(target.getObjectId()
					, camera.distance, camera.yaw, camera.pitch, camera.time, camera.duration, camera.turn, camera.rise, camera.widescreen, camera.unknown));
			_cameraParamPool.put(activeChar.getObjectId(), camera);
			class $ implements Runnable {
				final L2PcInstance activeChar;
				$(L2PcInstance activeChar) {this.activeChar = activeChar;}
				public void run(){showCameraHtml(activeChar);}
			}
			ThreadPoolManager.getInstance().scheduleGeneral(new $(activeChar), camera.duration + 1000);
		}
		catch (Exception e)
		{
			activeChar.sendMessage("Usage: //camera distance yaw pitch time duration turn rise widescreen unknown");
			return false;
		}
		return true;
	}

	private int parseInt(String key, int defaultValue)
	{
		try {
			return Integer.parseInt(key);
		} catch (NumberFormatException e) {
			return defaultValue;
		}
	}

	private boolean showCameraHtml(L2PcInstance activeChar)
	{
		NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
		String content = HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/admin/camera.htm");
		
		AdminCameraValues camera = _cameraParamPool.get(activeChar.getObjectId());
		if (camera == null) {
			content = content.replaceAll("%\\w+?%", "");
			adminReply.setHtml(content);
		}
		else
		{
			adminReply.setHtml(content);
			adminReply.replace("%distance%", camera.distance);
			adminReply.replace("%yaw%", camera.yaw);
			adminReply.replace("%pitch%", camera.pitch);
			adminReply.replace("%time%", camera.time);
			adminReply.replace("%duration%", camera.duration);
			adminReply.replace("%turn%", camera.turn);
			adminReply.replace("%rise%", camera.rise);
			adminReply.replace("%widescreen%", camera.widescreen);
			adminReply.replace("%unknown%", camera.unknown);
		}

		activeChar.sendPacket(adminReply);
		return true;
	}
	//-------------------------------------------------------

	public String[] getAdminCommandList()
	{
		return ADMIN_COMMANDS;
	}
}