/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import gnu.trove.function.TObjectFunction;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class L2TIntObjectHashMap<V>
extends TIntObjectHashMap<V> {
    private static final long serialVersionUID = 1L;
    private final Lock _readLock;
    private final Lock _writeLock;
    private boolean _tempWritesLockDisable;

    public L2TIntObjectHashMap() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this._readLock = lock.readLock();
        this._writeLock = lock.writeLock();
        this._tempWritesLockDisable = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(int key, V value) {
        this._writeLock.lock();
        try {
            Object object = super.put(key, value);
            return (V)object;
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public V unsynchronizedPut(int key, V value) {
        return (V)super.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(int key) {
        if (!this._tempWritesLockDisable) {
            this._readLock.lock();
        }
        try {
            Object object = super.get(key);
            return (V)object;
        }
        finally {
            if (!this._tempWritesLockDisable) {
                this._readLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this._writeLock.lock();
        try {
            super.clear();
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(int key) {
        if (!this._tempWritesLockDisable) {
            this._writeLock.lock();
        }
        try {
            Object object = super.remove(key);
            return (V)object;
        }
        finally {
            if (!this._tempWritesLockDisable) {
                this._writeLock.unlock();
            }
        }
    }

    public V unsynchronizedRemove(int key) {
        return (V)super.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        this._readLock.lock();
        try {
            boolean bl = super.equals(other);
            return bl;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V[] values() {
        this._readLock.lock();
        try {
            Object[] objectArray = super.values();
            return objectArray;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V[] values(V[] arg0) {
        this._readLock.lock();
        try {
            Object[] objectArray = super.values((Object[])arg0);
            return objectArray;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] keys() {
        this._readLock.lock();
        try {
            int[] nArray = super.keys();
            return nArray;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] keys(int[] arg0) {
        this._readLock.lock();
        try {
            int[] nArray = super.keys(arg0);
            return nArray;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int val) {
        this._readLock.lock();
        try {
            boolean bl = super.contains(val);
            return bl;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object arg0) {
        this._readLock.lock();
        try {
            boolean bl = super.containsValue(arg0);
            return bl;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(int key) {
        this._readLock.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEachKey(TIntProcedure procedure) {
        this._readLock.lock();
        try {
            boolean bl = super.forEachKey(procedure);
            return bl;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean safeForEachKey(TIntProcedure procedure) {
        this._writeLock.lock();
        try {
            this._tempWritesLockDisable = true;
            boolean bl = super.forEachKey(procedure);
            return bl;
        }
        finally {
            this._tempWritesLockDisable = false;
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEachValue(TObjectProcedure<? super V> arg0) {
        this._readLock.lock();
        try {
            boolean bl = super.forEachValue(arg0);
            return bl;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean safeForEachValue(TObjectProcedure<V> arg0) {
        this._writeLock.lock();
        try {
            this._tempWritesLockDisable = true;
            boolean bl = super.forEachValue(arg0);
            return bl;
        }
        finally {
            this._tempWritesLockDisable = false;
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forEachEntry(TIntObjectProcedure<? super V> arg0) {
        this._readLock.lock();
        try {
            boolean bl = super.forEachEntry(arg0);
            return bl;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean safeForEachEntry(TIntObjectProcedure<V> arg0) {
        this._writeLock.lock();
        try {
            this._tempWritesLockDisable = true;
            boolean bl = super.forEachEntry(arg0);
            return bl;
        }
        finally {
            this._tempWritesLockDisable = false;
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TIntObjectProcedure<? super V> arg0) {
        this._writeLock.lock();
        try {
            boolean bl = super.retainEntries(arg0);
            return bl;
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformValues(TObjectFunction<V, V> arg0) {
        this._writeLock.lock();
        try {
            super.transformValues(arg0);
        }
        finally {
            this._writeLock.unlock();
        }
    }
}

