/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.templates.chars;

import com.l2jserver.gameserver.datatables.HerbDropTable;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.model.L2DropCategory;
import com.l2jserver.gameserver.model.L2DropData;
import com.l2jserver.gameserver.model.L2MinionData;
import com.l2jserver.gameserver.model.L2NpcAIData;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class L2NpcTemplate
extends L2CharTemplate {
    private static final Logger _log = Logger.getLogger(L2NpcTemplate.class.getName());
    private final int _npcId;
    private final int _idTemplate;
    private final String _type;
    private final String _name;
    private final boolean _serverSideName;
    private final String _title;
    private final boolean _serverSideTitle;
    private final String _sex;
    private final byte _level;
    private final int _rewardExp;
    private final int _rewardSp;
    private final int _rHand;
    private final int _lHand;
    private final int _enchantEffect;
    private Race _race;
    private final String _clientClass;
    private final int _dropHerbGroup;
    private final boolean _isCustom;
    private final boolean _isQuestMonster;
    private final float _baseVitalityDivider;
    private final FastList<L2Skill> _buffSkills = new FastList();
    private final FastList<L2Skill> _negativeSkills = new FastList();
    private final FastList<L2Skill> _debuffSkills = new FastList();
    private final FastList<L2Skill> _atkSkills = new FastList();
    private final FastList<L2Skill> _rootSkills = new FastList();
    private final FastList<L2Skill> _stunskills = new FastList();
    private final FastList<L2Skill> _sleepSkills = new FastList();
    private final FastList<L2Skill> _paralyzeSkills = new FastList();
    private final FastList<L2Skill> _fossilSkills = new FastList();
    private final FastList<L2Skill> _floatSkills = new FastList();
    private final FastList<L2Skill> _immobilizeSkills = new FastList();
    private final FastList<L2Skill> _healSkills = new FastList();
    private final FastList<L2Skill> _resSkills = new FastList();
    private final FastList<L2Skill> _dotSkills = new FastList();
    private final FastList<L2Skill> _cotSkills = new FastList();
    private final FastList<L2Skill> _universalSkills = new FastList();
    private final FastList<L2Skill> _manaSkills = new FastList();
    private final FastList<L2Skill> _longRangeSkills = new FastList();
    private final FastList<L2Skill> _shortRangeSkills = new FastList();
    private final FastList<L2Skill> _generalSkills = new FastList();
    private final FastList<L2Skill> _suicideSkills = new FastList();
    private L2NpcAIData _AIdataStatic = new L2NpcAIData();
    private final FastList<L2DropCategory> _categories = new FastList();
    private final List<L2MinionData> _minions = new FastList();
    private final List<ClassId> _teachInfo = new FastList();
    private final TIntObjectHashMap<L2Skill> _skills = new TIntObjectHashMap();
    private final Map<Quest.QuestEventType, Quest[]> _questEvents = new FastMap();

    public static boolean isAssignableTo(Class<?> sub, Class<?> clazz) {
        if (clazz.isInterface()) {
            Class<?>[] interfaces;
            for (Class<?> interface1 : interfaces = sub.getInterfaces()) {
                if (!clazz.getName().equals(interface1.getName())) continue;
                return true;
            }
        } else {
            do {
                if (!sub.getName().equals(clazz.getName())) continue;
                return true;
            } while ((sub = sub.getSuperclass()) != null);
        }
        return false;
    }

    public static boolean isAssignableTo(Object obj, Class<?> clazz) {
        return L2NpcTemplate.isAssignableTo(obj.getClass(), clazz);
    }

    public L2NpcTemplate(StatsSet set) {
        super(set);
        this._npcId = set.getInteger("npcId");
        this._idTemplate = set.getInteger("idTemplate");
        this._type = StringIntern.intern(set.getString("type"));
        this._name = StringIntern.intern(set.getString("name"));
        this._serverSideName = set.getBool("serverSideName");
        this._title = StringIntern.intern(set.getString("title"));
        this._isQuestMonster = this.getTitle().equalsIgnoreCase("Quest Monster") || this.getTitle().equals("\u30af\u30a8\u30b9\u30c8\u30e2\u30f3\u30b9\u30bf\u30fc");
        this._serverSideTitle = set.getBool("serverSideTitle");
        this._sex = StringIntern.intern(set.getString("sex"));
        this._level = set.getByte("level");
        this._rewardExp = set.getInteger("rewardExp");
        this._rewardSp = set.getInteger("rewardSp");
        this._rHand = set.getInteger("rhand");
        this._lHand = set.getInteger("lhand");
        this._enchantEffect = set.getInteger("enchant");
        this._race = null;
        int herbGroup = set.getInteger("dropHerbGroup");
        if (herbGroup > 0 && HerbDropTable.getInstance().getHerbDroplist(herbGroup) == null) {
            _log.warning("Missing Herb Drop Group for npcId: " + this.getNpcId());
            this._dropHerbGroup = 0;
        } else {
            this._dropHerbGroup = herbGroup;
        }
        this._clientClass = StringIntern.intern(set.getString("client_class"));
        this._baseVitalityDivider = this.getLevel() > 0 && this.getRewardExp() > 0 ? this.getBaseHpMax() * 9.0f * (float)this.getLevel() * (float)this.getLevel() / (float)(100 * this.getRewardExp()) : 0.0f;
        this._isCustom = this._npcId != this._idTemplate;
    }

    public void addAtkSkill(L2Skill skill) {
        this._atkSkills.add((Object)skill);
    }

    public void addBuffSkill(L2Skill skill) {
        this._buffSkills.add((Object)skill);
    }

    public void addCOTSkill(L2Skill skill) {
        this._cotSkills.add((Object)skill);
    }

    public void addDebuffSkill(L2Skill skill) {
        this._debuffSkills.add((Object)skill);
    }

    public void addDOTSkill(L2Skill skill) {
        this._dotSkills.add((Object)skill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDropData(L2DropData drop, int categoryType) {
        if (!drop.isQuestDrop()) {
            FastList<L2DropCategory> fastList = this._categories;
            synchronized (fastList) {
                boolean catExists = false;
                for (L2DropCategory cat : this._categories) {
                    if (cat.getCategoryType() != categoryType) continue;
                    cat.addDropData(drop, this.isType("L2RaidBoss") || this.isType("L2GrandBoss"));
                    catExists = true;
                    break;
                }
                if (!catExists) {
                    L2DropCategory cat = new L2DropCategory(categoryType);
                    cat.addDropData(drop, this.isType("L2RaidBoss") || this.isType("L2GrandBoss"));
                    this._categories.add((Object)cat);
                }
            }
        }
    }

    public void addFloatSkill(L2Skill skill) {
        this._floatSkills.add((Object)skill);
    }

    public void addFossilSkill(L2Skill skill) {
        this._fossilSkills.add((Object)skill);
    }

    public void addGeneralSkill(L2Skill skill) {
        this.getGeneralskills().add((Object)skill);
    }

    public void addHealSkill(L2Skill skill) {
        this._healSkills.add((Object)skill);
    }

    public void addImmobiliseSkill(L2Skill skill) {
        this._immobilizeSkills.add((Object)skill);
    }

    public void addManaHealSkill(L2Skill skill) {
        this._manaSkills.add((Object)skill);
    }

    public void addNegativeSkill(L2Skill skill) {
        this._negativeSkills.add((Object)skill);
    }

    public void addParalyzeSkill(L2Skill skill) {
        this._paralyzeSkills.add((Object)skill);
    }

    public void addQuestEvent(Quest.QuestEventType EventType, Quest q) {
        if (this._questEvents.get((Object)EventType) == null) {
            this._questEvents.put(EventType, new Quest[]{q});
        } else {
            Quest[] _quests = this._questEvents.get((Object)EventType);
            int len = _quests.length;
            if (!EventType.isMultipleRegistrationAllowed()) {
                if (_quests[0].getName().equals(q.getName()) || L2NpcTemplate.isAssignableTo(q, _quests[0].getClass())) {
                    _quests[0] = q;
                } else {
                    _log.warning("Quest event not allowed in multiple quests.  Skipped addition of Event Type \"" + (Object)((Object)EventType) + "\" for NPC \"" + this._name + "\" and quest \"" + q.getName() + "\".");
                }
            } else {
                Quest[] tmp = new Quest[len + 1];
                for (int i = 0; i < len; ++i) {
                    if (_quests[i].getName().equals(q.getName()) || L2NpcTemplate.isAssignableTo(q, _quests[i].getClass())) {
                        _quests[i] = q;
                        return;
                    }
                    if (L2NpcTemplate.isAssignableTo(_quests[i], q.getClass())) {
                        return;
                    }
                    tmp[i] = _quests[i];
                }
                tmp[len] = q;
                this._questEvents.put(EventType, tmp);
            }
        }
    }

    public void addRaidData(L2MinionData minion) {
        this._minions.add(minion);
    }

    public void addRangeSkill(L2Skill skill) {
        if (skill.getCastRange() <= 150 && skill.getCastRange() > 0) {
            this._shortRangeSkills.add((Object)skill);
        } else if (skill.getCastRange() > 150) {
            this._longRangeSkills.add((Object)skill);
        }
    }

    public void addResSkill(L2Skill skill) {
        this._resSkills.add((Object)skill);
    }

    public void addRootSkill(L2Skill skill) {
        this._rootSkills.add((Object)skill);
    }

    public void addSkill(L2Skill skill) {
        if (!skill.isPassive()) {
            if (skill.isSuicideAttack()) {
                this.addSuicideSkill(skill);
            } else {
                this.addGeneralSkill(skill);
                switch (skill.getSkillType()) {
                    case BUFF: {
                        this.addBuffSkill(skill);
                        break;
                    }
                    case HEAL: 
                    case HOT: 
                    case HEAL_PERCENT: 
                    case HEAL_STATIC: 
                    case BALANCE_LIFE: {
                        this.addHealSkill(skill);
                        break;
                    }
                    case RESURRECT: {
                        this.addResSkill(skill);
                        break;
                    }
                    case DEBUFF: {
                        this.addDebuffSkill(skill);
                        this.addCOTSkill(skill);
                        this.addRangeSkill(skill);
                        break;
                    }
                    case ROOT: {
                        this.addRootSkill(skill);
                        this.addImmobiliseSkill(skill);
                        this.addRangeSkill(skill);
                        break;
                    }
                    case SLEEP: {
                        this.addSleepSkill(skill);
                        this.addImmobiliseSkill(skill);
                        break;
                    }
                    case STUN: {
                        this.addRootSkill(skill);
                        this.addImmobiliseSkill(skill);
                        this.addRangeSkill(skill);
                        break;
                    }
                    case PARALYZE: {
                        this.addParalyzeSkill(skill);
                        this.addImmobiliseSkill(skill);
                        this.addRangeSkill(skill);
                        break;
                    }
                    case PDAM: 
                    case MDAM: 
                    case BLOW: 
                    case DRAIN: 
                    case CHARGEDAM: 
                    case FATAL: 
                    case DEATHLINK: 
                    case CPDAM: 
                    case MANADAM: 
                    case CPDAMPERCENT: {
                        this.addAtkSkill(skill);
                        this.addUniversalSkill(skill);
                        this.addRangeSkill(skill);
                        break;
                    }
                    case POISON: 
                    case DOT: 
                    case MDOT: 
                    case BLEED: {
                        this.addDOTSkill(skill);
                        this.addRangeSkill(skill);
                        break;
                    }
                    case MUTE: 
                    case FEAR: {
                        this.addCOTSkill(skill);
                        this.addRangeSkill(skill);
                        break;
                    }
                    case CANCEL: 
                    case NEGATE: {
                        this.addNegativeSkill(skill);
                        this.addRangeSkill(skill);
                        break;
                    }
                    default: {
                        this.addUniversalSkill(skill);
                    }
                }
            }
        }
        this._skills.put(skill.getId(), (Object)skill);
    }

    public void addSleepSkill(L2Skill skill) {
        this._sleepSkills.add((Object)skill);
    }

    public void addStunSkill(L2Skill skill) {
        this._stunskills.add((Object)skill);
    }

    public void addSuicideSkill(L2Skill skill) {
        this._suicideSkills.add((Object)skill);
    }

    public void addTeachInfo(ClassId classId) {
        this._teachInfo.add(classId);
    }

    public void addUniversalSkill(L2Skill skill) {
        this._universalSkills.add((Object)skill);
    }

    public boolean canTeach(ClassId classId) {
        if (classId.level() == 3) {
            return this._teachInfo.contains((Object)classId.getParent());
        }
        return this._teachInfo.contains((Object)classId);
    }

    public synchronized void clearAllDropData() {
        while (!this._categories.isEmpty()) {
            ((L2DropCategory)this._categories.getFirst()).clearAllDrops();
            this._categories.removeFirst();
        }
        this._categories.clear();
    }

    public L2NpcAIData getAIDataStatic() {
        return this._AIdataStatic;
    }

    public List<L2DropData> getAllDropData() {
        FastList list = new FastList();
        for (L2DropCategory tmp : this._categories) {
            list.addAll(tmp.getAllDrops());
        }
        return list;
    }

    public FastList<L2Skill> getAtkSkills() {
        return this._atkSkills;
    }

    public float getBaseVitalityDivider() {
        return this._baseVitalityDivider;
    }

    public FastList<L2Skill> getBuffSkills() {
        return this._buffSkills;
    }

    public String getClientClass() {
        return this._clientClass;
    }

    public FastList<L2Skill> getCostOverTimeSkills() {
        return this._cotSkills;
    }

    public FastList<L2Skill> getDebuffSkills() {
        return this._debuffSkills;
    }

    public FastList<L2DropCategory> getDropData() {
        return this._categories;
    }

    public int getDropHerbGroup() {
        return this._dropHerbGroup;
    }

    public int getEnchantEffect() {
        return this._enchantEffect;
    }

    public Map<Quest.QuestEventType, Quest[]> getEventQuests() {
        return this._questEvents;
    }

    public Quest[] getEventQuests(Quest.QuestEventType EventType) {
        return this._questEvents.get((Object)EventType);
    }

    public FastList<L2Skill> getGeneralskills() {
        return this._generalSkills;
    }

    public FastList<L2Skill> getHealSkills() {
        return this._healSkills;
    }

    public int getIdTemplate() {
        return this._idTemplate;
    }

    public FastList<L2Skill> getImmobiliseSkills() {
        return this._immobilizeSkills;
    }

    public int getLeftHand() {
        return this._lHand;
    }

    public byte getLevel() {
        return this._level;
    }

    public FastList<L2Skill> getLongRangeSkills() {
        return this._longRangeSkills;
    }

    public List<L2MinionData> getMinionData() {
        return this._minions;
    }

    public String getName() {
        return this._name;
    }

    public FastList<L2Skill> getNegativeSkills() {
        return this._negativeSkills;
    }

    public int getNpcId() {
        return this._npcId;
    }

    public Race getRace() {
        if (this._race == null) {
            this._race = Race.NONE;
        }
        return this._race;
    }

    public FastList<L2Skill> getResSkills() {
        return this._resSkills;
    }

    public int getRewardExp() {
        return this._rewardExp;
    }

    public int getRewardSp() {
        return this._rewardSp;
    }

    public int getRightHand() {
        return this._rHand;
    }

    public String getSex() {
        return this._sex;
    }

    public FastList<L2Skill> getShortRangeSkills() {
        return this._shortRangeSkills;
    }

    public TIntObjectHashMap<L2Skill> getSkills() {
        return this._skills;
    }

    public L2Skill[] getSkillsArray() {
        return (L2Skill[])this._skills.values((Object[])new L2Skill[0]);
    }

    public FastList<L2Skill> getSuicideSkills() {
        return this._suicideSkills;
    }

    public List<ClassId> getTeachInfo() {
        return this._teachInfo;
    }

    public String getTitle() {
        return this._title;
    }

    public String getType() {
        return this._type;
    }

    public FastList<L2Skill> getUniversalSkills() {
        return this._universalSkills;
    }

    public boolean isCustom() {
        return this._isCustom;
    }

    public boolean isQuestMonster() {
        return this._isQuestMonster;
    }

    public boolean isServerSideName() {
        return this._serverSideName;
    }

    public boolean isServerSideTitle() {
        return this._serverSideTitle;
    }

    public boolean isType(String t) {
        return this._type.equalsIgnoreCase(t);
    }

    public boolean isUndead() {
        return this._race == Race.UNDEAD;
    }

    public void setAIData(L2NpcAIData AIData) {
        this._AIdataStatic = AIData;
    }

    public void setRace(int raceId) {
        switch (raceId) {
            case 1: {
                this._race = Race.UNDEAD;
                break;
            }
            case 2: {
                this._race = Race.MAGICCREATURE;
                break;
            }
            case 3: {
                this._race = Race.BEAST;
                break;
            }
            case 4: {
                this._race = Race.ANIMAL;
                break;
            }
            case 5: {
                this._race = Race.PLANT;
                break;
            }
            case 6: {
                this._race = Race.HUMANOID;
                break;
            }
            case 7: {
                this._race = Race.SPIRIT;
                break;
            }
            case 8: {
                this._race = Race.ANGEL;
                break;
            }
            case 9: {
                this._race = Race.DEMON;
                break;
            }
            case 10: {
                this._race = Race.DRAGON;
                break;
            }
            case 11: {
                this._race = Race.GIANT;
                break;
            }
            case 12: {
                this._race = Race.BUG;
                break;
            }
            case 13: {
                this._race = Race.FAIRIE;
                break;
            }
            case 14: {
                this._race = Race.HUMAN;
                break;
            }
            case 15: {
                this._race = Race.ELVE;
                break;
            }
            case 16: {
                this._race = Race.DARKELVE;
                break;
            }
            case 17: {
                this._race = Race.ORC;
                break;
            }
            case 18: {
                this._race = Race.DWARVE;
                break;
            }
            case 19: {
                this._race = Race.OTHER;
                break;
            }
            case 20: {
                this._race = Race.NONLIVING;
                break;
            }
            case 21: {
                this._race = Race.SIEGEWEAPON;
                break;
            }
            case 22: {
                this._race = Race.DEFENDINGARMY;
                break;
            }
            case 23: {
                this._race = Race.MERCENARIE;
                break;
            }
            case 24: {
                this._race = Race.UNKNOWN;
                break;
            }
            case 25: {
                this._race = Race.KAMAEL;
                break;
            }
            default: {
                this._race = Race.NONE;
            }
        }
    }

    public static enum Race {
        UNDEAD,
        MAGICCREATURE,
        BEAST,
        ANIMAL,
        PLANT,
        HUMANOID,
        SPIRIT,
        ANGEL,
        DEMON,
        DRAGON,
        GIANT,
        BUG,
        FAIRIE,
        HUMAN,
        ELVE,
        DARKELVE,
        ORC,
        DWARVE,
        OTHER,
        NONLIVING,
        SIEGEWEAPON,
        DEFENDINGARMY,
        MERCENARIE,
        UNKNOWN,
        KAMAEL,
        NONE;

    }

    public static enum AIType {
        FIGHTER,
        ARCHER,
        BALANCED,
        MAGE,
        HEALER,
        CORPSE;

    }
}

