/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.templates;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

@Deprecated
public class L2BuffTemplate {
    private int _templateId;
    private String _templateName;
    private int _skillId;
    private int _skillOrder;
    private L2Skill _skill;
    private int _skillLevel;
    private boolean _forceCast;
    private int _minLevel;
    private int _maxLevel;
    private int _faction;
    private int _race;
    private int _class;
    private int _adena;
    private int _points;

    public L2BuffTemplate(ResultSet set) throws SQLException {
        this._templateId = set.getInt("id");
        this._templateName = set.getString("name");
        this._skillId = set.getInt("skill_id");
        this._skillLevel = set.getInt("skill_level");
        this._skillOrder = set.getInt("skill_order");
        this._skillLevel = this.getMaxLevel(this._skillId, this._skillLevel);
        this._skill = SkillTable.getInstance().getInfo(this._skillId, this._skillLevel);
        this._forceCast = set.getInt("skill_force") == 1;
        this._minLevel = set.getInt("char_min_level");
        this._maxLevel = set.getInt("char_max_level");
        this._race = set.getInt("char_race");
        this._class = set.getInt("char_class");
        this._faction = set.getInt("char_faction");
        this._adena = set.getInt("price_adena");
        this._points = set.getInt("price_points");
        if (this._skillLevel != set.getInt("skill_level")) {
            try {
                FileWriter f = new FileWriter("__npcbuf__.sql", true);
                f.write("-- " + this._skillId + " " + set.getInt("skill_level") + " " + SkillTable.getInstance().getInfo(this._skillId, this._skillLevel).getName() + "\n");
                f.write("UPDATE npc_buffer_list SET skill_level=" + this._skillLevel + " WHERE id=" + this._templateId + "\n");
                f.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    int getMaxLevel(int magicId, int level) {
        return SkillTable.getInstance().getInfo(magicId, 130) != null ? 130 : level;
    }

    public int getId() {
        return this._templateId;
    }

    public String getName() {
        return this._templateName;
    }

    public int getSkillId() {
        return this._skillId;
    }

    public int getSkillOrder() {
        return this._skillOrder;
    }

    public int getSkillLevel() {
        return this._skillLevel;
    }

    public L2Skill getSkill() {
        return this._skill;
    }

    public int getMinLevel() {
        return this._minLevel;
    }

    public int getMaxLevel() {
        return this._maxLevel;
    }

    public int getFaction() {
        return this._faction;
    }

    public int getAdenaPrice() {
        return this._adena;
    }

    public int getPointsPrice() {
        return this._points;
    }

    public boolean forceCast() {
        return this._forceCast;
    }

    public boolean checkLevel(L2PcInstance player) {
        return !(this._minLevel != 0 && player.getLevel() < this._minLevel || this._maxLevel != 0 && player.getLevel() > this._maxLevel);
    }

    public boolean checkRace(L2PcInstance player) {
        if (this._race == 0 || this._race == 63) {
            return true;
        }
        switch (player.getRace()) {
            case Kamael: {
                return (this._race & 0x20) != 0;
            }
            case Human: {
                return (this._race & 0x10) != 0;
            }
            case Elf: {
                return (this._race & 8) != 0;
            }
            case DarkElf: {
                return (this._race & 4) != 0;
            }
            case Orc: {
                return (this._race & 2) != 0;
            }
            case Dwarf: {
                return (this._race & 1) != 0;
            }
        }
        return false;
    }

    public boolean checkClass(L2PcInstance player) {
        return this._class == 0 || this._class == 3 || this._class == 1 && !player.isMageClass() || this._class == 2 && player.isMageClass();
    }

    public boolean checkFaction(L2PcInstance player) {
        return true;
    }

    public boolean checkPlayer(L2PcInstance player) {
        return this.checkLevel(player) && this.checkRace(player) && this.checkClass(player) && this.checkFaction(player);
    }
}

