/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.l2skills;

import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Trap;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrapInstance;
import com.l2jserver.gameserver.skills.l2skills.L2SkillSummon;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2SkillTrap
extends L2SkillSummon {
    private int _triggerSkillId = 0;
    private int _triggerSkillLvl = 0;
    private int _trapNpcId = 0;
    protected L2Spawn _trapSpawn;

    public L2SkillTrap(StatsSet set) {
        super(set);
        this._triggerSkillId = set.getInteger("triggerSkillId");
        this._triggerSkillLvl = set.getInteger("triggerSkillLvl");
        this._trapNpcId = set.getInteger("trapNpcId");
    }

    public int getTriggerSkillId() {
        return this._triggerSkillId;
    }

    @Override
    public void useSkill(L2Character caster, L2Object[] targets) {
        L2Skill skill;
        if (caster.isAlikeDead() || !(caster instanceof L2PcInstance)) {
            return;
        }
        if (this._trapNpcId == 0) {
            return;
        }
        L2PcInstance activeChar = (L2PcInstance)caster;
        if (activeChar.inObserverMode()) {
            return;
        }
        if (activeChar.isMounted()) {
            return;
        }
        if (this._triggerSkillId == 0 || this._triggerSkillLvl == 0) {
            return;
        }
        L2Trap trap = activeChar.getTrap();
        if (trap != null) {
            trap.unSummon();
        }
        if ((skill = SkillTable.getInstance().getInfo(this._triggerSkillId, this._triggerSkillLvl)) == null) {
            return;
        }
        L2NpcTemplate TrapTemplate = NpcTable.getInstance().getTemplate(this._trapNpcId);
        trap = new L2TrapInstance(IdFactory.getInstance().getNextId(), TrapTemplate, activeChar, this.getTotalLifeTime(), skill);
        trap.setCurrentHp(trap.getMaxHp());
        trap.setCurrentMp(trap.getMaxMp());
        trap.setIsInvul(true);
        trap.setHeading(activeChar.getHeading());
        activeChar.setTrap(trap);
        trap.spawnMe(activeChar.getX(), activeChar.getY(), activeChar.getZ());
    }
}

