/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.l2skills;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.PetItemList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;

public class L2SkillCreateItem
extends L2Skill {
    private final int[] _createItemId;
    private final int _createItemCount;
    private final int _randomCount;

    public L2SkillCreateItem(StatsSet set) {
        super(set);
        this._createItemId = set.getIntegerArray("create_item_id");
        this._createItemCount = set.getInteger("create_item_count", 0);
        this._randomCount = set.getInteger("random_count", 1);
    }

    @Override
    public void useSkill(L2Character activeChar, L2Object[] targets) {
        L2PcInstance player = activeChar.getActingPlayer();
        if (activeChar.isAlikeDead()) {
            return;
        }
        if (activeChar instanceof L2Playable) {
            if (this._createItemId == null || this._createItemCount == 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_PREPARED_FOR_REUSE);
                sm.addSkillName(this);
                player.sendPacket(sm);
                return;
            }
            int count = this._createItemCount + Rnd.nextInt(this._randomCount);
            int rndid = Rnd.nextInt(this._createItemId.length);
            if (activeChar instanceof L2PcInstance) {
                player.addItem("Skill", this._createItemId[rndid], count, activeChar, true);
            } else if (activeChar instanceof L2PetInstance) {
                activeChar.getInventory().addItem("Skill", this._createItemId[rndid], count, player, activeChar);
                player.sendPacket(new PetItemList((L2PetInstance)activeChar));
            }
        }
    }
}

