/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.item.L2Item;
import com.l2jserver.gameserver.skills.DocumentItem;
import com.l2jserver.gameserver.skills.DocumentSkill;
import com.l2jserver.util.file.filter.XMLFilter;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import javolution.util.FastList;

public class SkillsEngine {
    private static final Logger _log = Logger.getLogger(SkillsEngine.class.getName());

    public static SkillsEngine getInstance() {
        return SingletonHolder._instance;
    }

    private SkillsEngine() {
    }

    private void hashFiles(String dirname, List<File> hash) {
        File dir = new File(Config.DATAPACK_ROOT, dirname);
        if (!dir.exists()) {
            _log.warning("Dir " + dir.getAbsolutePath() + " not exists");
            return;
        }
        for (File f : dir.listFiles(new XMLFilter())) {
            hash.add(f);
        }
    }

    private List<L2Skill> loadSkills(File file) {
        if (file == null) {
            _log.warning("Skill file not found.");
            return null;
        }
        DocumentSkill doc = new DocumentSkill(file);
        doc.parse();
        return doc.getSkills();
    }

    public void loadAllSkills(TIntObjectHashMap<L2Skill> allSkills) {
        int count = 0;
        FastList files = new FastList();
        this.hashFiles("data/stats/skills", (List<File>)files);
        if (Config.CUSTOM_SKILLS_LOAD) {
            this.hashFiles("data/stats/skills/custom", (List<File>)files);
        }
        StringIntern.begin();
        for (File file : files) {
            List<L2Skill> s = this.loadSkills(file);
            if (s == null) continue;
            for (L2Skill skill : s) {
                allSkills.put(SkillTable.getSkillHashCode(skill), (Object)skill);
                ++count;
            }
        }
        StringIntern.end();
        _log.info(this.getClass().getSimpleName() + ": Loaded " + count + " Skill templates from XML files.");
    }

    public List<L2Item> loadItems() {
        FastList list = new FastList();
        FastList files = new FastList();
        this.hashFiles("data/stats/items", (List<File>)files);
        if (Config.CUSTOM_ITEMS_LOAD) {
            this.hashFiles("data/stats/items/custom", (List<File>)files);
        }
        StringIntern.begin();
        for (File f : files) {
            DocumentItem document = new DocumentItem(f);
            document.parse();
            list.addAll(document.getItemList());
        }
        StringIntern.end();
        return list;
    }

    private static class SingletonHolder {
        protected static final SkillsEngine _instance = new SkillsEngine();

        private SingletonHolder() {
        }
    }
}

