/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.logging.Logger;
import javolution.util.FastList;

public final class WareHouseDepositList
extends L2GameServerPacket {
    public static final int PRIVATE = 1;
    public static final int CLAN = 4;
    public static final int CASTLE = 3;
    public static final int FREIGHT = 1;
    private static Logger _log = Logger.getLogger(WareHouseDepositList.class.getName());
    private static final String _S__53_WAREHOUSEDEPOSITLIST = "[S] 41 WareHouseDepositList";
    private final long _playerAdena;
    private final FastList<L2ItemInstance> _items;
    private final int _whType;

    public WareHouseDepositList(L2PcInstance player, int type) {
        this._whType = type;
        this._playerAdena = player.getAdena();
        this._items = new FastList();
        boolean isPrivate = this._whType == 1;
        for (L2ItemInstance temp : player.getInventory().getAvailableItems(true, isPrivate, false)) {
            if (temp == null || !temp.isDepositable(isPrivate)) continue;
            this._items.add((Object)temp);
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(65);
        this.writeH(this._whType);
        this.writeQ(this._playerAdena);
        int count = this._items.size();
        if (Config.DEBUG) {
            _log.fine("count:" + count);
        }
        this.writeH(count);
        for (L2ItemInstance item : this._items) {
            this.writeD(item.getObjectId());
            this.writeD(item.getItemId());
            this.writeD(item.getLocationSlot());
            this.writeQ(item.getCount());
            this.writeH(item.getItem().getType2());
            this.writeH(item.getCustomType1());
            this.writeH(item.isEquipped() ? 1 : 0);
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchantLevel());
            this.writeH(item.getCustomType2());
            if (item.isAugmented()) {
                this.writeD(item.getAugmentation().getAugmentationId());
            } else {
                this.writeD(0);
            }
            this.writeD(item.getMana());
            this.writeD(item.isTimeLimitedItem() ? (int)(item.getRemainingTime() / 1000L) : -9999);
            this.writeH(item.getAttackElementType());
            this.writeH(item.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(item.getElementDefAttr(i));
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
            this.writeD(item.getObjectId());
        }
        this._items.clear();
    }

    @Override
    public String getType() {
        return _S__53_WAREHOUSEDEPOSITLIST;
    }
}

