/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.itemcontainer.Mail;
import com.l2jserver.gameserver.network.serverpackets.ExReplyReceivedPost;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.logging.Logger;

public class ExReplySentPost
extends L2GameServerPacket {
    private static final Logger _log = Logger.getLogger(ExReplyReceivedPost.class.getName());
    private Message _msg;
    private L2ItemInstance[] _items = null;

    public ExReplySentPost(Message msg) {
        this._msg = msg;
        if (msg.hasAttachments()) {
            Mail attachments = msg.getAttachments();
            if (attachments != null && attachments.getSize() > 0) {
                this._items = attachments.getItems();
            } else {
                _log.warning("Message " + msg.getId() + " has attachments but itemcontainer is empty.");
            }
        }
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(173);
        this.writeD(this._msg.getId());
        this.writeD(this._msg.isLocked() ? 1 : 0);
        this.writeS(this._msg.getReceiverName());
        this.writeS(this._msg.getSubject());
        this.writeS(this._msg.getContent());
        if (this._items != null && this._items.length > 0) {
            this.writeD(this._items.length);
            for (L2ItemInstance item : this._items) {
                this.writeD(0);
                this.writeD(item.getItemId());
                this.writeD(item.getLocationSlot());
                this.writeQ(item.getCount());
                this.writeH(item.getItem().getType2());
                this.writeH(item.getCustomType1());
                this.writeH(item.isEquipped() ? 1 : 0);
                this.writeD(item.getItem().getBodyPart());
                this.writeH(item.getEnchantLevel());
                this.writeH(item.getCustomType2());
                if (item.isAugmented()) {
                    this.writeD(item.getAugmentation().getAugmentationId());
                } else {
                    this.writeD(0);
                }
                this.writeD(item.getMana());
                this.writeD(item.isTimeLimitedItem() ? (int)(item.getRemainingTime() / 1000L) : -9999);
                this.writeH(item.getAttackElementType());
                this.writeH(item.getAttackElementPower());
                for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                    this.writeH(item.getElementDefAttr(i));
                }
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeD(item.getObjectId());
            }
            this.writeQ(this._msg.getReqAdena());
            this.writeD(this._msg.getSendBySystem());
        } else {
            this.writeD(0);
        }
        this._items = null;
        this._msg = null;
    }

    @Override
    public String getType() {
        return "[S] FE:AD ExReplySentPost";
    }
}

